/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.NetworkSpecifier;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.util.Objects;

public class EthernetNetworkSpecifier
extends NetworkSpecifier
implements Parcelable {
    private final String mInterfaceName;
    public static final Parcelable.Creator<EthernetNetworkSpecifier> CREATOR = new Parcelable.Creator<EthernetNetworkSpecifier>(){

        @Override
        public EthernetNetworkSpecifier createFromParcel(Parcel in) {
            return new EthernetNetworkSpecifier(in.readString());
        }

        public EthernetNetworkSpecifier[] newArray(int size) {
            return new EthernetNetworkSpecifier[size];
        }
    };

    public EthernetNetworkSpecifier(String interfaceName) {
        if (TextUtils.isEmpty(interfaceName)) {
            throw new IllegalArgumentException();
        }
        this.mInterfaceName = interfaceName;
    }

    public String getInterfaceName() {
        return this.mInterfaceName;
    }

    @Override
    public boolean canBeSatisfiedBy(NetworkSpecifier other) {
        return this.equals(other);
    }

    public boolean equals(Object o) {
        if (!(o instanceof EthernetNetworkSpecifier)) {
            return false;
        }
        return TextUtils.equals(this.mInterfaceName, ((EthernetNetworkSpecifier)o).mInterfaceName);
    }

    public int hashCode() {
        return Objects.hashCode(this.mInterfaceName);
    }

    public String toString() {
        return "EthernetNetworkSpecifier (" + this.mInterfaceName + ")";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mInterfaceName);
    }
}

