/*
 * Decompiled with CFR 0.152.
 */
package android.nearby;

import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.content.Context;
import android.nearby.BroadcastCallback;
import android.nearby.BroadcastRequest;
import android.nearby.BroadcastRequestParcelable;
import android.nearby.FastPairDevice;
import android.nearby.IBroadcastListener;
import android.nearby.INearbyManager;
import android.nearby.IScanListener;
import android.nearby.NearbyDevice;
import android.nearby.NearbyDeviceParcelable;
import android.nearby.PresenceDevice;
import android.nearby.PublicCredential;
import android.nearby.ScanCallback;
import android.nearby.ScanRequest;
import android.net.connectivity.com.android.internal.util.Preconditions;
import android.os.RemoteException;
import android.provider.Settings;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;

@SystemApi
public class NearbyManager {
    private static final String TAG = "NearbyManager";
    public static final String FAST_PAIR_SCAN_ENABLED = "fast_pair_scan_enabled";
    @GuardedBy(value={"sScanListeners"})
    private static final WeakHashMap<ScanCallback, WeakReference<ScanListenerTransport>> sScanListeners = new WeakHashMap();
    @GuardedBy(value={"sBroadcastListeners"})
    private static final WeakHashMap<BroadcastCallback, WeakReference<BroadcastListenerTransport>> sBroadcastListeners = new WeakHashMap();
    private final Context mContext;
    private final INearbyManager mService;

    NearbyManager(Context context, INearbyManager service) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(service);
        this.mContext = context;
        this.mService = service;
    }

    private static NearbyDevice toClientNearbyDevice(NearbyDeviceParcelable nearbyDeviceParcelable, int scanType) {
        if (scanType == 1) {
            return new FastPairDevice.Builder().setName(nearbyDeviceParcelable.getName()).addMedium(nearbyDeviceParcelable.getMedium()).setRssi(nearbyDeviceParcelable.getRssi()).setTxPower(nearbyDeviceParcelable.getTxPower()).setModelId(nearbyDeviceParcelable.getFastPairModelId()).setBluetoothAddress(nearbyDeviceParcelable.getBluetoothAddress()).setData(nearbyDeviceParcelable.getData()).build();
        }
        if (scanType == 2) {
            PublicCredential publicCredential = nearbyDeviceParcelable.getPublicCredential();
            if (publicCredential == null) {
                return null;
            }
            byte[] salt = nearbyDeviceParcelable.getSalt();
            if (salt == null) {
                salt = new byte[]{};
            }
            return new PresenceDevice.Builder(String.valueOf(publicCredential.hashCode()), salt, publicCredential.getSecretId(), publicCredential.getEncryptedMetadata()).setRssi(nearbyDeviceParcelable.getRssi()).addMedium(nearbyDeviceParcelable.getMedium()).build();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_SCAN", "android.permission.BLUETOOTH_PRIVILEGED"})
    @ScanStatus
    public int startScan(ScanRequest scanRequest, Executor executor, ScanCallback scanCallback) {
        Objects.requireNonNull(scanRequest, "scanRequest must not be null");
        Objects.requireNonNull(scanCallback, "scanCallback must not be null");
        Objects.requireNonNull(executor, "executor must not be null");
        try {
            WeakHashMap<ScanCallback, WeakReference<ScanListenerTransport>> weakHashMap = sScanListeners;
            synchronized (weakHashMap) {
                ScanListenerTransport transport;
                WeakReference<ScanListenerTransport> reference = sScanListeners.get(scanCallback);
                ScanListenerTransport scanListenerTransport = transport = reference != null ? (ScanListenerTransport)reference.get() : null;
                if (transport == null) {
                    transport = new ScanListenerTransport(scanRequest.getScanType(), scanCallback, executor);
                } else {
                    Preconditions.checkState(transport.isRegistered());
                    transport.setExecutor(executor);
                }
                int status = this.mService.registerScanListener(scanRequest, transport, this.mContext.getPackageName(), this.mContext.getAttributionTag());
                if (status != 1) {
                    return status;
                }
                sScanListeners.put(scanCallback, new WeakReference<ScanListenerTransport>(transport));
                return 1;
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"ExecutorRegistration"})
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_SCAN", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void stopScan(ScanCallback scanCallback) {
        Preconditions.checkArgument(scanCallback != null, "invalid null scanCallback");
        try {
            WeakHashMap<ScanCallback, WeakReference<ScanListenerTransport>> weakHashMap = sScanListeners;
            synchronized (weakHashMap) {
                ScanListenerTransport transport;
                WeakReference<ScanListenerTransport> reference = sScanListeners.remove(scanCallback);
                ScanListenerTransport scanListenerTransport = transport = reference != null ? (ScanListenerTransport)reference.get() : null;
                if (transport != null) {
                    transport.unregister();
                    this.mService.unregisterScanListener(transport, this.mContext.getPackageName(), this.mContext.getAttributionTag());
                } else {
                    Log.e(TAG, "Cannot stop scan with this callback because it is never registered.");
                }
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADVERTISE", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void startBroadcast(BroadcastRequest broadcastRequest, Executor executor, BroadcastCallback callback) {
        try {
            WeakHashMap<BroadcastCallback, WeakReference<BroadcastListenerTransport>> weakHashMap = sBroadcastListeners;
            synchronized (weakHashMap) {
                BroadcastListenerTransport transport;
                WeakReference<BroadcastListenerTransport> reference = sBroadcastListeners.get(callback);
                BroadcastListenerTransport broadcastListenerTransport = transport = reference != null ? (BroadcastListenerTransport)reference.get() : null;
                if (transport == null) {
                    transport = new BroadcastListenerTransport(callback, executor);
                } else {
                    Preconditions.checkState(transport.isRegistered());
                    transport.setExecutor(executor);
                }
                this.mService.startBroadcast(new BroadcastRequestParcelable(broadcastRequest), transport, this.mContext.getPackageName(), this.mContext.getAttributionTag());
                sBroadcastListeners.put(callback, new WeakReference<BroadcastListenerTransport>(transport));
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"ExecutorRegistration"})
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADVERTISE", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void stopBroadcast(BroadcastCallback callback) {
        try {
            WeakHashMap<BroadcastCallback, WeakReference<BroadcastListenerTransport>> weakHashMap = sBroadcastListeners;
            synchronized (weakHashMap) {
                BroadcastListenerTransport transport;
                WeakReference<BroadcastListenerTransport> reference = sBroadcastListeners.remove(callback);
                BroadcastListenerTransport broadcastListenerTransport = transport = reference != null ? (BroadcastListenerTransport)reference.get() : null;
                if (transport != null) {
                    transport.unregister();
                    this.mService.stopBroadcast(transport, this.mContext.getPackageName(), this.mContext.getAttributionTag());
                } else {
                    Log.e(TAG, "Cannot stop broadcast with this callback because it is never registered.");
                }
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static boolean getFastPairScanEnabled(Context context) {
        int enabled = Settings.Secure.getInt(context.getContentResolver(), FAST_PAIR_SCAN_ENABLED, 0);
        return enabled != 0;
    }

    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public static void setFastPairScanEnabled(Context context, boolean enable) {
        Settings.Secure.putInt(context.getContentResolver(), FAST_PAIR_SCAN_ENABLED, enable ? 1 : 0);
    }

    private static class BroadcastListenerTransport
    extends IBroadcastListener.Stub {
        private volatile BroadcastCallback mBroadcastCallback;
        private Executor mExecutor;

        BroadcastListenerTransport(BroadcastCallback broadcastCallback, Executor executor) {
            this.mBroadcastCallback = broadcastCallback;
            this.mExecutor = executor;
        }

        void setExecutor(Executor executor) {
            Preconditions.checkArgument(executor != null, "invalid null executor");
            this.mExecutor = executor;
        }

        boolean isRegistered() {
            return this.mBroadcastCallback != null;
        }

        void unregister() {
            this.mBroadcastCallback = null;
        }

        @Override
        public void onStatusChanged(int status) {
            this.mExecutor.execute(() -> {
                if (this.mBroadcastCallback != null) {
                    this.mBroadcastCallback.onStatusChanged(status);
                }
            });
        }
    }

    private static class ScanListenerTransport
    extends IScanListener.Stub {
        private int mScanType;
        private volatile ScanCallback mScanCallback;
        private Executor mExecutor;

        ScanListenerTransport(int scanType, ScanCallback scanCallback, Executor executor) {
            Preconditions.checkArgument(scanCallback != null, "invalid null callback");
            Preconditions.checkState(ScanRequest.isValidScanType(scanType), "invalid scan type : " + scanType + ", scan type must be one of ScanRequest#SCAN_TYPE_");
            this.mScanType = scanType;
            this.mScanCallback = scanCallback;
            this.mExecutor = executor;
        }

        void setExecutor(Executor executor) {
            Preconditions.checkArgument(executor != null, "invalid null executor");
            this.mExecutor = executor;
        }

        boolean isRegistered() {
            return this.mScanCallback != null;
        }

        void unregister() {
            this.mScanCallback = null;
        }

        @Override
        public void onDiscovered(NearbyDeviceParcelable nearbyDeviceParcelable) throws RemoteException {
            this.mExecutor.execute(() -> {
                if (this.mScanCallback != null) {
                    this.mScanCallback.onDiscovered(NearbyManager.toClientNearbyDevice(nearbyDeviceParcelable, this.mScanType));
                }
            });
        }

        @Override
        public void onUpdated(NearbyDeviceParcelable nearbyDeviceParcelable) throws RemoteException {
            this.mExecutor.execute(() -> {
                if (this.mScanCallback != null) {
                    this.mScanCallback.onUpdated(NearbyManager.toClientNearbyDevice(nearbyDeviceParcelable, this.mScanType));
                }
            });
        }

        @Override
        public void onLost(NearbyDeviceParcelable nearbyDeviceParcelable) throws RemoteException {
            this.mExecutor.execute(() -> {
                if (this.mScanCallback != null) {
                    this.mScanCallback.onLost(NearbyManager.toClientNearbyDevice(nearbyDeviceParcelable, this.mScanType));
                }
            });
        }

        @Override
        public void onError() {
            this.mExecutor.execute(() -> {
                if (this.mScanCallback != null) {
                    Log.e(NearbyManager.TAG, "onError: There is an error in scan.");
                }
            });
        }
    }

    public static @interface ScanStatus {
        public static final int UNKNOWN = 0;
        public static final int SUCCESS = 1;
        public static final int ERROR = 2;
    }
}

