/*
 * Decompiled with CFR 0.152.
 */
package android.nearby;

import android.annotation.SystemApi;
import android.net.connectivity.com.android.internal.util.Preconditions;
import java.util.List;
import java.util.Objects;

@SystemApi
public abstract class NearbyDevice {
    private final String mName;
    @Medium
    private final List<Integer> mMediums;
    private final int mRssi;

    public NearbyDevice(String name, List<Integer> mediums, int rssi) {
        for (int medium : mediums) {
            Preconditions.checkState(NearbyDevice.isValidMedium(medium), "Not supported medium: " + medium + ", scan medium must be one of NearbyDevice#Medium.");
        }
        this.mName = name;
        this.mMediums = mediums;
        this.mRssi = rssi;
    }

    static String mediumToString(@Medium int medium) {
        switch (medium) {
            case 1: {
                return "BLE";
            }
            case 2: {
                return "Bluetooth Classic";
            }
        }
        return "Unknown";
    }

    public static boolean isValidMedium(@Medium int medium) {
        return medium == 1 || medium == 2;
    }

    public String getName() {
        return this.mName;
    }

    @Medium
    public List<Integer> getMediums() {
        return this.mMediums;
    }

    public int getRssi() {
        return this.mRssi;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("NearbyDevice [");
        if (this.mName != null && !this.mName.isEmpty()) {
            stringBuilder.append("name=").append(this.mName).append(", ");
        }
        stringBuilder.append("medium={");
        for (int medium : this.mMediums) {
            stringBuilder.append(NearbyDevice.mediumToString(medium));
        }
        stringBuilder.append("} rssi=").append(this.mRssi);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public boolean equals(Object other) {
        if (other instanceof NearbyDevice) {
            NearbyDevice otherDevice = (NearbyDevice)other;
            return Objects.equals(this.mName, otherDevice.mName) && this.mMediums == otherDevice.mMediums && this.mRssi == otherDevice.mRssi;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mName, this.mMediums, this.mRssi);
    }

    public static @interface Medium {
        public static final int BLE = 1;
        public static final int BLUETOOTH = 2;
    }
}

