/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv.interactive;

import android.graphics.Rect;
import android.media.tv.AdResponse;
import android.media.tv.BroadcastInfoResponse;
import android.media.tv.TvTrackInfo;
import android.media.tv.interactive.AppLinkInfo;
import android.media.tv.interactive.ITvInteractiveAppClient;
import android.media.tv.interactive.ITvInteractiveAppManagerCallback;
import android.media.tv.interactive.TvInteractiveAppServiceInfo;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.Surface;
import java.util.ArrayList;
import java.util.List;

public interface ITvInteractiveAppManager
extends IInterface {
    public static final String DESCRIPTOR = "android.media.tv.interactive.ITvInteractiveAppManager";

    public List<TvInteractiveAppServiceInfo> getTvInteractiveAppServiceList(int var1) throws RemoteException;

    public void registerAppLinkInfo(String var1, AppLinkInfo var2, int var3) throws RemoteException;

    public void unregisterAppLinkInfo(String var1, AppLinkInfo var2, int var3) throws RemoteException;

    public void sendAppLinkCommand(String var1, Bundle var2, int var3) throws RemoteException;

    public void startInteractiveApp(IBinder var1, int var2) throws RemoteException;

    public void stopInteractiveApp(IBinder var1, int var2) throws RemoteException;

    public void resetInteractiveApp(IBinder var1, int var2) throws RemoteException;

    public void createBiInteractiveApp(IBinder var1, Uri var2, Bundle var3, int var4) throws RemoteException;

    public void destroyBiInteractiveApp(IBinder var1, String var2, int var3) throws RemoteException;

    public void setTeletextAppEnabled(IBinder var1, boolean var2, int var3) throws RemoteException;

    public void sendCurrentChannelUri(IBinder var1, Uri var2, int var3) throws RemoteException;

    public void sendCurrentChannelLcn(IBinder var1, int var2, int var3) throws RemoteException;

    public void sendStreamVolume(IBinder var1, float var2, int var3) throws RemoteException;

    public void sendTrackInfoList(IBinder var1, List<TvTrackInfo> var2, int var3) throws RemoteException;

    public void sendCurrentTvInputId(IBinder var1, String var2, int var3) throws RemoteException;

    public void sendSigningResult(IBinder var1, String var2, byte[] var3, int var4) throws RemoteException;

    public void notifyError(IBinder var1, String var2, Bundle var3, int var4) throws RemoteException;

    public void createSession(ITvInteractiveAppClient var1, String var2, int var3, int var4, int var5) throws RemoteException;

    public void releaseSession(IBinder var1, int var2) throws RemoteException;

    public void notifyTuned(IBinder var1, Uri var2, int var3) throws RemoteException;

    public void notifyTrackSelected(IBinder var1, int var2, String var3, int var4) throws RemoteException;

    public void notifyTracksChanged(IBinder var1, List<TvTrackInfo> var2, int var3) throws RemoteException;

    public void notifyVideoAvailable(IBinder var1, int var2) throws RemoteException;

    public void notifyVideoUnavailable(IBinder var1, int var2, int var3) throws RemoteException;

    public void notifyContentAllowed(IBinder var1, int var2) throws RemoteException;

    public void notifyContentBlocked(IBinder var1, String var2, int var3) throws RemoteException;

    public void notifySignalStrength(IBinder var1, int var2, int var3) throws RemoteException;

    public void setSurface(IBinder var1, Surface var2, int var3) throws RemoteException;

    public void dispatchSurfaceChanged(IBinder var1, int var2, int var3, int var4, int var5) throws RemoteException;

    public void notifyBroadcastInfoResponse(IBinder var1, BroadcastInfoResponse var2, int var3) throws RemoteException;

    public void notifyAdResponse(IBinder var1, AdResponse var2, int var3) throws RemoteException;

    public void createMediaView(IBinder var1, IBinder var2, Rect var3, int var4) throws RemoteException;

    public void relayoutMediaView(IBinder var1, Rect var2, int var3) throws RemoteException;

    public void removeMediaView(IBinder var1, int var2) throws RemoteException;

    public void registerCallback(ITvInteractiveAppManagerCallback var1, int var2) throws RemoteException;

    public void unregisterCallback(ITvInteractiveAppManagerCallback var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITvInteractiveAppManager {
        static final int TRANSACTION_getTvInteractiveAppServiceList = 1;
        static final int TRANSACTION_registerAppLinkInfo = 2;
        static final int TRANSACTION_unregisterAppLinkInfo = 3;
        static final int TRANSACTION_sendAppLinkCommand = 4;
        static final int TRANSACTION_startInteractiveApp = 5;
        static final int TRANSACTION_stopInteractiveApp = 6;
        static final int TRANSACTION_resetInteractiveApp = 7;
        static final int TRANSACTION_createBiInteractiveApp = 8;
        static final int TRANSACTION_destroyBiInteractiveApp = 9;
        static final int TRANSACTION_setTeletextAppEnabled = 10;
        static final int TRANSACTION_sendCurrentChannelUri = 11;
        static final int TRANSACTION_sendCurrentChannelLcn = 12;
        static final int TRANSACTION_sendStreamVolume = 13;
        static final int TRANSACTION_sendTrackInfoList = 14;
        static final int TRANSACTION_sendCurrentTvInputId = 15;
        static final int TRANSACTION_sendSigningResult = 16;
        static final int TRANSACTION_notifyError = 17;
        static final int TRANSACTION_createSession = 18;
        static final int TRANSACTION_releaseSession = 19;
        static final int TRANSACTION_notifyTuned = 20;
        static final int TRANSACTION_notifyTrackSelected = 21;
        static final int TRANSACTION_notifyTracksChanged = 22;
        static final int TRANSACTION_notifyVideoAvailable = 23;
        static final int TRANSACTION_notifyVideoUnavailable = 24;
        static final int TRANSACTION_notifyContentAllowed = 25;
        static final int TRANSACTION_notifyContentBlocked = 26;
        static final int TRANSACTION_notifySignalStrength = 27;
        static final int TRANSACTION_setSurface = 28;
        static final int TRANSACTION_dispatchSurfaceChanged = 29;
        static final int TRANSACTION_notifyBroadcastInfoResponse = 30;
        static final int TRANSACTION_notifyAdResponse = 31;
        static final int TRANSACTION_createMediaView = 32;
        static final int TRANSACTION_relayoutMediaView = 33;
        static final int TRANSACTION_removeMediaView = 34;
        static final int TRANSACTION_registerCallback = 35;
        static final int TRANSACTION_unregisterCallback = 36;

        public Stub() {
            this.attachInterface(this, ITvInteractiveAppManager.DESCRIPTOR);
        }

        public static ITvInteractiveAppManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ITvInteractiveAppManager.DESCRIPTOR);
            if (iin != null && iin instanceof ITvInteractiveAppManager) {
                return (ITvInteractiveAppManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getTvInteractiveAppServiceList";
                }
                case 2: {
                    return "registerAppLinkInfo";
                }
                case 3: {
                    return "unregisterAppLinkInfo";
                }
                case 4: {
                    return "sendAppLinkCommand";
                }
                case 5: {
                    return "startInteractiveApp";
                }
                case 6: {
                    return "stopInteractiveApp";
                }
                case 7: {
                    return "resetInteractiveApp";
                }
                case 8: {
                    return "createBiInteractiveApp";
                }
                case 9: {
                    return "destroyBiInteractiveApp";
                }
                case 10: {
                    return "setTeletextAppEnabled";
                }
                case 11: {
                    return "sendCurrentChannelUri";
                }
                case 12: {
                    return "sendCurrentChannelLcn";
                }
                case 13: {
                    return "sendStreamVolume";
                }
                case 14: {
                    return "sendTrackInfoList";
                }
                case 15: {
                    return "sendCurrentTvInputId";
                }
                case 16: {
                    return "sendSigningResult";
                }
                case 17: {
                    return "notifyError";
                }
                case 18: {
                    return "createSession";
                }
                case 19: {
                    return "releaseSession";
                }
                case 20: {
                    return "notifyTuned";
                }
                case 21: {
                    return "notifyTrackSelected";
                }
                case 22: {
                    return "notifyTracksChanged";
                }
                case 23: {
                    return "notifyVideoAvailable";
                }
                case 24: {
                    return "notifyVideoUnavailable";
                }
                case 25: {
                    return "notifyContentAllowed";
                }
                case 26: {
                    return "notifyContentBlocked";
                }
                case 27: {
                    return "notifySignalStrength";
                }
                case 28: {
                    return "setSurface";
                }
                case 29: {
                    return "dispatchSurfaceChanged";
                }
                case 30: {
                    return "notifyBroadcastInfoResponse";
                }
                case 31: {
                    return "notifyAdResponse";
                }
                case 32: {
                    return "createMediaView";
                }
                case 33: {
                    return "relayoutMediaView";
                }
                case 34: {
                    return "removeMediaView";
                }
                case 35: {
                    return "registerCallback";
                }
                case 36: {
                    return "unregisterCallback";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ITvInteractiveAppManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    List<TvInteractiveAppServiceInfo> _result = this.getTvInteractiveAppServiceList(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    AppLinkInfo _arg1 = data.readTypedObject(AppLinkInfo.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.registerAppLinkInfo(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    AppLinkInfo _arg1 = data.readTypedObject(AppLinkInfo.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.unregisterAppLinkInfo(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    Bundle _arg1 = data.readTypedObject(Bundle.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.sendAppLinkCommand(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.startInteractiveApp(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.stopInteractiveApp(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.resetInteractiveApp(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    IBinder _arg0 = data.readStrongBinder();
                    Uri _arg1 = data.readTypedObject(Uri.CREATOR);
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.createBiInteractiveApp(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.destroyBiInteractiveApp(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = data.readBoolean();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setTeletextAppEnabled(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    IBinder _arg0 = data.readStrongBinder();
                    Uri _arg1 = data.readTypedObject(Uri.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.sendCurrentChannelUri(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.sendCurrentChannelLcn(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    IBinder _arg0 = data.readStrongBinder();
                    float _arg1 = data.readFloat();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.sendStreamVolume(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    IBinder _arg0 = data.readStrongBinder();
                    ArrayList<TvTrackInfo> _arg1 = data.createTypedArrayList(TvTrackInfo.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.sendTrackInfoList(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.sendCurrentTvInputId(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    byte[] _arg2 = data.createByteArray();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.sendSigningResult(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyError(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    ITvInteractiveAppClient _arg0 = ITvInteractiveAppClient.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.createSession(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.releaseSession(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 20: {
                    IBinder _arg0 = data.readStrongBinder();
                    Uri _arg1 = data.readTypedObject(Uri.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyTuned(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 21: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyTrackSelected(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 22: {
                    IBinder _arg0 = data.readStrongBinder();
                    ArrayList<TvTrackInfo> _arg1 = data.createTypedArrayList(TvTrackInfo.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyTracksChanged(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 23: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyVideoAvailable(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 24: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyVideoUnavailable(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 25: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyContentAllowed(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 26: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyContentBlocked(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 27: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifySignalStrength(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 28: {
                    IBinder _arg0 = data.readStrongBinder();
                    Surface _arg1 = data.readTypedObject(Surface.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setSurface(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 29: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.dispatchSurfaceChanged(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 30: {
                    IBinder _arg0 = data.readStrongBinder();
                    BroadcastInfoResponse _arg1 = data.readTypedObject(BroadcastInfoResponse.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyBroadcastInfoResponse(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 31: {
                    IBinder _arg0 = data.readStrongBinder();
                    AdResponse _arg1 = data.readTypedObject(AdResponse.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyAdResponse(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 32: {
                    IBinder _arg0 = data.readStrongBinder();
                    IBinder _arg1 = data.readStrongBinder();
                    Rect _arg2 = data.readTypedObject(Rect.CREATOR);
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.createMediaView(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 33: {
                    IBinder _arg0 = data.readStrongBinder();
                    Rect _arg1 = data.readTypedObject(Rect.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.relayoutMediaView(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 34: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.removeMediaView(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 35: {
                    ITvInteractiveAppManagerCallback _arg0 = ITvInteractiveAppManagerCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.registerCallback(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 36: {
                    ITvInteractiveAppManagerCallback _arg0 = ITvInteractiveAppManagerCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.unregisterCallback(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 35;
        }

        private static class Proxy
        implements ITvInteractiveAppManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ITvInteractiveAppManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<TvInteractiveAppServiceInfo> getTvInteractiveAppServiceList(int userId) throws RemoteException {
                ArrayList<TvInteractiveAppServiceInfo> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(TvInteractiveAppServiceInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerAppLinkInfo(String tiasId, AppLinkInfo info, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeString(tiasId);
                    _data.writeTypedObject(info, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterAppLinkInfo(String tiasId, AppLinkInfo info, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeString(tiasId);
                    _data.writeTypedObject(info, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendAppLinkCommand(String tiasId, Bundle command, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeString(tiasId);
                    _data.writeTypedObject(command, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startInteractiveApp(IBinder sessionToken, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopInteractiveApp(IBinder sessionToken, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resetInteractiveApp(IBinder sessionToken, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createBiInteractiveApp(IBinder sessionToken, Uri biIAppUri, Bundle params, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeTypedObject(biIAppUri, 0);
                    _data.writeTypedObject(params, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void destroyBiInteractiveApp(IBinder sessionToken, String biIAppId, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeString(biIAppId);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTeletextAppEnabled(IBinder sessionToken, boolean enable, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeBoolean(enable);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendCurrentChannelUri(IBinder sessionToken, Uri channelUri, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeTypedObject(channelUri, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendCurrentChannelLcn(IBinder sessionToken, int lcn, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeInt(lcn);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendStreamVolume(IBinder sessionToken, float volume, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeFloat(volume);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendTrackInfoList(IBinder sessionToken, List<TvTrackInfo> tracks, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeTypedList(tracks);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendCurrentTvInputId(IBinder sessionToken, String inputId, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeString(inputId);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendSigningResult(IBinder sessionToken, String signingId, byte[] result, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeString(signingId);
                    _data.writeByteArray(result);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyError(IBinder sessionToken, String errMsg, Bundle params, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeString(errMsg);
                    _data.writeTypedObject(params, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createSession(ITvInteractiveAppClient client, String iAppServiceId, int type, int seq, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongInterface(client);
                    _data.writeString(iAppServiceId);
                    _data.writeInt(type);
                    _data.writeInt(seq);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseSession(IBinder sessionToken, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyTuned(IBinder sessionToken, Uri channelUri, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeTypedObject(channelUri, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyTrackSelected(IBinder sessionToken, int type, String trackId, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeInt(type);
                    _data.writeString(trackId);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyTracksChanged(IBinder sessionToken, List<TvTrackInfo> tracks, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeTypedList(tracks);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyVideoAvailable(IBinder sessionToken, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyVideoUnavailable(IBinder sessionToken, int reason, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeInt(reason);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyContentAllowed(IBinder sessionToken, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyContentBlocked(IBinder sessionToken, String rating, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeString(rating);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifySignalStrength(IBinder sessionToken, int stength, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeInt(stength);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSurface(IBinder sessionToken, Surface surface, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeTypedObject(surface, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatchSurfaceChanged(IBinder sessionToken, int format, int width, int height, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeInt(format);
                    _data.writeInt(width);
                    _data.writeInt(height);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyBroadcastInfoResponse(IBinder sessionToken, BroadcastInfoResponse response, int UserId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeTypedObject(response, 0);
                    _data.writeInt(UserId);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyAdResponse(IBinder sessionToken, AdResponse response, int UserId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeTypedObject(response, 0);
                    _data.writeInt(UserId);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createMediaView(IBinder sessionToken, IBinder windowToken, Rect frame, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeStrongBinder(windowToken);
                    _data.writeTypedObject(frame, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void relayoutMediaView(IBinder sessionToken, Rect frame, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeTypedObject(frame, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeMediaView(IBinder sessionToken, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerCallback(ITvInteractiveAppManagerCallback callback, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterCallback(ITvInteractiveAppManagerCallback callback, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITvInteractiveAppManager {
        @Override
        public List<TvInteractiveAppServiceInfo> getTvInteractiveAppServiceList(int userId) throws RemoteException {
            return null;
        }

        @Override
        public void registerAppLinkInfo(String tiasId, AppLinkInfo info, int userId) throws RemoteException {
        }

        @Override
        public void unregisterAppLinkInfo(String tiasId, AppLinkInfo info, int userId) throws RemoteException {
        }

        @Override
        public void sendAppLinkCommand(String tiasId, Bundle command, int userId) throws RemoteException {
        }

        @Override
        public void startInteractiveApp(IBinder sessionToken, int userId) throws RemoteException {
        }

        @Override
        public void stopInteractiveApp(IBinder sessionToken, int userId) throws RemoteException {
        }

        @Override
        public void resetInteractiveApp(IBinder sessionToken, int userId) throws RemoteException {
        }

        @Override
        public void createBiInteractiveApp(IBinder sessionToken, Uri biIAppUri, Bundle params, int userId) throws RemoteException {
        }

        @Override
        public void destroyBiInteractiveApp(IBinder sessionToken, String biIAppId, int userId) throws RemoteException {
        }

        @Override
        public void setTeletextAppEnabled(IBinder sessionToken, boolean enable, int userId) throws RemoteException {
        }

        @Override
        public void sendCurrentChannelUri(IBinder sessionToken, Uri channelUri, int userId) throws RemoteException {
        }

        @Override
        public void sendCurrentChannelLcn(IBinder sessionToken, int lcn, int userId) throws RemoteException {
        }

        @Override
        public void sendStreamVolume(IBinder sessionToken, float volume, int userId) throws RemoteException {
        }

        @Override
        public void sendTrackInfoList(IBinder sessionToken, List<TvTrackInfo> tracks, int userId) throws RemoteException {
        }

        @Override
        public void sendCurrentTvInputId(IBinder sessionToken, String inputId, int userId) throws RemoteException {
        }

        @Override
        public void sendSigningResult(IBinder sessionToken, String signingId, byte[] result, int userId) throws RemoteException {
        }

        @Override
        public void notifyError(IBinder sessionToken, String errMsg, Bundle params, int userId) throws RemoteException {
        }

        @Override
        public void createSession(ITvInteractiveAppClient client, String iAppServiceId, int type, int seq, int userId) throws RemoteException {
        }

        @Override
        public void releaseSession(IBinder sessionToken, int userId) throws RemoteException {
        }

        @Override
        public void notifyTuned(IBinder sessionToken, Uri channelUri, int userId) throws RemoteException {
        }

        @Override
        public void notifyTrackSelected(IBinder sessionToken, int type, String trackId, int userId) throws RemoteException {
        }

        @Override
        public void notifyTracksChanged(IBinder sessionToken, List<TvTrackInfo> tracks, int userId) throws RemoteException {
        }

        @Override
        public void notifyVideoAvailable(IBinder sessionToken, int userId) throws RemoteException {
        }

        @Override
        public void notifyVideoUnavailable(IBinder sessionToken, int reason, int userId) throws RemoteException {
        }

        @Override
        public void notifyContentAllowed(IBinder sessionToken, int userId) throws RemoteException {
        }

        @Override
        public void notifyContentBlocked(IBinder sessionToken, String rating, int userId) throws RemoteException {
        }

        @Override
        public void notifySignalStrength(IBinder sessionToken, int stength, int userId) throws RemoteException {
        }

        @Override
        public void setSurface(IBinder sessionToken, Surface surface, int userId) throws RemoteException {
        }

        @Override
        public void dispatchSurfaceChanged(IBinder sessionToken, int format, int width, int height, int userId) throws RemoteException {
        }

        @Override
        public void notifyBroadcastInfoResponse(IBinder sessionToken, BroadcastInfoResponse response, int UserId) throws RemoteException {
        }

        @Override
        public void notifyAdResponse(IBinder sessionToken, AdResponse response, int UserId) throws RemoteException {
        }

        @Override
        public void createMediaView(IBinder sessionToken, IBinder windowToken, Rect frame, int userId) throws RemoteException {
        }

        @Override
        public void relayoutMediaView(IBinder sessionToken, Rect frame, int userId) throws RemoteException {
        }

        @Override
        public void removeMediaView(IBinder sessionToken, int userId) throws RemoteException {
        }

        @Override
        public void registerCallback(ITvInteractiveAppManagerCallback callback, int userId) throws RemoteException {
        }

        @Override
        public void unregisterCallback(ITvInteractiveAppManagerCallback callback, int userId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

