/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.media.tv.TunedInfo;
import android.media.tv.TvInputInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface ITvInputManagerCallback
extends IInterface {
    public void onInputAdded(String var1) throws RemoteException;

    public void onInputRemoved(String var1) throws RemoteException;

    public void onInputUpdated(String var1) throws RemoteException;

    public void onInputStateChanged(String var1, int var2) throws RemoteException;

    public void onTvInputInfoUpdated(TvInputInfo var1) throws RemoteException;

    public void onCurrentTunedInfosUpdated(List<TunedInfo> var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITvInputManagerCallback {
        public static final String DESCRIPTOR = "android.media.tv.ITvInputManagerCallback";
        static final int TRANSACTION_onInputAdded = 1;
        static final int TRANSACTION_onInputRemoved = 2;
        static final int TRANSACTION_onInputUpdated = 3;
        static final int TRANSACTION_onInputStateChanged = 4;
        static final int TRANSACTION_onTvInputInfoUpdated = 5;
        static final int TRANSACTION_onCurrentTunedInfosUpdated = 6;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ITvInputManagerCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ITvInputManagerCallback) {
                return (ITvInputManagerCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onInputAdded";
                }
                case 2: {
                    return "onInputRemoved";
                }
                case 3: {
                    return "onInputUpdated";
                }
                case 4: {
                    return "onInputStateChanged";
                }
                case 5: {
                    return "onTvInputInfoUpdated";
                }
                case 6: {
                    return "onCurrentTunedInfosUpdated";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.onInputAdded(_arg0);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.onInputRemoved(_arg0);
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.onInputUpdated(_arg0);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onInputStateChanged(_arg0, _arg1);
                    break;
                }
                case 5: {
                    TvInputInfo _arg0 = data.readTypedObject(TvInputInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onTvInputInfoUpdated(_arg0);
                    break;
                }
                case 6: {
                    ArrayList<TunedInfo> _arg0 = data.createTypedArrayList(TunedInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onCurrentTunedInfosUpdated(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 5;
        }

        private static class Proxy
        implements ITvInputManagerCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onInputAdded(String inputId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(inputId);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onInputRemoved(String inputId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(inputId);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onInputUpdated(String inputId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(inputId);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onInputStateChanged(String inputId, int state) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(inputId);
                    _data.writeInt(state);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTvInputInfoUpdated(TvInputInfo TvInputInfo2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(TvInputInfo2, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCurrentTunedInfosUpdated(List<TunedInfo> currentTunedInfos) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(currentTunedInfos);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITvInputManagerCallback {
        @Override
        public void onInputAdded(String inputId) throws RemoteException {
        }

        @Override
        public void onInputRemoved(String inputId) throws RemoteException {
        }

        @Override
        public void onInputUpdated(String inputId) throws RemoteException {
        }

        @Override
        public void onInputStateChanged(String inputId, int state) throws RemoteException {
        }

        @Override
        public void onTvInputInfoUpdated(TvInputInfo TvInputInfo2) throws RemoteException {
        }

        @Override
        public void onCurrentTunedInfosUpdated(List<TunedInfo> currentTunedInfos) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

