/*
 * Decompiled with CFR 0.152.
 */
package android.media.session;

import android.os.Binder;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import com.android.internal.annotations.GuardedBy;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class ParcelableListBinder<T extends Parcelable>
extends Binder {
    private static final int SUGGESTED_MAX_IPC_SIZE = IBinder.getSuggestedMaxIpcSizeBytes();
    private static final int END_OF_PARCEL = 0;
    private static final int ITEM_CONTINUED = 1;
    private final Consumer<List<T>> mConsumer;
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private final List<T> mList = new ArrayList<T>();
    @GuardedBy(value={"mLock"})
    private int mCount;
    @GuardedBy(value={"mLock"})
    private boolean mConsumed;

    public ParcelableListBinder(Consumer<List<T>> consumer) {
        this.mConsumer = consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        List<T> listToBeConsumed;
        if (code != 1) {
            return super.onTransact(code, data, reply, flags);
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mConsumed) {
                return false;
            }
            int i = this.mList.size();
            if (i == 0) {
                this.mCount = data.readInt();
            }
            while (i < this.mCount && data.readInt() != 0) {
                this.mList.add(data.readParcelable(null));
                ++i;
            }
            if (i >= this.mCount) {
                listToBeConsumed = this.mList;
                this.mConsumed = true;
            } else {
                listToBeConsumed = null;
            }
        }
        if (listToBeConsumed != null) {
            this.mConsumer.accept(listToBeConsumed);
        }
        return true;
    }

    public static <T extends Parcelable> void send(IBinder binder, List<T> list) throws RemoteException {
        int count = list.size();
        int i = 0;
        do {
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            if (i == 0) {
                data.writeInt(count);
            }
            while (i < count && data.dataSize() < SUGGESTED_MAX_IPC_SIZE) {
                data.writeInt(1);
                data.writeParcelable((Parcelable)list.get(i), 0);
                ++i;
            }
            if (i < count) {
                data.writeInt(0);
            }
            binder.transact(1, data, reply, 0);
            reply.recycle();
            data.recycle();
        } while (i < count);
    }
}

