/*
 * Decompiled with CFR 0.152.
 */
package android.media.metrics;

import android.media.metrics.Event;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class TrackChangeEvent
extends Event
implements Parcelable {
    public static final int TRACK_STATE_OFF = 0;
    public static final int TRACK_STATE_ON = 1;
    public static final int TRACK_CHANGE_REASON_UNKNOWN = 0;
    public static final int TRACK_CHANGE_REASON_OTHER = 1;
    public static final int TRACK_CHANGE_REASON_INITIAL = 2;
    public static final int TRACK_CHANGE_REASON_MANUAL = 3;
    public static final int TRACK_CHANGE_REASON_ADAPTIVE = 4;
    public static final int TRACK_TYPE_AUDIO = 0;
    public static final int TRACK_TYPE_VIDEO = 1;
    public static final int TRACK_TYPE_TEXT = 2;
    private final int mState;
    private final int mReason;
    private final String mContainerMimeType;
    private final String mSampleMimeType;
    private final String mCodecName;
    private final int mBitrate;
    private final long mTimeSinceCreatedMillis;
    private final int mType;
    private final String mLanguage;
    private final String mLanguageRegion;
    private final int mChannelCount;
    private final int mAudioSampleRate;
    private final int mWidth;
    private final int mHeight;
    private final float mVideoFrameRate;
    public static final Parcelable.Creator<TrackChangeEvent> CREATOR = new Parcelable.Creator<TrackChangeEvent>(){

        public TrackChangeEvent[] newArray(int size) {
            return new TrackChangeEvent[size];
        }

        @Override
        public TrackChangeEvent createFromParcel(Parcel in) {
            return new TrackChangeEvent(in);
        }
    };

    private TrackChangeEvent(int state, int reason, String containerMimeType, String sampleMimeType, String codecName, int bitrate, long timeSinceCreatedMillis, int type, String language, String languageRegion, int channelCount, int sampleRate, int width, int height, float videoFrameRate, Bundle extras) {
        this.mState = state;
        this.mReason = reason;
        this.mContainerMimeType = containerMimeType;
        this.mSampleMimeType = sampleMimeType;
        this.mCodecName = codecName;
        this.mBitrate = bitrate;
        this.mTimeSinceCreatedMillis = timeSinceCreatedMillis;
        this.mType = type;
        this.mLanguage = language;
        this.mLanguageRegion = languageRegion;
        this.mChannelCount = channelCount;
        this.mAudioSampleRate = sampleRate;
        this.mWidth = width;
        this.mHeight = height;
        this.mVideoFrameRate = videoFrameRate;
        this.mMetricsBundle = extras.deepCopy();
    }

    public int getTrackState() {
        return this.mState;
    }

    public int getTrackChangeReason() {
        return this.mReason;
    }

    public String getContainerMimeType() {
        return this.mContainerMimeType;
    }

    public String getSampleMimeType() {
        return this.mSampleMimeType;
    }

    public String getCodecName() {
        return this.mCodecName;
    }

    public int getBitrate() {
        return this.mBitrate;
    }

    @Override
    public long getTimeSinceCreatedMillis() {
        return this.mTimeSinceCreatedMillis;
    }

    public int getTrackType() {
        return this.mType;
    }

    public String getLanguage() {
        return this.mLanguage;
    }

    public String getLanguageRegion() {
        return this.mLanguageRegion;
    }

    public int getChannelCount() {
        return this.mChannelCount;
    }

    public int getAudioSampleRate() {
        return this.mAudioSampleRate;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public float getVideoFrameRate() {
        return this.mVideoFrameRate;
    }

    @Override
    public Bundle getMetricsBundle() {
        return this.mMetricsBundle;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        int flg = 0;
        if (this.mContainerMimeType != null) {
            flg |= 4;
        }
        if (this.mSampleMimeType != null) {
            flg |= 8;
        }
        if (this.mCodecName != null) {
            flg |= 0x10;
        }
        if (this.mLanguage != null) {
            flg |= 0x100;
        }
        if (this.mLanguageRegion != null) {
            flg |= 0x200;
        }
        dest.writeInt(flg);
        dest.writeInt(this.mState);
        dest.writeInt(this.mReason);
        if (this.mContainerMimeType != null) {
            dest.writeString(this.mContainerMimeType);
        }
        if (this.mSampleMimeType != null) {
            dest.writeString(this.mSampleMimeType);
        }
        if (this.mCodecName != null) {
            dest.writeString(this.mCodecName);
        }
        dest.writeInt(this.mBitrate);
        dest.writeLong(this.mTimeSinceCreatedMillis);
        dest.writeInt(this.mType);
        if (this.mLanguage != null) {
            dest.writeString(this.mLanguage);
        }
        if (this.mLanguageRegion != null) {
            dest.writeString(this.mLanguageRegion);
        }
        dest.writeInt(this.mChannelCount);
        dest.writeInt(this.mAudioSampleRate);
        dest.writeInt(this.mWidth);
        dest.writeInt(this.mHeight);
        dest.writeFloat(this.mVideoFrameRate);
        dest.writeBundle(this.mMetricsBundle);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    private TrackChangeEvent(Parcel in) {
        int flg = in.readInt();
        int state = in.readInt();
        int reason = in.readInt();
        String containerMimeType = (flg & 4) == 0 ? null : in.readString();
        String sampleMimeType = (flg & 8) == 0 ? null : in.readString();
        String codecName = (flg & 0x10) == 0 ? null : in.readString();
        int bitrate = in.readInt();
        long timeSinceCreatedMillis = in.readLong();
        int type = in.readInt();
        String language = (flg & 0x100) == 0 ? null : in.readString();
        String languageRegion = (flg & 0x200) == 0 ? null : in.readString();
        int channelCount = in.readInt();
        int sampleRate = in.readInt();
        int width = in.readInt();
        int height = in.readInt();
        float videoFrameRate = in.readFloat();
        Bundle extras = in.readBundle();
        this.mState = state;
        this.mReason = reason;
        this.mContainerMimeType = containerMimeType;
        this.mSampleMimeType = sampleMimeType;
        this.mCodecName = codecName;
        this.mBitrate = bitrate;
        this.mTimeSinceCreatedMillis = timeSinceCreatedMillis;
        this.mType = type;
        this.mLanguage = language;
        this.mLanguageRegion = languageRegion;
        this.mChannelCount = channelCount;
        this.mAudioSampleRate = sampleRate;
        this.mWidth = width;
        this.mHeight = height;
        this.mVideoFrameRate = videoFrameRate;
        this.mMetricsBundle = extras;
    }

    public String toString() {
        return "TrackChangeEvent { state = " + this.mState + ", reason = " + this.mReason + ", containerMimeType = " + this.mContainerMimeType + ", sampleMimeType = " + this.mSampleMimeType + ", codecName = " + this.mCodecName + ", bitrate = " + this.mBitrate + ", timeSinceCreatedMillis = " + this.mTimeSinceCreatedMillis + ", type = " + this.mType + ", language = " + this.mLanguage + ", languageRegion = " + this.mLanguageRegion + ", channelCount = " + this.mChannelCount + ", sampleRate = " + this.mAudioSampleRate + ", width = " + this.mWidth + ", height = " + this.mHeight + ", videoFrameRate = " + this.mVideoFrameRate + " }";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrackChangeEvent that = (TrackChangeEvent)o;
        return this.mState == that.mState && this.mReason == that.mReason && Objects.equals(this.mContainerMimeType, that.mContainerMimeType) && Objects.equals(this.mSampleMimeType, that.mSampleMimeType) && Objects.equals(this.mCodecName, that.mCodecName) && this.mBitrate == that.mBitrate && this.mTimeSinceCreatedMillis == that.mTimeSinceCreatedMillis && this.mType == that.mType && Objects.equals(this.mLanguage, that.mLanguage) && Objects.equals(this.mLanguageRegion, that.mLanguageRegion) && this.mChannelCount == that.mChannelCount && this.mAudioSampleRate == that.mAudioSampleRate && this.mWidth == that.mWidth && this.mHeight == that.mHeight && this.mVideoFrameRate == that.mVideoFrameRate;
    }

    public int hashCode() {
        return Objects.hash(this.mState, this.mReason, this.mContainerMimeType, this.mSampleMimeType, this.mCodecName, this.mBitrate, this.mTimeSinceCreatedMillis, this.mType, this.mLanguage, this.mLanguageRegion, this.mChannelCount, this.mAudioSampleRate, this.mWidth, this.mHeight, Float.valueOf(this.mVideoFrameRate));
    }

    public static class Builder {
        private int mState = 0;
        private int mReason = 0;
        private String mContainerMimeType;
        private String mSampleMimeType;
        private String mCodecName;
        private int mBitrate = -1;
        private long mTimeSinceCreatedMillis = -1L;
        private final int mType;
        private String mLanguage;
        private String mLanguageRegion;
        private int mChannelCount = -1;
        private int mAudioSampleRate = -1;
        private int mWidth = -1;
        private int mHeight = -1;
        private float mVideoFrameRate = -1.0f;
        private Bundle mMetricsBundle = new Bundle();
        private long mBuilderFieldsSet = 0L;

        public Builder(int type) {
            if (type != 0 && type != 1 && type != 2) {
                throw new IllegalArgumentException("track type must be one of TRACK_TYPE_AUDIO, TRACK_TYPE_VIDEO, TRACK_TYPE_TEXT.");
            }
            this.mType = type;
        }

        public Builder setTrackState(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 1L;
            this.mState = value;
            return this;
        }

        public Builder setTrackChangeReason(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 2L;
            this.mReason = value;
            return this;
        }

        public Builder setContainerMimeType(String value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 4L;
            this.mContainerMimeType = value;
            return this;
        }

        public Builder setSampleMimeType(String value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 8L;
            this.mSampleMimeType = value;
            return this;
        }

        public Builder setCodecName(String value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x10L;
            this.mCodecName = value;
            return this;
        }

        public Builder setBitrate(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x20L;
            this.mBitrate = value;
            return this;
        }

        public Builder setTimeSinceCreatedMillis(long value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x40L;
            this.mTimeSinceCreatedMillis = value;
            return this;
        }

        public Builder setLanguage(String value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x100L;
            this.mLanguage = value;
            return this;
        }

        public Builder setLanguageRegion(String value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x200L;
            this.mLanguageRegion = value;
            return this;
        }

        public Builder setChannelCount(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x400L;
            this.mChannelCount = value;
            return this;
        }

        public Builder setAudioSampleRate(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x800L;
            this.mAudioSampleRate = value;
            return this;
        }

        public Builder setWidth(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x1000L;
            this.mWidth = value;
            return this;
        }

        public Builder setHeight(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x2000L;
            this.mHeight = value;
            return this;
        }

        public Builder setVideoFrameRate(float value) {
            this.checkNotUsed();
            this.mVideoFrameRate = value;
            return this;
        }

        public Builder setMetricsBundle(Bundle metricsBundle) {
            this.mMetricsBundle = metricsBundle;
            return this;
        }

        public TrackChangeEvent build() {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x4000L;
            TrackChangeEvent o = new TrackChangeEvent(this.mState, this.mReason, this.mContainerMimeType, this.mSampleMimeType, this.mCodecName, this.mBitrate, this.mTimeSinceCreatedMillis, this.mType, this.mLanguage, this.mLanguageRegion, this.mChannelCount, this.mAudioSampleRate, this.mWidth, this.mHeight, this.mVideoFrameRate, this.mMetricsBundle);
            return o;
        }

        private void checkNotUsed() {
            if ((this.mBuilderFieldsSet & 0x4000L) != 0L) {
                throw new IllegalStateException("This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TrackType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TrackChangeReason {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TrackState {
    }
}

