/*
 * Decompiled with CFR 0.152.
 */
package android.media.metrics;

import android.annotation.NonNull;
import android.media.metrics.LogSessionId;
import android.media.metrics.MediaMetricsManager;
import com.android.internal.util.AnnotationValidations;
import java.util.Objects;

public class RecordingSession
implements AutoCloseable {
    private final String mId;
    private final MediaMetricsManager mManager;
    private final LogSessionId mLogSessionId;
    private boolean mClosed = false;

    public RecordingSession(String id2, MediaMetricsManager manager) {
        this.mId = id2;
        this.mManager = manager;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mId);
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mManager);
        this.mLogSessionId = new LogSessionId(this.mId);
    }

    public LogSessionId getSessionId() {
        return this.mLogSessionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecordingSession that = (RecordingSession)o;
        return Objects.equals(this.mId, that.mId);
    }

    public int hashCode() {
        return Objects.hash(this.mId);
    }

    @Override
    public void close() {
        this.mClosed = true;
        this.mManager.releaseSessionId(this.mLogSessionId.getStringId());
    }
}

