/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.WebVttParser;
import android.util.Log;

class Tokenizer {
    private static final String TAG = "Tokenizer";
    private TokenizerPhase mPhase;
    private TokenizerPhase mDataTokenizer = new DataTokenizer();
    private TokenizerPhase mTagTokenizer = new TagTokenizer();
    private OnTokenListener mListener;
    private String mLine;
    private int mHandledLen;

    Tokenizer(OnTokenListener listener) {
        this.reset();
        this.mListener = listener;
    }

    void reset() {
        this.mPhase = this.mDataTokenizer.start();
    }

    void tokenize(String s) {
        this.mHandledLen = 0;
        this.mLine = s;
        while (this.mHandledLen < this.mLine.length()) {
            this.mPhase.tokenize();
        }
        if (!(this.mPhase instanceof TagTokenizer)) {
            this.mListener.onLineEnd();
        }
    }

    static interface OnTokenListener {
        public void onData(String var1);

        public void onStart(String var1, String[] var2, String var3);

        public void onEnd(String var1);

        public void onTimeStamp(long var1);

        public void onLineEnd();
    }

    class TagTokenizer
    implements TokenizerPhase {
        private boolean mAtAnnotation;
        private String mName;
        private String mAnnotation;

        TagTokenizer() {
        }

        @Override
        public TokenizerPhase start() {
            this.mAnnotation = "";
            this.mName = "";
            this.mAtAnnotation = false;
            return this;
        }

        @Override
        public void tokenize() {
            if (!this.mAtAnnotation) {
                ++Tokenizer.this.mHandledLen;
            }
            if (Tokenizer.this.mHandledLen < Tokenizer.this.mLine.length()) {
                String[] parts = this.mAtAnnotation || Tokenizer.this.mLine.charAt(Tokenizer.this.mHandledLen) == '/' ? Tokenizer.this.mLine.substring(Tokenizer.this.mHandledLen).split(">") : Tokenizer.this.mLine.substring(Tokenizer.this.mHandledLen).split("[\t\f >]");
                String part = Tokenizer.this.mLine.substring(Tokenizer.this.mHandledLen, Tokenizer.this.mHandledLen + parts[0].length());
                Tokenizer.this.mHandledLen += parts[0].length();
                if (this.mAtAnnotation) {
                    this.mAnnotation = this.mAnnotation + " " + part;
                } else {
                    this.mName = part;
                }
            }
            this.mAtAnnotation = true;
            if (Tokenizer.this.mHandledLen < Tokenizer.this.mLine.length() && Tokenizer.this.mLine.charAt(Tokenizer.this.mHandledLen) == '>') {
                this.yield_tag();
                Tokenizer.this.mPhase = Tokenizer.this.mDataTokenizer.start();
                ++Tokenizer.this.mHandledLen;
            }
        }

        private void yield_tag() {
            if (this.mName.startsWith("/")) {
                Tokenizer.this.mListener.onEnd(this.mName.substring(1));
            } else if (this.mName.length() > 0 && Character.isDigit(this.mName.charAt(0))) {
                try {
                    long timestampMs = WebVttParser.parseTimestampMs(this.mName);
                    Tokenizer.this.mListener.onTimeStamp(timestampMs);
                }
                catch (NumberFormatException e) {
                    Log.d(Tokenizer.TAG, "invalid timestamp tag: <" + this.mName + ">");
                }
            } else {
                this.mAnnotation = this.mAnnotation.replaceAll("\\s+", " ");
                if (this.mAnnotation.startsWith(" ")) {
                    this.mAnnotation = this.mAnnotation.substring(1);
                }
                if (this.mAnnotation.endsWith(" ")) {
                    this.mAnnotation = this.mAnnotation.substring(0, this.mAnnotation.length() - 1);
                }
                String[] classes = null;
                int dotAt = this.mName.indexOf(46);
                if (dotAt >= 0) {
                    classes = this.mName.substring(dotAt + 1).split("\\.");
                    this.mName = this.mName.substring(0, dotAt);
                }
                Tokenizer.this.mListener.onStart(this.mName, classes, this.mAnnotation);
            }
        }
    }

    class DataTokenizer
    implements TokenizerPhase {
        private StringBuilder mData;

        DataTokenizer() {
        }

        @Override
        public TokenizerPhase start() {
            this.mData = new StringBuilder();
            return this;
        }

        private boolean replaceEscape(String escape, String replacement, int pos) {
            if (Tokenizer.this.mLine.startsWith(escape, pos)) {
                this.mData.append(Tokenizer.this.mLine.substring(Tokenizer.this.mHandledLen, pos));
                this.mData.append(replacement);
                Tokenizer.this.mHandledLen = pos + escape.length();
                pos = Tokenizer.this.mHandledLen - 1;
                return true;
            }
            return false;
        }

        @Override
        public void tokenize() {
            int end = Tokenizer.this.mLine.length();
            for (int pos = Tokenizer.this.mHandledLen; pos < Tokenizer.this.mLine.length(); ++pos) {
                if (Tokenizer.this.mLine.charAt(pos) == '&') {
                    if (this.replaceEscape("&amp;", "&", pos) || this.replaceEscape("&lt;", "<", pos) || this.replaceEscape("&gt;", ">", pos) || this.replaceEscape("&lrm;", "\u200e", pos) || this.replaceEscape("&rlm;", "\u200f", pos) || !this.replaceEscape("&nbsp;", "\u00a0", pos)) continue;
                    continue;
                }
                if (Tokenizer.this.mLine.charAt(pos) != '<') continue;
                end = pos;
                Tokenizer.this.mPhase = Tokenizer.this.mTagTokenizer.start();
                break;
            }
            this.mData.append(Tokenizer.this.mLine.substring(Tokenizer.this.mHandledLen, end));
            Tokenizer.this.mListener.onData(this.mData.toString());
            this.mData.delete(0, this.mData.length());
            Tokenizer.this.mHandledLen = end;
        }
    }

    static interface TokenizerPhase {
        public TokenizerPhase start();

        public void tokenize();
    }
}

