/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.media.AudioAttributes;
import android.media.AudioDeviceAttributes;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.CallbackUtil;
import android.media.ISpatializerCallback;
import android.media.ISpatializerHeadToSoundStagePoseCallback;
import android.media.ISpatializerHeadTrackerAvailableCallback;
import android.media.ISpatializerHeadTrackingModeCallback;
import android.media.ISpatializerOutputCallback;
import android.media.permission.ClearCallingIdentityContext;
import android.media.permission.SafeCloseable;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;

public class Spatializer {
    private final AudioManager mAm;
    private static final String TAG = "Spatializer";
    public static final int SPATIALIZER_IMMERSIVE_LEVEL_OTHER = -1;
    public static final int SPATIALIZER_IMMERSIVE_LEVEL_NONE = 0;
    public static final int SPATIALIZER_IMMERSIVE_LEVEL_MULTICHANNEL = 1;
    public static final int SPATIALIZER_IMMERSIVE_LEVEL_MCHAN_BED_PLUS_OBJECTS = 2;
    @SystemApi(client=SystemApi.Client.PRIVILEGED_APPS)
    @RequiresPermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public static final int HEAD_TRACKING_MODE_UNSUPPORTED = -2;
    @SystemApi(client=SystemApi.Client.PRIVILEGED_APPS)
    @RequiresPermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public static final int HEAD_TRACKING_MODE_DISABLED = -1;
    @SystemApi(client=SystemApi.Client.PRIVILEGED_APPS)
    @RequiresPermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public static final int HEAD_TRACKING_MODE_OTHER = 0;
    @SystemApi(client=SystemApi.Client.PRIVILEGED_APPS)
    @RequiresPermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public static final int HEAD_TRACKING_MODE_RELATIVE_WORLD = 1;
    @SystemApi(client=SystemApi.Client.PRIVILEGED_APPS)
    @RequiresPermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public static final int HEAD_TRACKING_MODE_RELATIVE_DEVICE = 2;
    private final CallbackUtil.LazyListenerManager<OnSpatializerStateChangedListener> mStateListenerMgr = new CallbackUtil.LazyListenerManager();
    private final CallbackUtil.LazyListenerManager<OnHeadTrackingModeChangedListener> mHeadTrackingListenerMgr = new CallbackUtil.LazyListenerManager();
    private final CallbackUtil.LazyListenerManager<OnHeadTrackerAvailableListener> mHeadTrackerListenerMgr = new CallbackUtil.LazyListenerManager();
    private final Object mPoseListenerLock = new Object();
    @GuardedBy(value={"mPoseListenerLock"})
    private CallbackUtil.ListenerInfo<OnHeadToSoundstagePoseUpdatedListener> mPoseListener;
    @GuardedBy(value={"mPoseListenerLock"})
    private SpatializerPoseDispatcherStub mPoseDispatcher;
    private final Object mOutputListenerLock = new Object();
    @GuardedBy(value={"mOutputListenerLock"})
    private CallbackUtil.ListenerInfo<OnSpatializerOutputChangedListener> mOutputListener;
    @GuardedBy(value={"mOutputListenerLock"})
    private SpatializerOutputDispatcherStub mOutputDispatcher;

    protected Spatializer(AudioManager am) {
        this.mAm = Objects.requireNonNull(am);
    }

    public boolean isEnabled() {
        try {
            Spatializer spatializer = this;
            return spatializer.mAm.getService().isSpatializerEnabled();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error querying isSpatializerEnabled, returning false", e);
            return false;
        }
    }

    public boolean isAvailable() {
        try {
            Spatializer spatializer = this;
            return spatializer.mAm.getService().isSpatializerAvailable();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error querying isSpatializerAvailable, returning false", e);
            return false;
        }
    }

    @SystemApi(client=SystemApi.Client.PRIVILEGED_APPS)
    @RequiresPermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public boolean isAvailableForDevice(AudioDeviceAttributes device) {
        Objects.requireNonNull(device);
        try {
            Spatializer spatializer = this;
            return spatializer.mAm.getService().isSpatializerAvailableForDevice(device);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return false;
        }
    }

    @SystemApi(client=SystemApi.Client.PRIVILEGED_APPS)
    @RequiresPermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public boolean hasHeadTracker(AudioDeviceAttributes device) {
        Objects.requireNonNull(device);
        try {
            Spatializer spatializer = this;
            return spatializer.mAm.getService().hasHeadTracker(device);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return false;
        }
    }

    @SystemApi(client=SystemApi.Client.PRIVILEGED_APPS)
    @RequiresPermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void setHeadTrackerEnabled(boolean enabled, AudioDeviceAttributes device) {
        Objects.requireNonNull(device);
        try {
            Spatializer spatializer = this;
            spatializer.mAm.getService().setHeadTrackerEnabled(enabled, device);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @SystemApi(client=SystemApi.Client.PRIVILEGED_APPS)
    @RequiresPermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public boolean isHeadTrackerEnabled(AudioDeviceAttributes device) {
        Objects.requireNonNull(device);
        try {
            Spatializer spatializer = this;
            return spatializer.mAm.getService().isHeadTrackerEnabled(device);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return false;
        }
    }

    public boolean isHeadTrackerAvailable() {
        try {
            Spatializer spatializer = this;
            return spatializer.mAm.getService().isHeadTrackerAvailable();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return false;
        }
    }

    public void addOnHeadTrackerAvailableListener(Executor executor, OnHeadTrackerAvailableListener listener) {
        this.mHeadTrackerListenerMgr.addListener(executor, listener, "addOnHeadTrackerAvailableListener", () -> new SpatializerHeadTrackerAvailableDispatcherStub());
    }

    public void removeOnHeadTrackerAvailableListener(OnHeadTrackerAvailableListener listener) {
        this.mHeadTrackerListenerMgr.removeListener(listener, "removeOnHeadTrackerAvailableListener");
    }

    public static String headtrackingModeToString(int mode) {
        switch (mode) {
            case -2: {
                return "HEAD_TRACKING_MODE_UNSUPPORTED";
            }
            case -1: {
                return "HEAD_TRACKING_MODE_DISABLED";
            }
            case 0: {
                return "HEAD_TRACKING_MODE_OTHER";
            }
            case 1: {
                return "HEAD_TRACKING_MODE_RELATIVE_WORLD";
            }
            case 2: {
                return "HEAD_TRACKING_MODE_RELATIVE_DEVICE";
            }
        }
        return "head tracking mode unknown " + mode;
    }

    public int getImmersiveAudioLevel() {
        int level = 0;
        try {
            Spatializer spatializer = this;
            level = spatializer.mAm.getService().getSpatializerImmersiveAudioLevel();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return level;
    }

    @SystemApi(client=SystemApi.Client.PRIVILEGED_APPS)
    @RequiresPermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void setEnabled(boolean enabled) {
        try {
            Spatializer spatializer = this;
            spatializer.mAm.getService().setSpatializerEnabled(enabled);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling setSpatializerEnabled", e);
        }
    }

    public boolean canBeSpatialized(AudioAttributes attributes, AudioFormat format) {
        try {
            Spatializer spatializer = this;
            return spatializer.mAm.getService().canBeSpatialized(Objects.requireNonNull(attributes), Objects.requireNonNull(format));
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error querying canBeSpatialized for attr:" + attributes + " format:" + format + " returning false", e);
            return false;
        }
    }

    public void addOnSpatializerStateChangedListener(Executor executor, OnSpatializerStateChangedListener listener) {
        this.mStateListenerMgr.addListener(executor, listener, "addOnSpatializerStateChangedListener", () -> new SpatializerInfoDispatcherStub());
    }

    public void removeOnSpatializerStateChangedListener(OnSpatializerStateChangedListener listener) {
        this.mStateListenerMgr.removeListener(listener, "removeOnSpatializerStateChangedListener");
    }

    @SystemApi(client=SystemApi.Client.PRIVILEGED_APPS)
    @RequiresPermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public List<AudioDeviceAttributes> getCompatibleAudioDevices() {
        try {
            Spatializer spatializer = this;
            return spatializer.mAm.getService().getSpatializerCompatibleAudioDevices();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error querying getSpatializerCompatibleAudioDevices(),  returning empty list", e);
            return new ArrayList<AudioDeviceAttributes>(0);
        }
    }

    @SystemApi(client=SystemApi.Client.PRIVILEGED_APPS)
    @RequiresPermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void addCompatibleAudioDevice(AudioDeviceAttributes ada) {
        try {
            Spatializer spatializer = this;
            spatializer.mAm.getService().addSpatializerCompatibleAudioDevice(Objects.requireNonNull(ada));
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling addSpatializerCompatibleAudioDevice(), ", e);
        }
    }

    @SystemApi(client=SystemApi.Client.PRIVILEGED_APPS)
    @RequiresPermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void removeCompatibleAudioDevice(AudioDeviceAttributes ada) {
        try {
            Spatializer spatializer = this;
            spatializer.mAm.getService().removeSpatializerCompatibleAudioDevice(Objects.requireNonNull(ada));
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling removeSpatializerCompatibleAudioDevice(), ", e);
        }
    }

    @SystemApi(client=SystemApi.Client.PRIVILEGED_APPS)
    @RequiresPermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    @HeadTrackingMode
    public int getHeadTrackingMode() {
        try {
            Spatializer spatializer = this;
            return spatializer.mAm.getService().getActualHeadTrackingMode();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling getActualHeadTrackingMode", e);
            return -2;
        }
    }

    @SystemApi(client=SystemApi.Client.PRIVILEGED_APPS)
    @RequiresPermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    @HeadTrackingMode
    public int getDesiredHeadTrackingMode() {
        try {
            Spatializer spatializer = this;
            return spatializer.mAm.getService().getDesiredHeadTrackingMode();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling getDesiredHeadTrackingMode", e);
            return -2;
        }
    }

    @SystemApi(client=SystemApi.Client.PRIVILEGED_APPS)
    @RequiresPermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public List<Integer> getSupportedHeadTrackingModes() {
        try {
            Spatializer spatializer = this;
            int[] modes = spatializer.mAm.getService().getSupportedHeadTrackingModes();
            ArrayList<Integer> list = new ArrayList<Integer>(0);
            for (int mode : modes) {
                list.add(mode);
            }
            return list;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling getSupportedHeadTrackModes", e);
            return new ArrayList<Integer>(0);
        }
    }

    @SystemApi(client=SystemApi.Client.PRIVILEGED_APPS)
    @RequiresPermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void setDesiredHeadTrackingMode(@HeadTrackingModeSet int mode) {
        try {
            Spatializer spatializer = this;
            spatializer.mAm.getService().setDesiredHeadTrackingMode(mode);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling setDesiredHeadTrackingMode to " + mode, e);
        }
    }

    @SystemApi(client=SystemApi.Client.PRIVILEGED_APPS)
    @RequiresPermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void recenterHeadTracker() {
        try {
            Spatializer spatializer = this;
            spatializer.mAm.getService().recenterHeadTracker();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling recenterHeadTracker", e);
        }
    }

    @SystemApi(client=SystemApi.Client.PRIVILEGED_APPS)
    @RequiresPermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void addOnHeadTrackingModeChangedListener(Executor executor, OnHeadTrackingModeChangedListener listener) {
        this.mHeadTrackingListenerMgr.addListener(executor, listener, "addOnHeadTrackingModeChangedListener", () -> new SpatializerHeadTrackingDispatcherStub());
    }

    @SystemApi(client=SystemApi.Client.PRIVILEGED_APPS)
    @RequiresPermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void removeOnHeadTrackingModeChangedListener(OnHeadTrackingModeChangedListener listener) {
        this.mHeadTrackingListenerMgr.removeListener(listener, "removeOnHeadTrackingModeChangedListener");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi(client=SystemApi.Client.PRIVILEGED_APPS)
    @RequiresPermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void setOnHeadToSoundstagePoseUpdatedListener(Executor executor, OnHeadToSoundstagePoseUpdatedListener listener) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(listener);
        Object object = this.mPoseListenerLock;
        synchronized (object) {
            if (this.mPoseListener != null) {
                throw new IllegalStateException("Trying to overwrite existing listener");
            }
            this.mPoseListener = new CallbackUtil.ListenerInfo<OnHeadToSoundstagePoseUpdatedListener>(listener, executor);
            this.mPoseDispatcher = new SpatializerPoseDispatcherStub();
            try {
                Spatializer spatializer = this;
                spatializer.mAm.getService().registerHeadToSoundstagePoseCallback(this.mPoseDispatcher);
            }
            catch (RemoteException e) {
                this.mPoseListener = null;
                this.mPoseDispatcher = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi(client=SystemApi.Client.PRIVILEGED_APPS)
    @RequiresPermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void clearOnHeadToSoundstagePoseUpdatedListener() {
        Object object = this.mPoseListenerLock;
        synchronized (object) {
            if (this.mPoseDispatcher == null) {
                throw new IllegalStateException("No listener to clear");
            }
            try {
                Spatializer spatializer = this;
                spatializer.mAm.getService().unregisterHeadToSoundstagePoseCallback(this.mPoseDispatcher);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.mPoseListener = null;
            this.mPoseDispatcher = null;
        }
    }

    @SystemApi(client=SystemApi.Client.PRIVILEGED_APPS)
    @RequiresPermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void setGlobalTransform(float[] transform) {
        if (Objects.requireNonNull(transform).length != 6) {
            throw new IllegalArgumentException("transform array must be of size 6, was " + transform.length);
        }
        try {
            Spatializer spatializer = this;
            spatializer.mAm.getService().setSpatializerGlobalTransform(transform);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling setGlobalTransform", e);
        }
    }

    @SystemApi(client=SystemApi.Client.PRIVILEGED_APPS)
    @RequiresPermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void setEffectParameter(int key, byte[] value) {
        Objects.requireNonNull(value);
        try {
            Spatializer spatializer = this;
            spatializer.mAm.getService().setSpatializerParameter(key, value);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling setEffectParameter", e);
        }
    }

    @SystemApi(client=SystemApi.Client.PRIVILEGED_APPS)
    @RequiresPermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void getEffectParameter(int key, byte[] value) {
        Objects.requireNonNull(value);
        try {
            Spatializer spatializer = this;
            spatializer.mAm.getService().getSpatializerParameter(key, value);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling getEffectParameter", e);
        }
    }

    @SystemApi(client=SystemApi.Client.PRIVILEGED_APPS)
    @RequiresPermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public int getOutput() {
        try {
            Spatializer spatializer = this;
            return spatializer.mAm.getService().getSpatializerOutput();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling getSpatializerOutput", e);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi(client=SystemApi.Client.PRIVILEGED_APPS)
    @RequiresPermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void setOnSpatializerOutputChangedListener(Executor executor, OnSpatializerOutputChangedListener listener) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(listener);
        Object object = this.mOutputListenerLock;
        synchronized (object) {
            if (this.mOutputListener != null) {
                throw new IllegalStateException("Trying to overwrite existing listener");
            }
            this.mOutputListener = new CallbackUtil.ListenerInfo<OnSpatializerOutputChangedListener>(listener, executor);
            this.mOutputDispatcher = new SpatializerOutputDispatcherStub();
            try {
                Spatializer spatializer = this;
                spatializer.mAm.getService().registerSpatializerOutputCallback(this.mOutputDispatcher);
                this.mOutputDispatcher.dispatchSpatializerOutputChanged(this.getOutput());
            }
            catch (RemoteException e) {
                this.mOutputListener = null;
                this.mOutputDispatcher = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi(client=SystemApi.Client.PRIVILEGED_APPS)
    @RequiresPermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void clearOnSpatializerOutputChangedListener() {
        Object object = this.mOutputListenerLock;
        synchronized (object) {
            if (this.mOutputDispatcher == null) {
                throw new IllegalStateException("No listener to clear");
            }
            try {
                Spatializer spatializer = this;
                spatializer.mAm.getService().unregisterSpatializerOutputCallback(this.mOutputDispatcher);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.mOutputListener = null;
            this.mOutputDispatcher = null;
        }
    }

    private class SpatializerOutputDispatcherStub
    extends ISpatializerOutputCallback.Stub {
        private SpatializerOutputDispatcherStub() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatchSpatializerOutputChanged(int output) {
            CallbackUtil.ListenerInfo<OnSpatializerOutputChangedListener> listener;
            Object object = Spatializer.this.mOutputListenerLock;
            synchronized (object) {
                listener = Spatializer.this.mOutputListener;
            }
            if (listener == null) {
                return;
            }
            try (SafeCloseable ignored = ClearCallingIdentityContext.create();){
                listener.mExecutor.execute(() -> ((OnSpatializerOutputChangedListener)listener.mListener).onSpatializerOutputChanged(Spatializer.this, output));
            }
        }
    }

    private class SpatializerPoseDispatcherStub
    extends ISpatializerHeadToSoundStagePoseCallback.Stub {
        private SpatializerPoseDispatcherStub() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatchPoseChanged(float[] pose) {
            CallbackUtil.ListenerInfo<OnHeadToSoundstagePoseUpdatedListener> listener;
            Object object = Spatializer.this.mPoseListenerLock;
            synchronized (object) {
                listener = Spatializer.this.mPoseListener;
            }
            if (listener == null) {
                return;
            }
            try (SafeCloseable ignored = ClearCallingIdentityContext.create();){
                listener.mExecutor.execute(() -> ((OnHeadToSoundstagePoseUpdatedListener)listener.mListener).onHeadToSoundstagePoseUpdated(Spatializer.this, pose));
            }
        }
    }

    private class SpatializerHeadTrackerAvailableDispatcherStub
    extends ISpatializerHeadTrackerAvailableCallback.Stub
    implements CallbackUtil.DispatcherStub {
        private SpatializerHeadTrackerAvailableDispatcherStub() {
        }

        @Override
        public void register(boolean register) {
            try {
                Spatializer spatializer = Spatializer.this;
                spatializer.mAm.getService().registerSpatializerHeadTrackerAvailableCallback(this, register);
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        }

        @Override
        @SuppressLint(value={"GuardedBy"})
        public void dispatchSpatializerHeadTrackerAvailable(boolean available) {
            Spatializer.this.mHeadTrackerListenerMgr.callListeners(listener -> listener.onHeadTrackerAvailableChanged(Spatializer.this, available));
        }
    }

    private class SpatializerHeadTrackingDispatcherStub
    extends ISpatializerHeadTrackingModeCallback.Stub
    implements CallbackUtil.DispatcherStub {
        private SpatializerHeadTrackingDispatcherStub() {
        }

        @Override
        public void register(boolean register) {
            try {
                if (register) {
                    Spatializer spatializer = Spatializer.this;
                    spatializer.mAm.getService().registerSpatializerHeadTrackingCallback(this);
                } else {
                    Spatializer spatializer = Spatializer.this;
                    spatializer.mAm.getService().unregisterSpatializerHeadTrackingCallback(this);
                }
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        }

        @Override
        @SuppressLint(value={"GuardedBy"})
        public void dispatchSpatializerActualHeadTrackingModeChanged(int mode) {
            Spatializer.this.mHeadTrackingListenerMgr.callListeners(listener -> listener.onHeadTrackingModeChanged(Spatializer.this, mode));
        }

        @Override
        @SuppressLint(value={"GuardedBy"})
        public void dispatchSpatializerDesiredHeadTrackingModeChanged(int mode) {
            Spatializer.this.mHeadTrackingListenerMgr.callListeners(listener -> listener.onDesiredHeadTrackingModeChanged(Spatializer.this, mode));
        }
    }

    private class SpatializerInfoDispatcherStub
    extends ISpatializerCallback.Stub
    implements CallbackUtil.DispatcherStub {
        private SpatializerInfoDispatcherStub() {
        }

        @Override
        public void register(boolean register) {
            try {
                if (register) {
                    Spatializer spatializer = Spatializer.this;
                    spatializer.mAm.getService().registerSpatializerCallback(this);
                } else {
                    Spatializer spatializer = Spatializer.this;
                    spatializer.mAm.getService().unregisterSpatializerCallback(this);
                }
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        }

        @Override
        @SuppressLint(value={"GuardedBy"})
        public void dispatchSpatializerEnabledChanged(boolean enabled) {
            Spatializer.this.mStateListenerMgr.callListeners(listener -> listener.onSpatializerEnabledChanged(Spatializer.this, enabled));
        }

        @Override
        @SuppressLint(value={"GuardedBy"})
        public void dispatchSpatializerAvailableChanged(boolean available) {
            Spatializer.this.mStateListenerMgr.callListeners(listener -> listener.onSpatializerAvailableChanged(Spatializer.this, available));
        }
    }

    @SystemApi(client=SystemApi.Client.PRIVILEGED_APPS)
    public static interface OnHeadToSoundstagePoseUpdatedListener {
        public void onHeadToSoundstagePoseUpdated(Spatializer var1, float[] var2);
    }

    @SystemApi(client=SystemApi.Client.PRIVILEGED_APPS)
    public static interface OnSpatializerOutputChangedListener {
        public void onSpatializerOutputChanged(Spatializer var1, int var2);
    }

    public static interface OnHeadTrackerAvailableListener {
        public void onHeadTrackerAvailableChanged(Spatializer var1, boolean var2);
    }

    @SystemApi(client=SystemApi.Client.PRIVILEGED_APPS)
    public static interface OnHeadTrackingModeChangedListener {
        public void onHeadTrackingModeChanged(Spatializer var1, @HeadTrackingMode int var2);

        public void onDesiredHeadTrackingModeChanged(Spatializer var1, @HeadTrackingModeSet int var2);
    }

    public static interface OnSpatializerStateChangedListener {
        public void onSpatializerEnabledChanged(Spatializer var1, boolean var2);

        public void onSpatializerAvailableChanged(Spatializer var1, boolean var2);
    }

    public static @interface HeadTrackingModeSupported {
    }

    public static @interface HeadTrackingModeSet {
    }

    public static @interface HeadTrackingMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ImmersiveAudioLevel {
    }
}

