/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.SystemApi;
import android.os.IBinder;
import android.os.ServiceManager;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
public class MediaServiceManager {
    private static final String MEDIA_SESSION_SERVICE = "media_session";
    private static final String MEDIA_TRANSCODING_SERVICE = "media.transcoding";
    private static final String MEDIA_COMMUNICATION_SERVICE = "media_communication";

    public ServiceRegisterer getMediaSessionServiceRegisterer() {
        return new ServiceRegisterer(MEDIA_SESSION_SERVICE);
    }

    public ServiceRegisterer getMediaTranscodingServiceRegisterer() {
        return new ServiceRegisterer(MEDIA_TRANSCODING_SERVICE, true);
    }

    public ServiceRegisterer getMediaCommunicationServiceRegisterer() {
        return new ServiceRegisterer(MEDIA_COMMUNICATION_SERVICE);
    }

    public static class ServiceRegisterer {
        private final String mServiceName;
        private final boolean mLazyStart;

        public ServiceRegisterer(String serviceName, boolean lazyStart) {
            this.mServiceName = serviceName;
            this.mLazyStart = lazyStart;
        }

        public ServiceRegisterer(String serviceName) {
            this(serviceName, false);
        }

        public IBinder get() {
            if (this.mLazyStart) {
                return ServiceManager.waitForService((String)this.mServiceName);
            }
            return ServiceManager.getService(this.mServiceName);
        }
    }
}

