/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.session.MediaSession;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IRemoteSessionCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.media.IRemoteSessionCallback";

    public void onVolumeChanged(MediaSession.Token var1, int var2) throws RemoteException;

    public void onSessionChanged(MediaSession.Token var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IRemoteSessionCallback {
        static final int TRANSACTION_onVolumeChanged = 1;
        static final int TRANSACTION_onSessionChanged = 2;

        public Stub() {
            this.attachInterface(this, IRemoteSessionCallback.DESCRIPTOR);
        }

        public static IRemoteSessionCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IRemoteSessionCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IRemoteSessionCallback) {
                return (IRemoteSessionCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onVolumeChanged";
                }
                case 2: {
                    return "onSessionChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IRemoteSessionCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    MediaSession.Token _arg0 = data.readTypedObject(MediaSession.Token.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onVolumeChanged(_arg0, _arg1);
                    break;
                }
                case 2: {
                    MediaSession.Token _arg0 = data.readTypedObject(MediaSession.Token.CREATOR);
                    data.enforceNoDataAvail();
                    this.onSessionChanged(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements IRemoteSessionCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IRemoteSessionCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onVolumeChanged(MediaSession.Token sessionToken, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRemoteSessionCallback.DESCRIPTOR);
                    _data.writeTypedObject(sessionToken, 0);
                    _data.writeInt(flags);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSessionChanged(MediaSession.Token sessionToken) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRemoteSessionCallback.DESCRIPTOR);
                    _data.writeTypedObject(sessionToken, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IRemoteSessionCallback {
        @Override
        public void onVolumeChanged(MediaSession.Token sessionToken, int flags) throws RemoteException {
        }

        @Override
        public void onSessionChanged(MediaSession.Token sessionToken) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

