/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.MediaRoute2Info;
import android.media.RoutingSessionInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IMediaRouter2
extends IInterface {
    public static final String DESCRIPTOR = "android.media.IMediaRouter2";

    public void notifyRouterRegistered(List<MediaRoute2Info> var1, RoutingSessionInfo var2) throws RemoteException;

    public void notifyRoutesAdded(List<MediaRoute2Info> var1) throws RemoteException;

    public void notifyRoutesRemoved(List<MediaRoute2Info> var1) throws RemoteException;

    public void notifyRoutesChanged(List<MediaRoute2Info> var1) throws RemoteException;

    public void notifySessionCreated(int var1, RoutingSessionInfo var2) throws RemoteException;

    public void notifySessionInfoChanged(RoutingSessionInfo var1) throws RemoteException;

    public void notifySessionReleased(RoutingSessionInfo var1) throws RemoteException;

    public void requestCreateSessionByManager(long var1, RoutingSessionInfo var3, MediaRoute2Info var4) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMediaRouter2 {
        static final int TRANSACTION_notifyRouterRegistered = 1;
        static final int TRANSACTION_notifyRoutesAdded = 2;
        static final int TRANSACTION_notifyRoutesRemoved = 3;
        static final int TRANSACTION_notifyRoutesChanged = 4;
        static final int TRANSACTION_notifySessionCreated = 5;
        static final int TRANSACTION_notifySessionInfoChanged = 6;
        static final int TRANSACTION_notifySessionReleased = 7;
        static final int TRANSACTION_requestCreateSessionByManager = 8;

        public Stub() {
            this.attachInterface(this, IMediaRouter2.DESCRIPTOR);
        }

        public static IMediaRouter2 asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IMediaRouter2.DESCRIPTOR);
            if (iin != null && iin instanceof IMediaRouter2) {
                return (IMediaRouter2)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "notifyRouterRegistered";
                }
                case 2: {
                    return "notifyRoutesAdded";
                }
                case 3: {
                    return "notifyRoutesRemoved";
                }
                case 4: {
                    return "notifyRoutesChanged";
                }
                case 5: {
                    return "notifySessionCreated";
                }
                case 6: {
                    return "notifySessionInfoChanged";
                }
                case 7: {
                    return "notifySessionReleased";
                }
                case 8: {
                    return "requestCreateSessionByManager";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IMediaRouter2.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    ArrayList<MediaRoute2Info> _arg0 = data.createTypedArrayList(MediaRoute2Info.CREATOR);
                    RoutingSessionInfo _arg1 = data.readTypedObject(RoutingSessionInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifyRouterRegistered(_arg0, _arg1);
                    break;
                }
                case 2: {
                    ArrayList<MediaRoute2Info> _arg0 = data.createTypedArrayList(MediaRoute2Info.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifyRoutesAdded(_arg0);
                    break;
                }
                case 3: {
                    ArrayList<MediaRoute2Info> _arg0 = data.createTypedArrayList(MediaRoute2Info.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifyRoutesRemoved(_arg0);
                    break;
                }
                case 4: {
                    ArrayList<MediaRoute2Info> _arg0 = data.createTypedArrayList(MediaRoute2Info.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifyRoutesChanged(_arg0);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    RoutingSessionInfo _arg1 = data.readTypedObject(RoutingSessionInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifySessionCreated(_arg0, _arg1);
                    break;
                }
                case 6: {
                    RoutingSessionInfo _arg0 = data.readTypedObject(RoutingSessionInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifySessionInfoChanged(_arg0);
                    break;
                }
                case 7: {
                    RoutingSessionInfo _arg0 = data.readTypedObject(RoutingSessionInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifySessionReleased(_arg0);
                    break;
                }
                case 8: {
                    long _arg0 = data.readLong();
                    RoutingSessionInfo _arg1 = data.readTypedObject(RoutingSessionInfo.CREATOR);
                    MediaRoute2Info _arg2 = data.readTypedObject(MediaRoute2Info.CREATOR);
                    data.enforceNoDataAvail();
                    this.requestCreateSessionByManager(_arg0, _arg1, _arg2);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 7;
        }

        private static class Proxy
        implements IMediaRouter2 {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IMediaRouter2.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyRouterRegistered(List<MediaRoute2Info> currentRoutes, RoutingSessionInfo currentSystemSessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaRouter2.DESCRIPTOR);
                    _data.writeTypedList(currentRoutes);
                    _data.writeTypedObject(currentSystemSessionInfo, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyRoutesAdded(List<MediaRoute2Info> routes) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaRouter2.DESCRIPTOR);
                    _data.writeTypedList(routes);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyRoutesRemoved(List<MediaRoute2Info> routes) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaRouter2.DESCRIPTOR);
                    _data.writeTypedList(routes);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyRoutesChanged(List<MediaRoute2Info> routes) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaRouter2.DESCRIPTOR);
                    _data.writeTypedList(routes);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifySessionCreated(int requestId, RoutingSessionInfo sessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaRouter2.DESCRIPTOR);
                    _data.writeInt(requestId);
                    _data.writeTypedObject(sessionInfo, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifySessionInfoChanged(RoutingSessionInfo sessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaRouter2.DESCRIPTOR);
                    _data.writeTypedObject(sessionInfo, 0);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifySessionReleased(RoutingSessionInfo sessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaRouter2.DESCRIPTOR);
                    _data.writeTypedObject(sessionInfo, 0);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestCreateSessionByManager(long uniqueRequestId, RoutingSessionInfo oldSession, MediaRoute2Info route) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaRouter2.DESCRIPTOR);
                    _data.writeLong(uniqueRequestId);
                    _data.writeTypedObject(oldSession, 0);
                    _data.writeTypedObject(route, 0);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IMediaRouter2 {
        @Override
        public void notifyRouterRegistered(List<MediaRoute2Info> currentRoutes, RoutingSessionInfo currentSystemSessionInfo) throws RemoteException {
        }

        @Override
        public void notifyRoutesAdded(List<MediaRoute2Info> routes) throws RemoteException {
        }

        @Override
        public void notifyRoutesRemoved(List<MediaRoute2Info> routes) throws RemoteException {
        }

        @Override
        public void notifyRoutesChanged(List<MediaRoute2Info> routes) throws RemoteException {
        }

        @Override
        public void notifySessionCreated(int requestId, RoutingSessionInfo sessionInfo) throws RemoteException {
        }

        @Override
        public void notifySessionInfoChanged(RoutingSessionInfo sessionInfo) throws RemoteException {
        }

        @Override
        public void notifySessionReleased(RoutingSessionInfo sessionInfo) throws RemoteException {
        }

        @Override
        public void requestCreateSessionByManager(long uniqueRequestId, RoutingSessionInfo oldSession, MediaRoute2Info route) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

