/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.os.Binder;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;

abstract class BaseMediaParceledListSlice<T>
implements Parcelable {
    private static String TAG = "BaseMediaParceledListSlice";
    private static final boolean DEBUG = false;
    private static final int MAX_IPC_SIZE = 65536;
    private final List<T> mList;
    private int mInlineCountLimit = Integer.MAX_VALUE;

    public BaseMediaParceledListSlice(List<T> list) {
        this.mList = list;
    }

    BaseMediaParceledListSlice(Parcel p, ClassLoader loader) {
        int i;
        int N = p.readInt();
        this.mList = new ArrayList<T>(N);
        if (N <= 0) {
            return;
        }
        Parcelable.Creator<?> creator = this.readParcelableCreator(p, loader);
        Class<?> listElementClass = null;
        for (i = 0; i < N && p.readInt() != 0; ++i) {
            T parcelable = this.readCreator(creator, p, loader);
            if (listElementClass == null) {
                listElementClass = parcelable.getClass();
            } else {
                BaseMediaParceledListSlice.verifySameType(listElementClass, parcelable.getClass());
            }
            this.mList.add(parcelable);
        }
        if (i >= N) {
            return;
        }
        IBinder retriever = p.readStrongBinder();
        while (i < N) {
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            data.writeInt(i);
            try {
                retriever.transact(1, data, reply, 0);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failure retrieving array; only received " + i + " of " + N, e);
                return;
            }
            while (i < N && reply.readInt() != 0) {
                T parcelable = this.readCreator(creator, reply, loader);
                if (listElementClass == null) {
                    listElementClass = parcelable.getClass();
                } else {
                    BaseMediaParceledListSlice.verifySameType(listElementClass, parcelable.getClass());
                }
                this.mList.add(parcelable);
                ++i;
            }
            reply.recycle();
            data.recycle();
        }
    }

    private T readCreator(Parcelable.Creator<?> creator, Parcel p, ClassLoader loader) {
        if (creator instanceof Parcelable.ClassLoaderCreator) {
            Parcelable.ClassLoaderCreator classLoaderCreator = (Parcelable.ClassLoaderCreator)creator;
            return classLoaderCreator.createFromParcel(p, loader);
        }
        return (T)creator.createFromParcel(p);
    }

    private static void verifySameType(Class<?> expected, Class<?> actual) {
        if (!actual.equals(expected)) {
            throw new IllegalArgumentException("Can't unparcel type " + (actual == null ? null : actual.getName()) + " in list of type " + (expected == null ? null : expected.getName()));
        }
    }

    public List<T> getList() {
        return this.mList;
    }

    public void setInlineCountLimit(int maxCount) {
        this.mInlineCountLimit = maxCount;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        final int N = this.mList.size();
        final int callFlags = flags;
        dest.writeInt(N);
        if (N > 0) {
            int i;
            final Class<?> listElementClass = this.mList.get(0).getClass();
            this.writeParcelableCreator(this.mList.get(0), dest);
            for (i = 0; i < N && i < this.mInlineCountLimit && dest.dataSize() < 65536; ++i) {
                dest.writeInt(1);
                T parcelable = this.mList.get(i);
                BaseMediaParceledListSlice.verifySameType(listElementClass, parcelable.getClass());
                this.writeElement(parcelable, dest, callFlags);
            }
            if (i < N) {
                dest.writeInt(0);
                Binder retriever = new Binder(){

                    @Override
                    protected boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
                        int i;
                        if (code != 1) {
                            return super.onTransact(code, data, reply, flags);
                        }
                        for (i = data.readInt(); i < N && reply.dataSize() < 65536; ++i) {
                            reply.writeInt(1);
                            Object parcelable = BaseMediaParceledListSlice.this.mList.get(i);
                            BaseMediaParceledListSlice.verifySameType(listElementClass, parcelable.getClass());
                            BaseMediaParceledListSlice.this.writeElement(parcelable, reply, callFlags);
                        }
                        if (i < N) {
                            reply.writeInt(0);
                        }
                        return true;
                    }
                };
                dest.writeStrongBinder(retriever);
            }
        }
    }

    abstract void writeElement(T var1, Parcel var2, int var3);

    abstract void writeParcelableCreator(T var1, Parcel var2);

    abstract Parcelable.Creator<?> readParcelableCreator(Parcel var1, ClassLoader var2);
}

