/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.annotation.SystemApi;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.Printer;
import android.util.TimeUtils;
import com.android.internal.lang.System_Delegate;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.text.DecimalFormat;
import java.util.Locale;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;

public class Location
implements Parcelable {
    public static final int FORMAT_DEGREES = 0;
    public static final int FORMAT_MINUTES = 1;
    public static final int FORMAT_SECONDS = 2;
    @SystemApi
    @Deprecated
    public static final String EXTRA_NO_GPS_LOCATION = "noGPSLocation";
    private static final int HAS_ALTITUDE_MASK = 1;
    private static final int HAS_SPEED_MASK = 2;
    private static final int HAS_BEARING_MASK = 4;
    private static final int HAS_HORIZONTAL_ACCURACY_MASK = 8;
    private static final int HAS_MOCK_PROVIDER_MASK = 16;
    private static final int HAS_ALTITUDE_ACCURACY_MASK = 32;
    private static final int HAS_SPEED_ACCURACY_MASK = 64;
    private static final int HAS_BEARING_ACCURACY_MASK = 128;
    private static final int HAS_ELAPSED_REALTIME_UNCERTAINTY_MASK = 256;
    private static final ThreadLocal<BearingDistanceCache> sBearingDistanceCache = ThreadLocal.withInitial(() -> new BearingDistanceCache());
    private int mFieldsMask = 0;
    private String mProvider;
    private long mTimeMs;
    private long mElapsedRealtimeNs;
    private double mElapsedRealtimeUncertaintyNs;
    private double mLatitudeDegrees;
    private double mLongitudeDegrees;
    private float mHorizontalAccuracyMeters;
    private double mAltitudeMeters;
    private float mAltitudeAccuracyMeters;
    private float mSpeedMetersPerSecond;
    private float mSpeedAccuracyMetersPerSecond;
    private float mBearingDegrees;
    private float mBearingAccuracyDegrees;
    private Bundle mExtras = null;
    public static final Parcelable.Creator<Location> CREATOR = new Parcelable.Creator<Location>(){

        @Override
        public Location createFromParcel(Parcel in) {
            Location l = new Location(in.readString8());
            l.mFieldsMask = in.readInt();
            l.mTimeMs = in.readLong();
            l.mElapsedRealtimeNs = in.readLong();
            if (l.hasElapsedRealtimeUncertaintyNanos()) {
                l.mElapsedRealtimeUncertaintyNs = in.readDouble();
            }
            l.mLatitudeDegrees = in.readDouble();
            l.mLongitudeDegrees = in.readDouble();
            if (l.hasAltitude()) {
                l.mAltitudeMeters = in.readDouble();
            }
            if (l.hasSpeed()) {
                l.mSpeedMetersPerSecond = in.readFloat();
            }
            if (l.hasBearing()) {
                l.mBearingDegrees = in.readFloat();
            }
            if (l.hasAccuracy()) {
                l.mHorizontalAccuracyMeters = in.readFloat();
            }
            if (l.hasVerticalAccuracy()) {
                l.mAltitudeAccuracyMeters = in.readFloat();
            }
            if (l.hasSpeedAccuracy()) {
                l.mSpeedAccuracyMetersPerSecond = in.readFloat();
            }
            if (l.hasBearingAccuracy()) {
                l.mBearingAccuracyDegrees = in.readFloat();
            }
            l.mExtras = Bundle.setDefusable(in.readBundle(), true);
            return l;
        }

        public Location[] newArray(int size) {
            return new Location[size];
        }
    };

    public Location(String provider) {
        this.mProvider = provider;
    }

    public Location(Location location) {
        this.set(location);
    }

    public void set(Location location) {
        this.mFieldsMask = location.mFieldsMask;
        this.mProvider = location.mProvider;
        this.mTimeMs = location.mTimeMs;
        this.mElapsedRealtimeNs = location.mElapsedRealtimeNs;
        this.mElapsedRealtimeUncertaintyNs = location.mElapsedRealtimeUncertaintyNs;
        this.mLatitudeDegrees = location.mLatitudeDegrees;
        this.mLongitudeDegrees = location.mLongitudeDegrees;
        this.mHorizontalAccuracyMeters = location.mHorizontalAccuracyMeters;
        this.mAltitudeMeters = location.mAltitudeMeters;
        this.mAltitudeAccuracyMeters = location.mAltitudeAccuracyMeters;
        this.mSpeedMetersPerSecond = location.mSpeedMetersPerSecond;
        this.mSpeedAccuracyMetersPerSecond = location.mSpeedAccuracyMetersPerSecond;
        this.mBearingDegrees = location.mBearingDegrees;
        this.mBearingAccuracyDegrees = location.mBearingAccuracyDegrees;
        this.mExtras = location.mExtras == null ? null : new Bundle(location.mExtras);
    }

    public void reset() {
        this.mProvider = null;
        this.mTimeMs = 0L;
        this.mElapsedRealtimeNs = 0L;
        this.mElapsedRealtimeUncertaintyNs = 0.0;
        this.mFieldsMask = 0;
        this.mLatitudeDegrees = 0.0;
        this.mLongitudeDegrees = 0.0;
        this.mAltitudeMeters = 0.0;
        this.mSpeedMetersPerSecond = 0.0f;
        this.mBearingDegrees = 0.0f;
        this.mHorizontalAccuracyMeters = 0.0f;
        this.mAltitudeAccuracyMeters = 0.0f;
        this.mSpeedAccuracyMetersPerSecond = 0.0f;
        this.mBearingAccuracyDegrees = 0.0f;
        this.mExtras = null;
    }

    public float distanceTo(Location dest) {
        BearingDistanceCache cache = sBearingDistanceCache.get();
        if (this.mLatitudeDegrees != cache.mLat1 || this.mLongitudeDegrees != cache.mLon1 || dest.mLatitudeDegrees != cache.mLat2 || dest.mLongitudeDegrees != cache.mLon2) {
            Location.computeDistanceAndBearing(this.mLatitudeDegrees, this.mLongitudeDegrees, dest.mLatitudeDegrees, dest.mLongitudeDegrees, cache);
        }
        return cache.mDistance;
    }

    public float bearingTo(Location dest) {
        BearingDistanceCache cache = sBearingDistanceCache.get();
        if (this.mLatitudeDegrees != cache.mLat1 || this.mLongitudeDegrees != cache.mLon1 || dest.mLatitudeDegrees != cache.mLat2 || dest.mLongitudeDegrees != cache.mLon2) {
            Location.computeDistanceAndBearing(this.mLatitudeDegrees, this.mLongitudeDegrees, dest.mLatitudeDegrees, dest.mLongitudeDegrees, cache);
        }
        return cache.mInitialBearing;
    }

    public String getProvider() {
        return this.mProvider;
    }

    public void setProvider(String provider) {
        this.mProvider = provider;
    }

    public long getTime() {
        return this.mTimeMs;
    }

    public void setTime(long timeMs) {
        this.mTimeMs = timeMs;
    }

    public long getElapsedRealtimeNanos() {
        return this.mElapsedRealtimeNs;
    }

    public long getElapsedRealtimeMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.mElapsedRealtimeNs);
    }

    public long getElapsedRealtimeAgeMillis() {
        return this.getElapsedRealtimeAgeMillis(SystemClock.elapsedRealtime());
    }

    public long getElapsedRealtimeAgeMillis(long referenceRealtimeMs) {
        return referenceRealtimeMs - this.getElapsedRealtimeMillis();
    }

    public void setElapsedRealtimeNanos(long elapsedRealtimeNs) {
        this.mElapsedRealtimeNs = elapsedRealtimeNs;
    }

    public double getElapsedRealtimeUncertaintyNanos() {
        return this.mElapsedRealtimeUncertaintyNs;
    }

    public void setElapsedRealtimeUncertaintyNanos(double elapsedRealtimeUncertaintyNs) {
        this.mElapsedRealtimeUncertaintyNs = elapsedRealtimeUncertaintyNs;
        this.mFieldsMask |= 0x100;
    }

    public boolean hasElapsedRealtimeUncertaintyNanos() {
        return (this.mFieldsMask & 0x100) != 0;
    }

    public void removeElapsedRealtimeUncertaintyNanos() {
        this.mFieldsMask &= 0xFFFFFEFF;
    }

    public double getLatitude() {
        return this.mLatitudeDegrees;
    }

    public void setLatitude(double latitudeDegrees) {
        this.mLatitudeDegrees = latitudeDegrees;
    }

    public double getLongitude() {
        return this.mLongitudeDegrees;
    }

    public void setLongitude(double longitudeDegrees) {
        this.mLongitudeDegrees = longitudeDegrees;
    }

    public float getAccuracy() {
        return this.mHorizontalAccuracyMeters;
    }

    public void setAccuracy(float horizontalAccuracyMeters) {
        this.mHorizontalAccuracyMeters = horizontalAccuracyMeters;
        this.mFieldsMask |= 8;
    }

    public boolean hasAccuracy() {
        return (this.mFieldsMask & 8) != 0;
    }

    public void removeAccuracy() {
        this.mFieldsMask &= 0xFFFFFFF7;
    }

    public double getAltitude() {
        return this.mAltitudeMeters;
    }

    public void setAltitude(double altitudeMeters) {
        this.mAltitudeMeters = altitudeMeters;
        this.mFieldsMask |= 1;
    }

    public boolean hasAltitude() {
        return (this.mFieldsMask & 1) != 0;
    }

    public void removeAltitude() {
        this.mFieldsMask &= 0xFFFFFFFE;
    }

    public float getVerticalAccuracyMeters() {
        return this.mAltitudeAccuracyMeters;
    }

    public void setVerticalAccuracyMeters(float altitudeAccuracyMeters) {
        this.mAltitudeAccuracyMeters = altitudeAccuracyMeters;
        this.mFieldsMask |= 0x20;
    }

    public boolean hasVerticalAccuracy() {
        return (this.mFieldsMask & 0x20) != 0;
    }

    public void removeVerticalAccuracy() {
        this.mFieldsMask &= 0xFFFFFFDF;
    }

    public float getSpeed() {
        return this.mSpeedMetersPerSecond;
    }

    public void setSpeed(float speedMetersPerSecond) {
        this.mSpeedMetersPerSecond = speedMetersPerSecond;
        this.mFieldsMask |= 2;
    }

    public boolean hasSpeed() {
        return (this.mFieldsMask & 2) != 0;
    }

    public void removeSpeed() {
        this.mFieldsMask &= 0xFFFFFFFD;
    }

    public float getSpeedAccuracyMetersPerSecond() {
        return this.mSpeedAccuracyMetersPerSecond;
    }

    public void setSpeedAccuracyMetersPerSecond(float speedAccuracyMeterPerSecond) {
        this.mSpeedAccuracyMetersPerSecond = speedAccuracyMeterPerSecond;
        this.mFieldsMask |= 0x40;
    }

    public boolean hasSpeedAccuracy() {
        return (this.mFieldsMask & 0x40) != 0;
    }

    public void removeSpeedAccuracy() {
        this.mFieldsMask &= 0xFFFFFFBF;
    }

    public float getBearing() {
        return this.mBearingDegrees;
    }

    public void setBearing(float bearingDegrees) {
        Preconditions.checkArgument(Float.isFinite(bearingDegrees));
        float modBearing = bearingDegrees % 360.0f + 0.0f;
        if (modBearing < 0.0f) {
            modBearing += 360.0f;
        }
        this.mBearingDegrees = modBearing;
        this.mFieldsMask |= 4;
    }

    public boolean hasBearing() {
        return (this.mFieldsMask & 4) != 0;
    }

    public void removeBearing() {
        this.mFieldsMask &= 0xFFFFFFFB;
    }

    public float getBearingAccuracyDegrees() {
        return this.mBearingAccuracyDegrees;
    }

    public void setBearingAccuracyDegrees(float bearingAccuracyDegrees) {
        this.mBearingAccuracyDegrees = bearingAccuracyDegrees;
        this.mFieldsMask |= 0x80;
    }

    public boolean hasBearingAccuracy() {
        return (this.mFieldsMask & 0x80) != 0;
    }

    public void removeBearingAccuracy() {
        this.mFieldsMask &= 0xFFFFFF7F;
    }

    @Deprecated
    public boolean isFromMockProvider() {
        return this.isMock();
    }

    @Deprecated
    @SystemApi
    public void setIsFromMockProvider(boolean isFromMockProvider) {
        this.setMock(isFromMockProvider);
    }

    public boolean isMock() {
        return (this.mFieldsMask & 0x10) != 0;
    }

    public void setMock(boolean mock) {
        this.mFieldsMask = mock ? (this.mFieldsMask |= 0x10) : (this.mFieldsMask &= 0xFFFFFFEF);
    }

    public Bundle getExtras() {
        return this.mExtras;
    }

    public void setExtras(Bundle extras) {
        this.mExtras = extras == null ? null : new Bundle(extras);
    }

    public boolean isComplete() {
        return this.mProvider != null && this.hasAccuracy() && this.mTimeMs != 0L && this.mElapsedRealtimeNs != 0L;
    }

    @SystemApi
    public void makeComplete() {
        if (this.mProvider == null) {
            this.mProvider = "";
        }
        if (!this.hasAccuracy()) {
            this.mFieldsMask |= 8;
            this.mHorizontalAccuracyMeters = 100.0f;
        }
        if (this.mTimeMs == 0L) {
            this.mTimeMs = System_Delegate.currentTimeMillis();
        }
        if (this.mElapsedRealtimeNs == 0L) {
            this.mElapsedRealtimeNs = SystemClock.elapsedRealtimeNanos();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Location)) {
            return false;
        }
        Location location = (Location)o;
        return !(this.mTimeMs != location.mTimeMs || this.mElapsedRealtimeNs != location.mElapsedRealtimeNs || this.hasElapsedRealtimeUncertaintyNanos() != location.hasElapsedRealtimeUncertaintyNanos() || this.hasElapsedRealtimeUncertaintyNanos() && Double.compare(location.mElapsedRealtimeUncertaintyNs, this.mElapsedRealtimeUncertaintyNs) != 0 || Double.compare(location.mLatitudeDegrees, this.mLatitudeDegrees) != 0 || Double.compare(location.mLongitudeDegrees, this.mLongitudeDegrees) != 0 || this.hasAltitude() != location.hasAltitude() || this.hasAltitude() && Double.compare(location.mAltitudeMeters, this.mAltitudeMeters) != 0 || this.hasSpeed() != location.hasSpeed() || this.hasSpeed() && Float.compare(location.mSpeedMetersPerSecond, this.mSpeedMetersPerSecond) != 0 || this.hasBearing() != location.hasBearing() || this.hasBearing() && Float.compare(location.mBearingDegrees, this.mBearingDegrees) != 0 || this.hasAccuracy() != location.hasAccuracy() || this.hasAccuracy() && Float.compare(location.mHorizontalAccuracyMeters, this.mHorizontalAccuracyMeters) != 0 || this.hasVerticalAccuracy() != location.hasVerticalAccuracy() || this.hasVerticalAccuracy() && Float.compare(location.mAltitudeAccuracyMeters, this.mAltitudeAccuracyMeters) != 0 || this.hasSpeedAccuracy() != location.hasSpeedAccuracy() || this.hasSpeedAccuracy() && Float.compare(location.mSpeedAccuracyMetersPerSecond, this.mSpeedAccuracyMetersPerSecond) != 0 || this.hasBearingAccuracy() != location.hasBearingAccuracy() || this.hasBearingAccuracy() && Float.compare(location.mBearingAccuracyDegrees, this.mBearingAccuracyDegrees) != 0 || !Objects.equals(this.mProvider, location.mProvider) || !Location.areExtrasEqual(this.mExtras, location.mExtras));
    }

    private static boolean areExtrasEqual(Bundle extras1, Bundle extras2) {
        if ((extras1 == null || extras1.isEmpty()) && (extras2 == null || extras2.isEmpty())) {
            return true;
        }
        if (extras1 == null || extras2 == null) {
            return false;
        }
        return extras1.kindofEquals(extras2);
    }

    public int hashCode() {
        return Objects.hash(this.mProvider, this.mElapsedRealtimeNs, this.mLatitudeDegrees, this.mLongitudeDegrees);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("Location[");
        s.append(this.mProvider);
        s.append(" ").append(String.format(Locale.ROOT, "%.6f,%.6f", this.mLatitudeDegrees, this.mLongitudeDegrees));
        if (this.hasAccuracy()) {
            s.append(" hAcc=").append(this.mHorizontalAccuracyMeters);
        }
        s.append(" et=");
        TimeUtils.formatDuration(this.getElapsedRealtimeMillis(), s);
        if (this.hasAltitude()) {
            s.append(" alt=").append(this.mAltitudeMeters);
            if (this.hasVerticalAccuracy()) {
                s.append(" vAcc=").append(this.mAltitudeAccuracyMeters);
            }
        }
        if (this.hasSpeed()) {
            s.append(" vel=").append(this.mSpeedMetersPerSecond);
            if (this.hasSpeedAccuracy()) {
                s.append(" sAcc=").append(this.mSpeedAccuracyMetersPerSecond);
            }
        }
        if (this.hasBearing()) {
            s.append(" bear=").append(this.mBearingDegrees);
            if (this.hasBearingAccuracy()) {
                s.append(" bAcc=").append(this.mBearingAccuracyDegrees);
            }
        }
        if (this.isMock()) {
            s.append(" mock");
        }
        if (this.mExtras != null && !this.mExtras.isEmpty()) {
            s.append(" {").append(this.mExtras).append('}');
        }
        s.append(']');
        return s.toString();
    }

    @Deprecated
    public void dump(Printer pw, String prefix) {
        pw.println(prefix + this);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeString8(this.mProvider);
        parcel.writeInt(this.mFieldsMask);
        parcel.writeLong(this.mTimeMs);
        parcel.writeLong(this.mElapsedRealtimeNs);
        if (this.hasElapsedRealtimeUncertaintyNanos()) {
            parcel.writeDouble(this.mElapsedRealtimeUncertaintyNs);
        }
        parcel.writeDouble(this.mLatitudeDegrees);
        parcel.writeDouble(this.mLongitudeDegrees);
        if (this.hasAltitude()) {
            parcel.writeDouble(this.mAltitudeMeters);
        }
        if (this.hasSpeed()) {
            parcel.writeFloat(this.mSpeedMetersPerSecond);
        }
        if (this.hasBearing()) {
            parcel.writeFloat(this.mBearingDegrees);
        }
        if (this.hasAccuracy()) {
            parcel.writeFloat(this.mHorizontalAccuracyMeters);
        }
        if (this.hasVerticalAccuracy()) {
            parcel.writeFloat(this.mAltitudeAccuracyMeters);
        }
        if (this.hasSpeedAccuracy()) {
            parcel.writeFloat(this.mSpeedAccuracyMetersPerSecond);
        }
        if (this.hasBearingAccuracy()) {
            parcel.writeFloat(this.mBearingAccuracyDegrees);
        }
        parcel.writeBundle(this.mExtras);
    }

    public static String convert(double coordinate, int outputType) {
        Preconditions.checkArgumentInRange(coordinate, -180.0, 180.0, "coordinate");
        Preconditions.checkArgument(outputType == 0 || outputType == 1 || outputType == 2, "%d is an unrecognized format", outputType);
        StringBuilder sb = new StringBuilder();
        if (coordinate < 0.0) {
            sb.append('-');
            coordinate = -coordinate;
        }
        DecimalFormat df = new DecimalFormat("###.#####");
        if (outputType == 1 || outputType == 2) {
            int degrees = (int)Math.floor(coordinate);
            sb.append(degrees);
            sb.append(':');
            coordinate -= (double)degrees;
            coordinate *= 60.0;
            if (outputType == 2) {
                int minutes = (int)Math.floor(coordinate);
                sb.append(minutes);
                sb.append(':');
                coordinate -= (double)minutes;
                coordinate *= 60.0;
            }
        }
        sb.append(df.format(coordinate));
        return sb.toString();
    }

    public static double convert(String coordinate) {
        StringTokenizer st;
        int tokens;
        Objects.requireNonNull(coordinate);
        boolean negative = false;
        if (coordinate.charAt(0) == '-') {
            coordinate = coordinate.substring(1);
            negative = true;
        }
        if ((tokens = (st = new StringTokenizer(coordinate, ":")).countTokens()) < 1) {
            throw new IllegalArgumentException("coordinate=" + coordinate);
        }
        try {
            boolean isNegative180;
            double min;
            String degrees = st.nextToken();
            if (tokens == 1) {
                double val = Double.parseDouble(degrees);
                return negative ? -val : val;
            }
            String minutes = st.nextToken();
            int deg = Integer.parseInt(degrees);
            double sec = 0.0;
            boolean secPresent = false;
            if (st.hasMoreTokens()) {
                min = Integer.parseInt(minutes);
                String seconds = st.nextToken();
                sec = Double.parseDouble(seconds);
                secPresent = true;
            } else {
                min = Double.parseDouble(minutes);
            }
            boolean bl = isNegative180 = negative && deg == 180 && min == 0.0 && sec == 0.0;
            if ((double)deg < 0.0 || deg > 179 && !isNegative180) {
                throw new IllegalArgumentException("coordinate=" + coordinate);
            }
            if (min < 0.0 || min >= 60.0 || secPresent && min > 59.0) {
                throw new IllegalArgumentException("coordinate=" + coordinate);
            }
            if (sec < 0.0 || sec >= 60.0) {
                throw new IllegalArgumentException("coordinate=" + coordinate);
            }
            double val = (double)deg * 3600.0 + min * 60.0 + sec;
            return negative ? -val : (val /= 3600.0);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("coordinate=" + coordinate, e);
        }
    }

    private static void computeDistanceAndBearing(double lat1, double lon1, double lat2, double lon2, BearingDistanceCache results) {
        lat1 *= Math.PI / 180;
        lat2 *= Math.PI / 180;
        double a = 6378137.0;
        double b = 6356752.3142;
        double f = (a - b) / a;
        double aSqMinusBSqOverBSq = (a * a - b * b) / (b * b);
        double l = (lon2 *= Math.PI / 180) - (lon1 *= Math.PI / 180);
        double aA = 0.0;
        double u1 = Math.atan((1.0 - f) * Math.tan(lat1));
        double u2 = Math.atan((1.0 - f) * Math.tan(lat2));
        double cosU1 = Math.cos(u1);
        double cosU2 = Math.cos(u2);
        double sinU1 = Math.sin(u1);
        double sinU2 = Math.sin(u2);
        double cosU1cosU2 = cosU1 * cosU2;
        double sinU1sinU2 = sinU1 * sinU2;
        double sigma = 0.0;
        double deltaSigma = 0.0;
        double cosLambda = 0.0;
        double sinLambda = 0.0;
        double lambda = l;
        for (int iter = 0; iter < 20; ++iter) {
            double lambdaOrig = lambda;
            cosLambda = Math.cos(lambda);
            sinLambda = Math.sin(lambda);
            double t1 = cosU2 * sinLambda;
            double t2 = cosU1 * sinU2 - sinU1 * cosU2 * cosLambda;
            double sinSqSigma = t1 * t1 + t2 * t2;
            double sinSigma = Math.sqrt(sinSqSigma);
            double cosSigma = sinU1sinU2 + cosU1cosU2 * cosLambda;
            sigma = Math.atan2(sinSigma, cosSigma);
            double sinAlpha = sinSigma == 0.0 ? 0.0 : cosU1cosU2 * sinLambda / sinSigma;
            double cosSqAlpha = 1.0 - sinAlpha * sinAlpha;
            double cos2SM = cosSqAlpha == 0.0 ? 0.0 : cosSigma - 2.0 * sinU1sinU2 / cosSqAlpha;
            double uSquared = cosSqAlpha * aSqMinusBSqOverBSq;
            aA = 1.0 + uSquared / 16384.0 * (4096.0 + uSquared * (-768.0 + uSquared * (320.0 - 175.0 * uSquared)));
            double bB = uSquared / 1024.0 * (256.0 + uSquared * (-128.0 + uSquared * (74.0 - 47.0 * uSquared)));
            double cC = f / 16.0 * cosSqAlpha * (4.0 + f * (4.0 - 3.0 * cosSqAlpha));
            double cos2SMSq = cos2SM * cos2SM;
            deltaSigma = bB * sinSigma * (cos2SM + bB / 4.0 * (cosSigma * (-1.0 + 2.0 * cos2SMSq) - bB / 6.0 * cos2SM * (-3.0 + 4.0 * sinSigma * sinSigma) * (-3.0 + 4.0 * cos2SMSq)));
            lambda = l + (1.0 - cC) * f * sinAlpha * (sigma + cC * sinSigma * (cos2SM + cC * cosSigma * (-1.0 + 2.0 * cos2SM * cos2SM)));
            double delta = (lambda - lambdaOrig) / lambda;
            if (Math.abs(delta) < 1.0E-12) break;
        }
        results.mDistance = (float)(b * aA * (sigma - deltaSigma));
        float initialBearing = (float)Math.atan2(cosU2 * sinLambda, cosU1 * sinU2 - sinU1 * cosU2 * cosLambda);
        results.mInitialBearing = initialBearing = (float)((double)initialBearing * 57.29577951308232);
        float finalBearing = (float)Math.atan2(cosU1 * sinLambda, -sinU1 * cosU2 + cosU1 * sinU2 * cosLambda);
        results.mFinalBearing = finalBearing = (float)((double)finalBearing * 57.29577951308232);
        results.mLat1 = lat1;
        results.mLat2 = lat2;
        results.mLon1 = lon1;
        results.mLon2 = lon2;
    }

    public static void distanceBetween(double startLatitude, double startLongitude, double endLatitude, double endLongitude, float[] results) {
        if (results == null || results.length < 1) {
            throw new IllegalArgumentException("results is null or has length < 1");
        }
        BearingDistanceCache cache = sBearingDistanceCache.get();
        Location.computeDistanceAndBearing(startLatitude, startLongitude, endLatitude, endLongitude, cache);
        results[0] = cache.mDistance;
        if (results.length > 1) {
            results[1] = cache.mInitialBearing;
            if (results.length > 2) {
                results[2] = cache.mFinalBearing;
            }
        }
    }

    private static class BearingDistanceCache {
        double mLat1 = 0.0;
        double mLon1 = 0.0;
        double mLat2 = 0.0;
        double mLon2 = 0.0;
        float mDistance = 0.0f;
        float mInitialBearing = 0.0f;
        float mFinalBearing = 0.0f;

        private BearingDistanceCache() {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Format {
    }
}

