/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.annotation.SystemApi;
import android.location.GnssExcessPathInfo;
import android.location.GnssReflectingPlane;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@SystemApi
public class GnssSingleSatCorrection
implements Parcelable {
    private static final int HAS_PROB_SAT_IS_LOS_MASK = 1;
    private static final int HAS_COMBINED_EXCESS_PATH_LENGTH_MASK = 2;
    private static final int HAS_COMBINED_EXCESS_PATH_LENGTH_UNC_MASK = 4;
    private static final int HAS_COMBINED_ATTENUATION_MASK = 16;
    private final int mSingleSatCorrectionFlags;
    private final int mConstellationType;
    private final int mSatId;
    private final float mCarrierFrequencyHz;
    private final float mProbSatIsLos;
    private final float mCombinedExcessPathLengthMeters;
    private final float mCombinedExcessPathLengthUncertaintyMeters;
    private final float mCombinedAttenuationDb;
    private final List<GnssExcessPathInfo> mGnssExcessPathInfoList;
    public static final Parcelable.Creator<GnssSingleSatCorrection> CREATOR = new Parcelable.Creator<GnssSingleSatCorrection>(){

        @Override
        public GnssSingleSatCorrection createFromParcel(Parcel parcel) {
            int singleSatCorrectionFlags = parcel.readInt();
            int constellationType = parcel.readInt();
            int satId = parcel.readInt();
            float carrierFrequencyHz = parcel.readFloat();
            float probSatIsLos = (singleSatCorrectionFlags & 1) != 0 ? parcel.readFloat() : 0.0f;
            float combinedExcessPathLengthMeters = (singleSatCorrectionFlags & 2) != 0 ? parcel.readFloat() : 0.0f;
            float combinedExcessPathLengthUncertaintyMeters = (singleSatCorrectionFlags & 4) != 0 ? parcel.readFloat() : 0.0f;
            float combinedAttenuationDb = (singleSatCorrectionFlags & 0x10) != 0 ? parcel.readFloat() : 0.0f;
            ArrayList<GnssExcessPathInfo> gnssExcessPathInfoList = parcel.createTypedArrayList(GnssExcessPathInfo.CREATOR);
            return new GnssSingleSatCorrection(singleSatCorrectionFlags, constellationType, satId, carrierFrequencyHz, probSatIsLos, combinedExcessPathLengthMeters, combinedExcessPathLengthUncertaintyMeters, combinedAttenuationDb, gnssExcessPathInfoList);
        }

        public GnssSingleSatCorrection[] newArray(int i) {
            return new GnssSingleSatCorrection[i];
        }
    };

    private GnssSingleSatCorrection(int singleSatCorrectionFlags, int constellationType, int satId, float carrierFrequencyHz, float probSatIsLos, float excessPathLengthMeters, float excessPathLengthUncertaintyMeters, float combinedAttenuationDb, List<GnssExcessPathInfo> gnssExcessPathInfoList) {
        this.mSingleSatCorrectionFlags = singleSatCorrectionFlags;
        this.mConstellationType = constellationType;
        this.mSatId = satId;
        this.mCarrierFrequencyHz = carrierFrequencyHz;
        this.mProbSatIsLos = probSatIsLos;
        this.mCombinedExcessPathLengthMeters = excessPathLengthMeters;
        this.mCombinedExcessPathLengthUncertaintyMeters = excessPathLengthUncertaintyMeters;
        this.mCombinedAttenuationDb = combinedAttenuationDb;
        this.mGnssExcessPathInfoList = gnssExcessPathInfoList;
    }

    public int getSingleSatelliteCorrectionFlags() {
        return this.mSingleSatCorrectionFlags;
    }

    public int getConstellationType() {
        return this.mConstellationType;
    }

    public int getSatelliteId() {
        return this.mSatId;
    }

    public float getCarrierFrequencyHz() {
        return this.mCarrierFrequencyHz;
    }

    public float getProbabilityLineOfSight() {
        return this.mProbSatIsLos;
    }

    public float getExcessPathLengthMeters() {
        return this.mCombinedExcessPathLengthMeters;
    }

    public float getExcessPathLengthUncertaintyMeters() {
        return this.mCombinedExcessPathLengthUncertaintyMeters;
    }

    public float getCombinedAttenuationDb() {
        return this.mCombinedAttenuationDb;
    }

    @Deprecated
    public GnssReflectingPlane getReflectingPlane() {
        return null;
    }

    public List<GnssExcessPathInfo> getGnssExcessPathInfoList() {
        return this.mGnssExcessPathInfoList;
    }

    public boolean hasValidSatelliteLineOfSight() {
        return (this.mSingleSatCorrectionFlags & 1) != 0;
    }

    public boolean hasExcessPathLength() {
        return (this.mSingleSatCorrectionFlags & 2) != 0;
    }

    public boolean hasExcessPathLengthUncertainty() {
        return (this.mSingleSatCorrectionFlags & 4) != 0;
    }

    @Deprecated
    public boolean hasReflectingPlane() {
        return false;
    }

    public boolean hasCombinedAttenuation() {
        return (this.mSingleSatCorrectionFlags & 0x10) != 0;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.mSingleSatCorrectionFlags);
        parcel.writeInt(this.mConstellationType);
        parcel.writeInt(this.mSatId);
        parcel.writeFloat(this.mCarrierFrequencyHz);
        if (this.hasValidSatelliteLineOfSight()) {
            parcel.writeFloat(this.mProbSatIsLos);
        }
        if (this.hasExcessPathLength()) {
            parcel.writeFloat(this.mCombinedExcessPathLengthMeters);
        }
        if (this.hasExcessPathLengthUncertainty()) {
            parcel.writeFloat(this.mCombinedExcessPathLengthUncertaintyMeters);
        }
        if (this.hasCombinedAttenuation()) {
            parcel.writeFloat(this.mCombinedAttenuationDb);
        }
        parcel.writeTypedList(this.mGnssExcessPathInfoList);
    }

    public boolean equals(Object obj) {
        if (obj instanceof GnssSingleSatCorrection) {
            GnssSingleSatCorrection that = (GnssSingleSatCorrection)obj;
            return !(this.mSingleSatCorrectionFlags != that.mSingleSatCorrectionFlags || this.mConstellationType != that.mConstellationType || this.mSatId != that.mSatId || Float.compare(this.mCarrierFrequencyHz, that.mCarrierFrequencyHz) != 0 || this.hasValidSatelliteLineOfSight() && Float.compare(this.mProbSatIsLos, that.mProbSatIsLos) != 0 || this.hasExcessPathLength() && Float.compare(this.mCombinedExcessPathLengthMeters, that.mCombinedExcessPathLengthMeters) != 0 || this.hasExcessPathLengthUncertainty() && Float.compare(this.mCombinedExcessPathLengthUncertaintyMeters, that.mCombinedExcessPathLengthUncertaintyMeters) != 0 || this.hasCombinedAttenuation() && Float.compare(this.mCombinedAttenuationDb, that.mCombinedAttenuationDb) != 0 || !this.mGnssExcessPathInfoList.equals(that.mGnssExcessPathInfoList));
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mSingleSatCorrectionFlags, this.mConstellationType, this.mSatId, Float.valueOf(this.mCarrierFrequencyHz), Float.valueOf(this.mProbSatIsLos), Float.valueOf(this.mCombinedExcessPathLengthMeters), Float.valueOf(this.mCombinedExcessPathLengthUncertaintyMeters), Float.valueOf(this.mCombinedAttenuationDb), this.mGnssExcessPathInfoList);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("GnssSingleSatCorrection:[");
        builder.append(" ConstellationType=").append(this.mConstellationType);
        builder.append(" SatId=").append(this.mSatId);
        builder.append(" CarrierFrequencyHz=").append(this.mCarrierFrequencyHz);
        if (this.hasValidSatelliteLineOfSight()) {
            builder.append(" ProbSatIsLos=").append(this.mProbSatIsLos);
        }
        if (this.hasExcessPathLength()) {
            builder.append(" CombinedExcessPathLengthMeters=").append(this.mCombinedExcessPathLengthMeters);
        }
        if (this.hasExcessPathLengthUncertainty()) {
            builder.append(" CombinedExcessPathLengthUncertaintyMeters=").append(this.mCombinedExcessPathLengthUncertaintyMeters);
        }
        if (this.hasCombinedAttenuation()) {
            builder.append(" CombinedAttenuationDb=").append(this.mCombinedAttenuationDb);
        }
        if (!this.mGnssExcessPathInfoList.isEmpty()) {
            builder.append(' ').append(this.mGnssExcessPathInfoList.toString());
        }
        builder.append(']');
        return builder.toString();
    }

    public static class Builder {
        private int mSingleSatCorrectionFlags;
        private int mConstellationType;
        private int mSatId;
        private float mCarrierFrequencyHz;
        private float mProbSatIsLos;
        private float mCombinedExcessPathLengthMeters;
        private float mCombinedExcessPathLengthUncertaintyMeters;
        private float mCombinedAttenuationDb;
        private List<GnssExcessPathInfo> mGnssExcessInfoList = new ArrayList<GnssExcessPathInfo>();

        public Builder setConstellationType(int constellationType) {
            this.mConstellationType = constellationType;
            return this;
        }

        public Builder setSatelliteId(int satId) {
            Preconditions.checkArgumentNonnegative(satId, "satId should be non-negative.");
            this.mSatId = satId;
            return this;
        }

        public Builder setCarrierFrequencyHz(float carrierFrequencyHz) {
            Preconditions.checkArgumentInRange(carrierFrequencyHz, 0.0f, Float.MAX_VALUE, "carrierFrequencyHz");
            this.mCarrierFrequencyHz = carrierFrequencyHz;
            return this;
        }

        public Builder setProbabilityLineOfSight(float probSatIsLos) {
            Preconditions.checkArgumentInRange(probSatIsLos, 0.0f, 1.0f, "probSatIsLos should be between 0 and 1.");
            this.mProbSatIsLos = probSatIsLos;
            this.mSingleSatCorrectionFlags |= 1;
            return this;
        }

        public Builder clearProbabilityLineOfSight() {
            this.mProbSatIsLos = 0.0f;
            this.mSingleSatCorrectionFlags &= 0xFFFFFFFE;
            return this;
        }

        public Builder setExcessPathLengthMeters(float combinedExcessPathLengthMeters) {
            Preconditions.checkArgumentInRange(combinedExcessPathLengthMeters, 0.0f, Float.MAX_VALUE, "excessPathLengthMeters");
            this.mCombinedExcessPathLengthMeters = combinedExcessPathLengthMeters;
            this.mSingleSatCorrectionFlags |= 2;
            return this;
        }

        public Builder clearExcessPathLengthMeters() {
            this.mCombinedExcessPathLengthMeters = 0.0f;
            this.mSingleSatCorrectionFlags &= 0xFFFFFFFD;
            return this;
        }

        public Builder setExcessPathLengthUncertaintyMeters(float combinedExcessPathLengthUncertaintyMeters) {
            Preconditions.checkArgumentInRange(combinedExcessPathLengthUncertaintyMeters, 0.0f, Float.MAX_VALUE, "excessPathLengthUncertaintyMeters");
            this.mCombinedExcessPathLengthUncertaintyMeters = combinedExcessPathLengthUncertaintyMeters;
            this.mSingleSatCorrectionFlags |= 4;
            return this;
        }

        public Builder clearExcessPathLengthUncertaintyMeters() {
            this.mCombinedExcessPathLengthUncertaintyMeters = 0.0f;
            this.mSingleSatCorrectionFlags &= 0xFFFFFFFB;
            return this;
        }

        public Builder setCombinedAttenuationDb(float combinedAttenuationDb) {
            Preconditions.checkArgumentInRange(combinedAttenuationDb, 0.0f, Float.MAX_VALUE, "combinedAttenuationDb");
            this.mCombinedAttenuationDb = combinedAttenuationDb;
            this.mSingleSatCorrectionFlags |= 0x10;
            return this;
        }

        public Builder clearCombinedAttenuationDb() {
            this.mCombinedAttenuationDb = 0.0f;
            this.mSingleSatCorrectionFlags &= 0xFFFFFFEF;
            return this;
        }

        @Deprecated
        public Builder setReflectingPlane(GnssReflectingPlane reflectingPlane) {
            return this;
        }

        public Builder setGnssExcessPathInfoList(List<GnssExcessPathInfo> infoList) {
            this.mGnssExcessInfoList = new ArrayList<GnssExcessPathInfo>(infoList);
            return this;
        }

        public GnssSingleSatCorrection build() {
            return new GnssSingleSatCorrection(this.mSingleSatCorrectionFlags, this.mConstellationType, this.mSatId, this.mCarrierFrequencyHz, this.mProbSatIsLos, this.mCombinedExcessPathLengthMeters, this.mCombinedExcessPathLengthUncertaintyMeters, this.mCombinedAttenuationDb, this.mGnssExcessInfoList);
        }
    }
}

