/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.Context;
import android.hardware.radio.Announcement;
import android.hardware.radio.IAnnouncementListener;
import android.hardware.radio.ICloseHandle;
import android.hardware.radio.IRadioService;
import android.hardware.radio.ITuner;
import android.hardware.radio.ProgramSelector;
import android.hardware.radio.RadioMetadata;
import android.hardware.radio.RadioTuner;
import android.hardware.radio.TunerAdapter;
import android.hardware.radio.TunerCallbackAdapter;
import android.hardware.radio.Utils;
import android.os.Handler;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.util.Preconditions;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;

@SystemApi
public class RadioManager {
    private static final String TAG = "BroadcastRadio.manager";
    public static final int STATUS_OK = 0;
    public static final int STATUS_ERROR = Integer.MIN_VALUE;
    public static final int STATUS_PERMISSION_DENIED = -1;
    public static final int STATUS_NO_INIT = -19;
    public static final int STATUS_BAD_VALUE = -22;
    public static final int STATUS_DEAD_OBJECT = -32;
    public static final int STATUS_INVALID_OPERATION = -38;
    public static final int STATUS_TIMED_OUT = -110;
    public static final int CLASS_AM_FM = 0;
    public static final int CLASS_SAT = 1;
    public static final int CLASS_DT = 2;
    public static final int BAND_INVALID = -1;
    public static final int BAND_AM = 0;
    public static final int BAND_FM = 1;
    public static final int BAND_FM_HD = 2;
    public static final int BAND_AM_HD = 3;
    public static final int REGION_ITU_1 = 0;
    public static final int REGION_ITU_2 = 1;
    public static final int REGION_OIRT = 2;
    public static final int REGION_JAPAN = 3;
    public static final int REGION_KOREA = 4;
    public static final int CONFIG_FORCE_MONO = 1;
    public static final int CONFIG_FORCE_ANALOG = 2;
    public static final int CONFIG_FORCE_DIGITAL = 3;
    public static final int CONFIG_RDS_AF = 4;
    public static final int CONFIG_RDS_REG = 5;
    public static final int CONFIG_DAB_DAB_LINKING = 6;
    public static final int CONFIG_DAB_FM_LINKING = 7;
    public static final int CONFIG_DAB_DAB_SOFT_LINKING = 8;
    public static final int CONFIG_DAB_FM_SOFT_LINKING = 9;
    private final Map<Announcement.OnListUpdatedListener, ICloseHandle> mAnnouncementListeners = new HashMap<Announcement.OnListUpdatedListener, ICloseHandle>();
    private final Context mContext;
    private final IRadioService mService;

    @RequiresPermission(value="android.permission.ACCESS_BROADCAST_RADIO")
    public int listModules(List<ModuleProperties> modules) {
        List<ModuleProperties> returnedList;
        if (modules == null) {
            Log.e(TAG, "the output list must not be empty");
            return -22;
        }
        Log.d(TAG, "Listing available tuners...");
        try {
            returnedList = this.mService.listModules();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed listing available tuners", e);
            return -32;
        }
        if (returnedList == null) {
            Log.e(TAG, "Returned list was a null");
            return Integer.MIN_VALUE;
        }
        modules.addAll(returnedList);
        return 0;
    }

    private int nativeListModules(List<ModuleProperties> list) {
        return OverrideMethod.invokeI("android.hardware.radio.RadioManager#nativeListModules(Ljava/util/List;)I", true, this);
    }

    @RequiresPermission(value="android.permission.ACCESS_BROADCAST_RADIO")
    public RadioTuner openTuner(int moduleId, BandConfig config, boolean withAudio, RadioTuner.Callback callback, Handler handler) {
        ITuner tuner;
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be empty");
        }
        Log.d(TAG, "Opening tuner " + moduleId + "...");
        TunerCallbackAdapter halCallback = new TunerCallbackAdapter(callback, handler);
        try {
            tuner = this.mService.openTuner(moduleId, config, withAudio, halCallback);
        }
        catch (RemoteException | IllegalArgumentException | IllegalStateException ex) {
            Log.e(TAG, "Failed to open tuner", ex);
            return null;
        }
        if (tuner == null) {
            Log.e(TAG, "Failed to open tuner");
            return null;
        }
        return new TunerAdapter(tuner, halCallback, config != null ? config.getType() : -1);
    }

    @RequiresPermission(value="android.permission.ACCESS_BROADCAST_RADIO")
    public void addAnnouncementListener(Set<Integer> enabledAnnouncementTypes, Announcement.OnListUpdatedListener listener) {
        this.addAnnouncementListener(cmd -> cmd.run(), enabledAnnouncementTypes, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.ACCESS_BROADCAST_RADIO")
    public void addAnnouncementListener(final Executor executor, Set<Integer> enabledAnnouncementTypes, final Announcement.OnListUpdatedListener listener) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(listener);
        int[] types = enabledAnnouncementTypes.stream().mapToInt(Integer::intValue).toArray();
        IAnnouncementListener.Stub listenerIface = new IAnnouncementListener.Stub(){

            @Override
            public void onListUpdated(List<Announcement> activeAnnouncements) {
                executor.execute(() -> listener.onListUpdated(activeAnnouncements));
            }
        };
        Map<Announcement.OnListUpdatedListener, ICloseHandle> map = this.mAnnouncementListeners;
        synchronized (map) {
            ICloseHandle closeHandle = null;
            try {
                closeHandle = this.mService.addAnnouncementListener(types, listenerIface);
            }
            catch (RemoteException ex) {
                ex.rethrowFromSystemServer();
            }
            Objects.requireNonNull(closeHandle);
            ICloseHandle oldCloseHandle = this.mAnnouncementListeners.put(listener, closeHandle);
            if (oldCloseHandle != null) {
                Utils.close(oldCloseHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.ACCESS_BROADCAST_RADIO")
    public void removeAnnouncementListener(Announcement.OnListUpdatedListener listener) {
        Objects.requireNonNull(listener);
        Map<Announcement.OnListUpdatedListener, ICloseHandle> map = this.mAnnouncementListeners;
        synchronized (map) {
            ICloseHandle closeHandle = this.mAnnouncementListeners.remove(listener);
            if (closeHandle != null) {
                Utils.close(closeHandle);
            }
        }
    }

    public RadioManager(Context context) throws ServiceManager.ServiceNotFoundException {
        this.mContext = context;
        this.mService = IRadioService.Stub.asInterface(ServiceManager.getServiceOrThrow("broadcastradio"));
    }

    public static class ProgramInfo
    implements Parcelable {
        private static final int FLAG_LIVE = 1;
        private static final int FLAG_MUTED = 2;
        private static final int FLAG_TRAFFIC_PROGRAM = 4;
        private static final int FLAG_TRAFFIC_ANNOUNCEMENT = 8;
        private static final int FLAG_TUNED = 16;
        private static final int FLAG_STEREO = 32;
        private final ProgramSelector mSelector;
        private final ProgramSelector.Identifier mLogicallyTunedTo;
        private final ProgramSelector.Identifier mPhysicallyTunedTo;
        private final Collection<ProgramSelector.Identifier> mRelatedContent;
        private final int mInfoFlags;
        private final int mSignalQuality;
        private final RadioMetadata mMetadata;
        private final Map<String, String> mVendorInfo;
        public static final Parcelable.Creator<ProgramInfo> CREATOR = new Parcelable.Creator<ProgramInfo>(){

            @Override
            public ProgramInfo createFromParcel(Parcel in) {
                return new ProgramInfo(in);
            }

            public ProgramInfo[] newArray(int size) {
                return new ProgramInfo[size];
            }
        };

        public ProgramInfo(ProgramSelector selector, ProgramSelector.Identifier logicallyTunedTo, ProgramSelector.Identifier physicallyTunedTo, Collection<ProgramSelector.Identifier> relatedContent, int infoFlags, int signalQuality, RadioMetadata metadata, Map<String, String> vendorInfo) {
            this.mSelector = Objects.requireNonNull(selector);
            this.mLogicallyTunedTo = logicallyTunedTo;
            this.mPhysicallyTunedTo = physicallyTunedTo;
            if (relatedContent == null) {
                this.mRelatedContent = Collections.emptyList();
            } else {
                Preconditions.checkCollectionElementsNotNull(relatedContent, "relatedContent");
                this.mRelatedContent = relatedContent;
            }
            this.mInfoFlags = infoFlags;
            this.mSignalQuality = signalQuality;
            this.mMetadata = metadata;
            this.mVendorInfo = vendorInfo == null ? new HashMap() : vendorInfo;
        }

        public ProgramSelector getSelector() {
            return this.mSelector;
        }

        public ProgramSelector.Identifier getLogicallyTunedTo() {
            return this.mLogicallyTunedTo;
        }

        public ProgramSelector.Identifier getPhysicallyTunedTo() {
            return this.mPhysicallyTunedTo;
        }

        public Collection<ProgramSelector.Identifier> getRelatedContent() {
            return this.mRelatedContent;
        }

        @Deprecated
        public int getChannel() {
            try {
                return (int)this.mSelector.getFirstId(1);
            }
            catch (IllegalArgumentException ex) {
                Log.w(RadioManager.TAG, "Not an AM/FM program");
                return 0;
            }
        }

        @Deprecated
        public int getSubChannel() {
            try {
                return (int)this.mSelector.getFirstId(4) + 1;
            }
            catch (IllegalArgumentException ex) {
                return 0;
            }
        }

        public boolean isTuned() {
            return (this.mInfoFlags & 0x10) != 0;
        }

        public boolean isStereo() {
            return (this.mInfoFlags & 0x20) != 0;
        }

        @Deprecated
        public boolean isDigital() {
            int type;
            ProgramSelector.Identifier id2 = this.mLogicallyTunedTo;
            if (id2 == null) {
                id2 = this.mSelector.getPrimaryId();
            }
            return (type = id2.getType()) != 1 && type != 2;
        }

        public boolean isLive() {
            return (this.mInfoFlags & 1) != 0;
        }

        public boolean isMuted() {
            return (this.mInfoFlags & 2) != 0;
        }

        public boolean isTrafficProgram() {
            return (this.mInfoFlags & 4) != 0;
        }

        public boolean isTrafficAnnouncementActive() {
            return (this.mInfoFlags & 8) != 0;
        }

        public int getSignalStrength() {
            return this.mSignalQuality;
        }

        public RadioMetadata getMetadata() {
            return this.mMetadata;
        }

        public Map<String, String> getVendorInfo() {
            return this.mVendorInfo;
        }

        private ProgramInfo(Parcel in) {
            this.mSelector = Objects.requireNonNull(in.readTypedObject(ProgramSelector.CREATOR));
            this.mLogicallyTunedTo = in.readTypedObject(ProgramSelector.Identifier.CREATOR);
            this.mPhysicallyTunedTo = in.readTypedObject(ProgramSelector.Identifier.CREATOR);
            this.mRelatedContent = in.createTypedArrayList(ProgramSelector.Identifier.CREATOR);
            this.mInfoFlags = in.readInt();
            this.mSignalQuality = in.readInt();
            this.mMetadata = in.readTypedObject(RadioMetadata.CREATOR);
            this.mVendorInfo = Utils.readStringMap(in);
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeTypedObject(this.mSelector, flags);
            dest.writeTypedObject(this.mLogicallyTunedTo, flags);
            dest.writeTypedObject(this.mPhysicallyTunedTo, flags);
            Utils.writeTypedCollection(dest, this.mRelatedContent);
            dest.writeInt(this.mInfoFlags);
            dest.writeInt(this.mSignalQuality);
            dest.writeTypedObject(this.mMetadata, flags);
            Utils.writeStringMap(dest, this.mVendorInfo);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public String toString() {
            return "ProgramInfo [selector=" + this.mSelector + ", logicallyTunedTo=" + Objects.toString(this.mLogicallyTunedTo) + ", physicallyTunedTo=" + Objects.toString(this.mPhysicallyTunedTo) + ", relatedContent=" + this.mRelatedContent.size() + ", infoFlags=" + this.mInfoFlags + ", mSignalQuality=" + this.mSignalQuality + ", mMetadata=" + Objects.toString(this.mMetadata) + "]";
        }

        public int hashCode() {
            return Objects.hash(this.mSelector, this.mLogicallyTunedTo, this.mPhysicallyTunedTo, this.mRelatedContent, this.mInfoFlags, this.mSignalQuality, this.mMetadata, this.mVendorInfo);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ProgramInfo)) {
                return false;
            }
            ProgramInfo other = (ProgramInfo)obj;
            if (!Objects.equals(this.mSelector, other.mSelector)) {
                return false;
            }
            if (!Objects.equals(this.mLogicallyTunedTo, other.mLogicallyTunedTo)) {
                return false;
            }
            if (!Objects.equals(this.mPhysicallyTunedTo, other.mPhysicallyTunedTo)) {
                return false;
            }
            if (!Objects.equals(this.mRelatedContent, other.mRelatedContent)) {
                return false;
            }
            if (this.mInfoFlags != other.mInfoFlags) {
                return false;
            }
            if (this.mSignalQuality != other.mSignalQuality) {
                return false;
            }
            if (!Objects.equals(this.mMetadata, other.mMetadata)) {
                return false;
            }
            return Objects.equals(this.mVendorInfo, other.mVendorInfo);
        }
    }

    public static class AmBandConfig
    extends BandConfig {
        private final boolean mStereo;
        public static final Parcelable.Creator<AmBandConfig> CREATOR = new Parcelable.Creator<AmBandConfig>(){

            @Override
            public AmBandConfig createFromParcel(Parcel in) {
                return new AmBandConfig(in);
            }

            public AmBandConfig[] newArray(int size) {
                return new AmBandConfig[size];
            }
        };

        public AmBandConfig(AmBandDescriptor descriptor) {
            super(descriptor);
            this.mStereo = descriptor.isStereoSupported();
        }

        AmBandConfig(int region, int type, int lowerLimit, int upperLimit, int spacing, boolean stereo) {
            super(region, type, lowerLimit, upperLimit, spacing);
            this.mStereo = stereo;
        }

        public boolean getStereo() {
            return this.mStereo;
        }

        private AmBandConfig(Parcel in) {
            super(in);
            this.mStereo = in.readByte() == 1;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeByte((byte)(this.mStereo ? 1 : 0));
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public String toString() {
            return "AmBandConfig [" + super.toString() + ", mStereo=" + this.mStereo + "]";
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.mStereo ? 1 : 0);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof AmBandConfig)) {
                return false;
            }
            AmBandConfig other = (AmBandConfig)obj;
            return this.mStereo == other.getStereo();
        }

        public static class Builder {
            private final BandDescriptor mDescriptor;
            private boolean mStereo;

            public Builder(AmBandDescriptor descriptor) {
                this.mDescriptor = new BandDescriptor(descriptor.getRegion(), descriptor.getType(), descriptor.getLowerLimit(), descriptor.getUpperLimit(), descriptor.getSpacing());
                this.mStereo = descriptor.isStereoSupported();
            }

            public Builder(AmBandConfig config) {
                this.mDescriptor = new BandDescriptor(config.getRegion(), config.getType(), config.getLowerLimit(), config.getUpperLimit(), config.getSpacing());
                this.mStereo = config.getStereo();
            }

            public AmBandConfig build() {
                AmBandConfig config = new AmBandConfig(this.mDescriptor.getRegion(), this.mDescriptor.getType(), this.mDescriptor.getLowerLimit(), this.mDescriptor.getUpperLimit(), this.mDescriptor.getSpacing(), this.mStereo);
                return config;
            }

            public Builder setStereo(boolean state) {
                this.mStereo = state;
                return this;
            }
        }
    }

    public static class FmBandConfig
    extends BandConfig {
        private final boolean mStereo;
        private final boolean mRds;
        private final boolean mTa;
        private final boolean mAf;
        private final boolean mEa;
        public static final Parcelable.Creator<FmBandConfig> CREATOR = new Parcelable.Creator<FmBandConfig>(){

            @Override
            public FmBandConfig createFromParcel(Parcel in) {
                return new FmBandConfig(in);
            }

            public FmBandConfig[] newArray(int size) {
                return new FmBandConfig[size];
            }
        };

        public FmBandConfig(FmBandDescriptor descriptor) {
            super(descriptor);
            this.mStereo = descriptor.isStereoSupported();
            this.mRds = descriptor.isRdsSupported();
            this.mTa = descriptor.isTaSupported();
            this.mAf = descriptor.isAfSupported();
            this.mEa = descriptor.isEaSupported();
        }

        FmBandConfig(int region, int type, int lowerLimit, int upperLimit, int spacing, boolean stereo, boolean rds, boolean ta, boolean af, boolean ea) {
            super(region, type, lowerLimit, upperLimit, spacing);
            this.mStereo = stereo;
            this.mRds = rds;
            this.mTa = ta;
            this.mAf = af;
            this.mEa = ea;
        }

        public boolean getStereo() {
            return this.mStereo;
        }

        public boolean getRds() {
            return this.mRds;
        }

        public boolean getTa() {
            return this.mTa;
        }

        public boolean getAf() {
            return this.mAf;
        }

        public boolean getEa() {
            return this.mEa;
        }

        private FmBandConfig(Parcel in) {
            super(in);
            this.mStereo = in.readByte() == 1;
            this.mRds = in.readByte() == 1;
            this.mTa = in.readByte() == 1;
            this.mAf = in.readByte() == 1;
            this.mEa = in.readByte() == 1;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeByte((byte)(this.mStereo ? 1 : 0));
            dest.writeByte((byte)(this.mRds ? 1 : 0));
            dest.writeByte((byte)(this.mTa ? 1 : 0));
            dest.writeByte((byte)(this.mAf ? 1 : 0));
            dest.writeByte((byte)(this.mEa ? 1 : 0));
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public String toString() {
            return "FmBandConfig [" + super.toString() + ", mStereo=" + this.mStereo + ", mRds=" + this.mRds + ", mTa=" + this.mTa + ", mAf=" + this.mAf + ", mEa =" + this.mEa + "]";
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.mStereo ? 1 : 0);
            result = 31 * result + (this.mRds ? 1 : 0);
            result = 31 * result + (this.mTa ? 1 : 0);
            result = 31 * result + (this.mAf ? 1 : 0);
            result = 31 * result + (this.mEa ? 1 : 0);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof FmBandConfig)) {
                return false;
            }
            FmBandConfig other = (FmBandConfig)obj;
            if (this.mStereo != other.mStereo) {
                return false;
            }
            if (this.mRds != other.mRds) {
                return false;
            }
            if (this.mTa != other.mTa) {
                return false;
            }
            if (this.mAf != other.mAf) {
                return false;
            }
            return this.mEa == other.mEa;
        }

        public static class Builder {
            private final BandDescriptor mDescriptor;
            private boolean mStereo;
            private boolean mRds;
            private boolean mTa;
            private boolean mAf;
            private boolean mEa;

            public Builder(FmBandDescriptor descriptor) {
                this.mDescriptor = new BandDescriptor(descriptor.getRegion(), descriptor.getType(), descriptor.getLowerLimit(), descriptor.getUpperLimit(), descriptor.getSpacing());
                this.mStereo = descriptor.isStereoSupported();
                this.mRds = descriptor.isRdsSupported();
                this.mTa = descriptor.isTaSupported();
                this.mAf = descriptor.isAfSupported();
                this.mEa = descriptor.isEaSupported();
            }

            public Builder(FmBandConfig config) {
                this.mDescriptor = new BandDescriptor(config.getRegion(), config.getType(), config.getLowerLimit(), config.getUpperLimit(), config.getSpacing());
                this.mStereo = config.getStereo();
                this.mRds = config.getRds();
                this.mTa = config.getTa();
                this.mAf = config.getAf();
                this.mEa = config.getEa();
            }

            public FmBandConfig build() {
                FmBandConfig config = new FmBandConfig(this.mDescriptor.getRegion(), this.mDescriptor.getType(), this.mDescriptor.getLowerLimit(), this.mDescriptor.getUpperLimit(), this.mDescriptor.getSpacing(), this.mStereo, this.mRds, this.mTa, this.mAf, this.mEa);
                return config;
            }

            public Builder setStereo(boolean state) {
                this.mStereo = state;
                return this;
            }

            public Builder setRds(boolean state) {
                this.mRds = state;
                return this;
            }

            public Builder setTa(boolean state) {
                this.mTa = state;
                return this;
            }

            public Builder setAf(boolean state) {
                this.mAf = state;
                return this;
            }

            public Builder setEa(boolean state) {
                this.mEa = state;
                return this;
            }
        }
    }

    public static class BandConfig
    implements Parcelable {
        final BandDescriptor mDescriptor;
        public static final Parcelable.Creator<BandConfig> CREATOR = new Parcelable.Creator<BandConfig>(){

            @Override
            public BandConfig createFromParcel(Parcel in) {
                int type = BandDescriptor.lookupTypeFromParcel(in);
                switch (type) {
                    case 1: 
                    case 2: {
                        return new FmBandConfig(in);
                    }
                    case 0: 
                    case 3: {
                        return new AmBandConfig(in);
                    }
                }
                throw new IllegalArgumentException("Unsupported band: " + type);
            }

            public BandConfig[] newArray(int size) {
                return new BandConfig[size];
            }
        };

        BandConfig(BandDescriptor descriptor) {
            this.mDescriptor = Objects.requireNonNull(descriptor);
        }

        BandConfig(int region, int type, int lowerLimit, int upperLimit, int spacing) {
            this.mDescriptor = new BandDescriptor(region, type, lowerLimit, upperLimit, spacing);
        }

        private BandConfig(Parcel in) {
            this.mDescriptor = new BandDescriptor(in);
        }

        BandDescriptor getDescriptor() {
            return this.mDescriptor;
        }

        public int getRegion() {
            return this.mDescriptor.getRegion();
        }

        public int getType() {
            return this.mDescriptor.getType();
        }

        public int getLowerLimit() {
            return this.mDescriptor.getLowerLimit();
        }

        public int getUpperLimit() {
            return this.mDescriptor.getUpperLimit();
        }

        public int getSpacing() {
            return this.mDescriptor.getSpacing();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            this.mDescriptor.writeToParcel(dest, flags);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public String toString() {
            return "BandConfig [ " + this.mDescriptor.toString() + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.mDescriptor.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            BandConfig other;
            BandDescriptor otherDesc;
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof BandConfig)) {
                return false;
            }
            if (this.mDescriptor == null != ((otherDesc = (other = (BandConfig)obj).getDescriptor()) == null)) {
                return false;
            }
            return this.mDescriptor == null || this.mDescriptor.equals(otherDesc);
        }
    }

    public static class AmBandDescriptor
    extends BandDescriptor {
        private final boolean mStereo;
        public static final Parcelable.Creator<AmBandDescriptor> CREATOR = new Parcelable.Creator<AmBandDescriptor>(){

            @Override
            public AmBandDescriptor createFromParcel(Parcel in) {
                return new AmBandDescriptor(in);
            }

            public AmBandDescriptor[] newArray(int size) {
                return new AmBandDescriptor[size];
            }
        };

        public AmBandDescriptor(int region, int type, int lowerLimit, int upperLimit, int spacing, boolean stereo) {
            super(region, type, lowerLimit, upperLimit, spacing);
            this.mStereo = stereo;
        }

        public boolean isStereoSupported() {
            return this.mStereo;
        }

        private AmBandDescriptor(Parcel in) {
            super(in);
            this.mStereo = in.readByte() == 1;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeByte((byte)(this.mStereo ? 1 : 0));
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public String toString() {
            return "AmBandDescriptor [ " + super.toString() + " mStereo=" + this.mStereo + "]";
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.mStereo ? 1 : 0);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof AmBandDescriptor)) {
                return false;
            }
            AmBandDescriptor other = (AmBandDescriptor)obj;
            return this.mStereo == other.isStereoSupported();
        }
    }

    public static class FmBandDescriptor
    extends BandDescriptor {
        private final boolean mStereo;
        private final boolean mRds;
        private final boolean mTa;
        private final boolean mAf;
        private final boolean mEa;
        public static final Parcelable.Creator<FmBandDescriptor> CREATOR = new Parcelable.Creator<FmBandDescriptor>(){

            @Override
            public FmBandDescriptor createFromParcel(Parcel in) {
                return new FmBandDescriptor(in);
            }

            public FmBandDescriptor[] newArray(int size) {
                return new FmBandDescriptor[size];
            }
        };

        public FmBandDescriptor(int region, int type, int lowerLimit, int upperLimit, int spacing, boolean stereo, boolean rds, boolean ta, boolean af, boolean ea) {
            super(region, type, lowerLimit, upperLimit, spacing);
            this.mStereo = stereo;
            this.mRds = rds;
            this.mTa = ta;
            this.mAf = af;
            this.mEa = ea;
        }

        public boolean isStereoSupported() {
            return this.mStereo;
        }

        public boolean isRdsSupported() {
            return this.mRds;
        }

        public boolean isTaSupported() {
            return this.mTa;
        }

        public boolean isAfSupported() {
            return this.mAf;
        }

        public boolean isEaSupported() {
            return this.mEa;
        }

        private FmBandDescriptor(Parcel in) {
            super(in);
            this.mStereo = in.readByte() == 1;
            this.mRds = in.readByte() == 1;
            this.mTa = in.readByte() == 1;
            this.mAf = in.readByte() == 1;
            this.mEa = in.readByte() == 1;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeByte((byte)(this.mStereo ? 1 : 0));
            dest.writeByte((byte)(this.mRds ? 1 : 0));
            dest.writeByte((byte)(this.mTa ? 1 : 0));
            dest.writeByte((byte)(this.mAf ? 1 : 0));
            dest.writeByte((byte)(this.mEa ? 1 : 0));
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public String toString() {
            return "FmBandDescriptor [ " + super.toString() + " mStereo=" + this.mStereo + ", mRds=" + this.mRds + ", mTa=" + this.mTa + ", mAf=" + this.mAf + ", mEa =" + this.mEa + "]";
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.mStereo ? 1 : 0);
            result = 31 * result + (this.mRds ? 1 : 0);
            result = 31 * result + (this.mTa ? 1 : 0);
            result = 31 * result + (this.mAf ? 1 : 0);
            result = 31 * result + (this.mEa ? 1 : 0);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof FmBandDescriptor)) {
                return false;
            }
            FmBandDescriptor other = (FmBandDescriptor)obj;
            if (this.mStereo != other.isStereoSupported()) {
                return false;
            }
            if (this.mRds != other.isRdsSupported()) {
                return false;
            }
            if (this.mTa != other.isTaSupported()) {
                return false;
            }
            if (this.mAf != other.isAfSupported()) {
                return false;
            }
            return this.mEa == other.isEaSupported();
        }
    }

    public static class BandDescriptor
    implements Parcelable {
        private final int mRegion;
        private final int mType;
        private final int mLowerLimit;
        private final int mUpperLimit;
        private final int mSpacing;
        public static final Parcelable.Creator<BandDescriptor> CREATOR = new Parcelable.Creator<BandDescriptor>(){

            @Override
            public BandDescriptor createFromParcel(Parcel in) {
                int type = BandDescriptor.lookupTypeFromParcel(in);
                switch (type) {
                    case 1: 
                    case 2: {
                        return new FmBandDescriptor(in);
                    }
                    case 0: 
                    case 3: {
                        return new AmBandDescriptor(in);
                    }
                }
                throw new IllegalArgumentException("Unsupported band: " + type);
            }

            public BandDescriptor[] newArray(int size) {
                return new BandDescriptor[size];
            }
        };

        BandDescriptor(int region, int type, int lowerLimit, int upperLimit, int spacing) {
            if (type != 0 && type != 1 && type != 2 && type != 3) {
                throw new IllegalArgumentException("Unsupported band: " + type);
            }
            this.mRegion = region;
            this.mType = type;
            this.mLowerLimit = lowerLimit;
            this.mUpperLimit = upperLimit;
            this.mSpacing = spacing;
        }

        public int getRegion() {
            return this.mRegion;
        }

        public int getType() {
            return this.mType;
        }

        public boolean isAmBand() {
            return this.mType == 0 || this.mType == 3;
        }

        public boolean isFmBand() {
            return this.mType == 1 || this.mType == 2;
        }

        public int getLowerLimit() {
            return this.mLowerLimit;
        }

        public int getUpperLimit() {
            return this.mUpperLimit;
        }

        public int getSpacing() {
            return this.mSpacing;
        }

        private BandDescriptor(Parcel in) {
            this.mRegion = in.readInt();
            this.mType = in.readInt();
            this.mLowerLimit = in.readInt();
            this.mUpperLimit = in.readInt();
            this.mSpacing = in.readInt();
        }

        private static int lookupTypeFromParcel(Parcel in) {
            int pos = in.dataPosition();
            in.readInt();
            int type = in.readInt();
            in.setDataPosition(pos);
            return type;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mRegion);
            dest.writeInt(this.mType);
            dest.writeInt(this.mLowerLimit);
            dest.writeInt(this.mUpperLimit);
            dest.writeInt(this.mSpacing);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public String toString() {
            return "BandDescriptor [mRegion=" + this.mRegion + ", mType=" + this.mType + ", mLowerLimit=" + this.mLowerLimit + ", mUpperLimit=" + this.mUpperLimit + ", mSpacing=" + this.mSpacing + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.mRegion;
            result = 31 * result + this.mType;
            result = 31 * result + this.mLowerLimit;
            result = 31 * result + this.mUpperLimit;
            result = 31 * result + this.mSpacing;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof BandDescriptor)) {
                return false;
            }
            BandDescriptor other = (BandDescriptor)obj;
            if (this.mRegion != other.getRegion()) {
                return false;
            }
            if (this.mType != other.getType()) {
                return false;
            }
            if (this.mLowerLimit != other.getLowerLimit()) {
                return false;
            }
            if (this.mUpperLimit != other.getUpperLimit()) {
                return false;
            }
            return this.mSpacing == other.getSpacing();
        }
    }

    public static class ModuleProperties
    implements Parcelable {
        private final int mId;
        private final String mServiceName;
        private final int mClassId;
        private final String mImplementor;
        private final String mProduct;
        private final String mVersion;
        private final String mSerial;
        private final int mNumTuners;
        private final int mNumAudioSources;
        private final boolean mIsInitializationRequired;
        private final boolean mIsCaptureSupported;
        private final BandDescriptor[] mBands;
        private final boolean mIsBgScanSupported;
        private final Set<Integer> mSupportedProgramTypes;
        private final Set<Integer> mSupportedIdentifierTypes;
        private final Map<String, Integer> mDabFrequencyTable;
        private final Map<String, String> mVendorInfo;
        public static final Parcelable.Creator<ModuleProperties> CREATOR = new Parcelable.Creator<ModuleProperties>(){

            @Override
            public ModuleProperties createFromParcel(Parcel in) {
                return new ModuleProperties(in);
            }

            public ModuleProperties[] newArray(int size) {
                return new ModuleProperties[size];
            }
        };

        public ModuleProperties(int id2, String serviceName, int classId, String implementor, String product, String version, String serial, int numTuners, int numAudioSources, boolean isInitializationRequired, boolean isCaptureSupported, BandDescriptor[] bands, boolean isBgScanSupported, int[] supportedProgramTypes, int[] supportedIdentifierTypes, Map<String, Integer> dabFrequencyTable, Map<String, String> vendorInfo) {
            this.mId = id2;
            this.mServiceName = TextUtils.isEmpty(serviceName) ? "default" : serviceName;
            this.mClassId = classId;
            this.mImplementor = implementor;
            this.mProduct = product;
            this.mVersion = version;
            this.mSerial = serial;
            this.mNumTuners = numTuners;
            this.mNumAudioSources = numAudioSources;
            this.mIsInitializationRequired = isInitializationRequired;
            this.mIsCaptureSupported = isCaptureSupported;
            this.mBands = bands;
            this.mIsBgScanSupported = isBgScanSupported;
            this.mSupportedProgramTypes = ModuleProperties.arrayToSet(supportedProgramTypes);
            this.mSupportedIdentifierTypes = ModuleProperties.arrayToSet(supportedIdentifierTypes);
            if (dabFrequencyTable != null) {
                for (Map.Entry<String, Integer> entry : dabFrequencyTable.entrySet()) {
                    Objects.requireNonNull(entry.getKey());
                    Objects.requireNonNull(entry.getValue());
                }
            }
            this.mDabFrequencyTable = dabFrequencyTable;
            this.mVendorInfo = vendorInfo == null ? new HashMap() : vendorInfo;
        }

        private static Set<Integer> arrayToSet(int[] arr) {
            return Arrays.stream(arr).boxed().collect(Collectors.toSet());
        }

        private static int[] setToArray(Set<Integer> set) {
            return set.stream().mapToInt(Integer::intValue).toArray();
        }

        public int getId() {
            return this.mId;
        }

        public String getServiceName() {
            return this.mServiceName;
        }

        public int getClassId() {
            return this.mClassId;
        }

        public String getImplementor() {
            return this.mImplementor;
        }

        public String getProduct() {
            return this.mProduct;
        }

        public String getVersion() {
            return this.mVersion;
        }

        public String getSerial() {
            return this.mSerial;
        }

        public int getNumTuners() {
            return this.mNumTuners;
        }

        public int getNumAudioSources() {
            return this.mNumAudioSources;
        }

        public boolean isInitializationRequired() {
            return this.mIsInitializationRequired;
        }

        public boolean isCaptureSupported() {
            return this.mIsCaptureSupported;
        }

        public boolean isBackgroundScanningSupported() {
            return this.mIsBgScanSupported;
        }

        public boolean isProgramTypeSupported(int type) {
            return this.mSupportedProgramTypes.contains(type);
        }

        public boolean isProgramIdentifierSupported(int type) {
            return this.mSupportedIdentifierTypes.contains(type);
        }

        public Map<String, Integer> getDabFrequencyTable() {
            return this.mDabFrequencyTable;
        }

        public Map<String, String> getVendorInfo() {
            return this.mVendorInfo;
        }

        public BandDescriptor[] getBands() {
            return this.mBands;
        }

        private ModuleProperties(Parcel in) {
            this.mId = in.readInt();
            String serviceName = in.readString();
            this.mServiceName = TextUtils.isEmpty(serviceName) ? "default" : serviceName;
            this.mClassId = in.readInt();
            this.mImplementor = in.readString();
            this.mProduct = in.readString();
            this.mVersion = in.readString();
            this.mSerial = in.readString();
            this.mNumTuners = in.readInt();
            this.mNumAudioSources = in.readInt();
            this.mIsInitializationRequired = in.readInt() == 1;
            this.mIsCaptureSupported = in.readInt() == 1;
            Parcelable[] tmp = in.readParcelableArray(BandDescriptor.class.getClassLoader(), BandDescriptor.class);
            this.mBands = new BandDescriptor[tmp.length];
            for (int i = 0; i < tmp.length; ++i) {
                this.mBands[i] = (BandDescriptor)tmp[i];
            }
            this.mIsBgScanSupported = in.readInt() == 1;
            this.mSupportedProgramTypes = ModuleProperties.arrayToSet(in.createIntArray());
            this.mSupportedIdentifierTypes = ModuleProperties.arrayToSet(in.createIntArray());
            this.mDabFrequencyTable = Utils.readStringIntMap(in);
            this.mVendorInfo = Utils.readStringMap(in);
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mId);
            dest.writeString(this.mServiceName);
            dest.writeInt(this.mClassId);
            dest.writeString(this.mImplementor);
            dest.writeString(this.mProduct);
            dest.writeString(this.mVersion);
            dest.writeString(this.mSerial);
            dest.writeInt(this.mNumTuners);
            dest.writeInt(this.mNumAudioSources);
            dest.writeInt(this.mIsInitializationRequired ? 1 : 0);
            dest.writeInt(this.mIsCaptureSupported ? 1 : 0);
            dest.writeParcelableArray(this.mBands, flags);
            dest.writeInt(this.mIsBgScanSupported ? 1 : 0);
            dest.writeIntArray(ModuleProperties.setToArray(this.mSupportedProgramTypes));
            dest.writeIntArray(ModuleProperties.setToArray(this.mSupportedIdentifierTypes));
            Utils.writeStringIntMap(dest, this.mDabFrequencyTable);
            Utils.writeStringMap(dest, this.mVendorInfo);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public String toString() {
            return "ModuleProperties [mId=" + this.mId + ", mServiceName=" + this.mServiceName + ", mClassId=" + this.mClassId + ", mImplementor=" + this.mImplementor + ", mProduct=" + this.mProduct + ", mVersion=" + this.mVersion + ", mSerial=" + this.mSerial + ", mNumTuners=" + this.mNumTuners + ", mNumAudioSources=" + this.mNumAudioSources + ", mIsInitializationRequired=" + this.mIsInitializationRequired + ", mIsCaptureSupported=" + this.mIsCaptureSupported + ", mIsBgScanSupported=" + this.mIsBgScanSupported + ", mBands=" + Arrays.toString(this.mBands) + "]";
        }

        public int hashCode() {
            return Objects.hash(this.mId, this.mServiceName, this.mClassId, this.mImplementor, this.mProduct, this.mVersion, this.mSerial, this.mNumTuners, this.mNumAudioSources, this.mIsInitializationRequired, this.mIsCaptureSupported, this.mBands, this.mIsBgScanSupported, this.mDabFrequencyTable, this.mVendorInfo);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ModuleProperties)) {
                return false;
            }
            ModuleProperties other = (ModuleProperties)obj;
            if (this.mId != other.getId()) {
                return false;
            }
            if (!TextUtils.equals(this.mServiceName, other.mServiceName)) {
                return false;
            }
            if (this.mClassId != other.mClassId) {
                return false;
            }
            if (!Objects.equals(this.mImplementor, other.mImplementor)) {
                return false;
            }
            if (!Objects.equals(this.mProduct, other.mProduct)) {
                return false;
            }
            if (!Objects.equals(this.mVersion, other.mVersion)) {
                return false;
            }
            if (!Objects.equals(this.mSerial, other.mSerial)) {
                return false;
            }
            if (this.mNumTuners != other.mNumTuners) {
                return false;
            }
            if (this.mNumAudioSources != other.mNumAudioSources) {
                return false;
            }
            if (this.mIsInitializationRequired != other.mIsInitializationRequired) {
                return false;
            }
            if (this.mIsCaptureSupported != other.mIsCaptureSupported) {
                return false;
            }
            if (!Objects.equals(this.mBands, other.mBands)) {
                return false;
            }
            if (this.mIsBgScanSupported != other.mIsBgScanSupported) {
                return false;
            }
            if (!Objects.equals(this.mDabFrequencyTable, other.mDabFrequencyTable)) {
                return false;
            }
            return Objects.equals(this.mVendorInfo, other.mVendorInfo);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ConfigFlag {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Band {
    }
}

