/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.location;

import android.annotation.SystemApi;
import android.hardware.location.NanoAppRpcService;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@SystemApi
public class NanoAppState
implements Parcelable {
    private long mNanoAppId;
    private int mNanoAppVersion;
    private boolean mIsEnabled;
    private List<String> mNanoAppPermissions = new ArrayList<String>();
    private List<NanoAppRpcService> mNanoAppRpcServiceList = new ArrayList<NanoAppRpcService>();
    public static final Parcelable.Creator<NanoAppState> CREATOR = new Parcelable.Creator<NanoAppState>(){

        @Override
        public NanoAppState createFromParcel(Parcel in) {
            return new NanoAppState(in);
        }

        public NanoAppState[] newArray(int size) {
            return new NanoAppState[size];
        }
    };

    public NanoAppState(long nanoAppId, int appVersion, boolean enabled) {
        this.mNanoAppId = nanoAppId;
        this.mNanoAppVersion = appVersion;
        this.mIsEnabled = enabled;
    }

    public NanoAppState(long nanoAppId, int appVersion, boolean enabled, List<String> nanoAppPermissions) {
        this.mNanoAppId = nanoAppId;
        this.mNanoAppVersion = appVersion;
        this.mIsEnabled = enabled;
        this.mNanoAppPermissions = Collections.unmodifiableList(nanoAppPermissions);
    }

    public NanoAppState(long nanoAppId, int appVersion, boolean enabled, List<String> nanoAppPermissions, List<NanoAppRpcService> nanoAppRpcServiceList) {
        this.mNanoAppId = nanoAppId;
        this.mNanoAppVersion = appVersion;
        this.mIsEnabled = enabled;
        this.mNanoAppPermissions = Collections.unmodifiableList(nanoAppPermissions);
        this.mNanoAppRpcServiceList = Collections.unmodifiableList(nanoAppRpcServiceList);
    }

    public long getNanoAppId() {
        return this.mNanoAppId;
    }

    public long getNanoAppVersion() {
        return this.mNanoAppVersion;
    }

    public boolean isEnabled() {
        return this.mIsEnabled;
    }

    public List<String> getNanoAppPermissions() {
        return this.mNanoAppPermissions;
    }

    public List<NanoAppRpcService> getRpcServices() {
        return this.mNanoAppRpcServiceList;
    }

    private NanoAppState(Parcel in) {
        this.mNanoAppId = in.readLong();
        this.mNanoAppVersion = in.readInt();
        this.mIsEnabled = in.readInt() == 1;
        this.mNanoAppPermissions = new ArrayList<String>();
        in.readStringList(this.mNanoAppPermissions);
        this.mNanoAppRpcServiceList = Collections.unmodifiableList(Arrays.asList(in.readParcelableArray(NanoAppRpcService.class.getClassLoader(), NanoAppRpcService.class)));
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeLong(this.mNanoAppId);
        out.writeInt(this.mNanoAppVersion);
        out.writeInt(this.mIsEnabled ? 1 : 0);
        out.writeStringList(this.mNanoAppPermissions);
        out.writeParcelableArray(this.mNanoAppRpcServiceList.toArray(new NanoAppRpcService[0]), 0);
    }
}

