/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.location;

import android.hardware.location.NanoAppMessage;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IContextHubClientCallback
extends IInterface {
    public void onMessageFromNanoApp(NanoAppMessage var1) throws RemoteException;

    public void onHubReset() throws RemoteException;

    public void onNanoAppAborted(long var1, int var3) throws RemoteException;

    public void onNanoAppLoaded(long var1) throws RemoteException;

    public void onNanoAppUnloaded(long var1) throws RemoteException;

    public void onNanoAppEnabled(long var1) throws RemoteException;

    public void onNanoAppDisabled(long var1) throws RemoteException;

    public void onClientAuthorizationChanged(long var1, int var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IContextHubClientCallback {
        public static final String DESCRIPTOR = "android.hardware.location.IContextHubClientCallback";
        static final int TRANSACTION_onMessageFromNanoApp = 1;
        static final int TRANSACTION_onHubReset = 2;
        static final int TRANSACTION_onNanoAppAborted = 3;
        static final int TRANSACTION_onNanoAppLoaded = 4;
        static final int TRANSACTION_onNanoAppUnloaded = 5;
        static final int TRANSACTION_onNanoAppEnabled = 6;
        static final int TRANSACTION_onNanoAppDisabled = 7;
        static final int TRANSACTION_onClientAuthorizationChanged = 8;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IContextHubClientCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IContextHubClientCallback) {
                return (IContextHubClientCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onMessageFromNanoApp";
                }
                case 2: {
                    return "onHubReset";
                }
                case 3: {
                    return "onNanoAppAborted";
                }
                case 4: {
                    return "onNanoAppLoaded";
                }
                case 5: {
                    return "onNanoAppUnloaded";
                }
                case 6: {
                    return "onNanoAppEnabled";
                }
                case 7: {
                    return "onNanoAppDisabled";
                }
                case 8: {
                    return "onClientAuthorizationChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    NanoAppMessage _arg0 = data.readTypedObject(NanoAppMessage.CREATOR);
                    data.enforceNoDataAvail();
                    this.onMessageFromNanoApp(_arg0);
                    break;
                }
                case 2: {
                    this.onHubReset();
                    break;
                }
                case 3: {
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onNanoAppAborted(_arg0, _arg1);
                    break;
                }
                case 4: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    this.onNanoAppLoaded(_arg0);
                    break;
                }
                case 5: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    this.onNanoAppUnloaded(_arg0);
                    break;
                }
                case 6: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    this.onNanoAppEnabled(_arg0);
                    break;
                }
                case 7: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    this.onNanoAppDisabled(_arg0);
                    break;
                }
                case 8: {
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onClientAuthorizationChanged(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 7;
        }

        private static class Proxy
        implements IContextHubClientCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onMessageFromNanoApp(NanoAppMessage message) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(message, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onHubReset() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNanoAppAborted(long nanoAppId, int abortCode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(nanoAppId);
                    _data.writeInt(abortCode);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNanoAppLoaded(long nanoAppId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(nanoAppId);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNanoAppUnloaded(long nanoAppId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(nanoAppId);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNanoAppEnabled(long nanoAppId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(nanoAppId);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNanoAppDisabled(long nanoAppId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(nanoAppId);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onClientAuthorizationChanged(long nanoAppId, int authorization) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(nanoAppId);
                    _data.writeInt(authorization);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IContextHubClientCallback {
        @Override
        public void onMessageFromNanoApp(NanoAppMessage message) throws RemoteException {
        }

        @Override
        public void onHubReset() throws RemoteException {
        }

        @Override
        public void onNanoAppAborted(long nanoAppId, int abortCode) throws RemoteException {
        }

        @Override
        public void onNanoAppLoaded(long nanoAppId) throws RemoteException {
        }

        @Override
        public void onNanoAppUnloaded(long nanoAppId) throws RemoteException {
        }

        @Override
        public void onNanoAppEnabled(long nanoAppId) throws RemoteException {
        }

        @Override
        public void onNanoAppDisabled(long nanoAppId) throws RemoteException {
        }

        @Override
        public void onClientAuthorizationChanged(long nanoAppId, int authorization) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

