/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.companion.virtual.IVirtualDevice;
import android.hardware.input.VirtualKeyEvent;
import android.os.IBinder;
import android.os.RemoteException;
import java.io.Closeable;

@SystemApi
public class VirtualKeyboard
implements Closeable {
    private final IVirtualDevice mVirtualDevice;
    private final IBinder mToken;

    public VirtualKeyboard(IVirtualDevice virtualDevice, IBinder token) {
        this.mVirtualDevice = virtualDevice;
        this.mToken = token;
    }

    @Override
    @RequiresPermission(value="android.permission.CREATE_VIRTUAL_DEVICE")
    public void close() {
        try {
            this.mVirtualDevice.unregisterInputDevice(this.mToken);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.CREATE_VIRTUAL_DEVICE")
    public void sendKeyEvent(VirtualKeyEvent event) {
        try {
            this.mVirtualDevice.sendKeyEvent(this.mToken, event);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }
}

