/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.hdmi;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.hardware.hdmi.HdmiControlManager;
import android.hardware.hdmi.HdmiDeviceInfo;
import android.hardware.hdmi.IHdmiControlCallback;
import android.hardware.hdmi.IHdmiControlService;
import android.hardware.hdmi.IHdmiVendorCommandListener;
import android.os.Binder;
import android.os.RemoteException;
import android.util.Log;
import java.util.concurrent.Executor;

@SystemApi
public abstract class HdmiClient {
    private static final String TAG = "HdmiClient";
    private static final int UNKNOWN_VENDOR_ID = 0xFFFFFF;
    final IHdmiControlService mService;
    private IHdmiVendorCommandListener mIHdmiVendorCommandListener;

    abstract int getDeviceType();

    HdmiClient(IHdmiControlService service) {
        this.mService = service;
    }

    public void selectDevice(int logicalAddress, Executor executor, OnDeviceSelectedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null.");
        }
        if (executor == null) {
            throw new IllegalArgumentException("executor must not be null.");
        }
        try {
            this.mService.deviceSelect(logicalAddress, HdmiClient.getCallbackWrapper(logicalAddress, executor, listener));
        }
        catch (RemoteException e) {
            Log.e(TAG, "failed to select device: ", e);
        }
    }

    private static IHdmiControlCallback getCallbackWrapper(final int logicalAddress, final Executor executor, final OnDeviceSelectedListener listener) {
        return new IHdmiControlCallback.Stub(){

            @Override
            public void onComplete(int result) {
                Binder.withCleanCallingIdentity(() -> executor.execute(() -> listener.onDeviceSelected(result, logicalAddress)));
            }
        };
    }

    public HdmiDeviceInfo getActiveSource() {
        try {
            return this.mService.getActiveSource();
        }
        catch (RemoteException e) {
            Log.e(TAG, "getActiveSource threw exception ", e);
            return null;
        }
    }

    public void sendKeyEvent(int keyCode, boolean isPressed) {
        try {
            this.mService.sendKeyEvent(this.getDeviceType(), keyCode, isPressed);
        }
        catch (RemoteException e) {
            Log.e(TAG, "sendKeyEvent threw exception ", e);
        }
    }

    public void sendVolumeKeyEvent(int keyCode, boolean isPressed) {
        try {
            this.mService.sendVolumeKeyEvent(this.getDeviceType(), keyCode, isPressed);
        }
        catch (RemoteException e) {
            Log.e(TAG, "sendVolumeKeyEvent threw exception ", e);
            throw e.rethrowFromSystemServer();
        }
    }

    public void sendVendorCommand(int targetAddress, @SuppressLint(value={"MissingNullability"}) byte[] params, boolean hasVendorId) {
        try {
            this.mService.sendVendorCommand(this.getDeviceType(), targetAddress, params, hasVendorId);
        }
        catch (RemoteException e) {
            Log.e(TAG, "failed to send vendor command: ", e);
        }
    }

    public void setVendorCommandListener(HdmiControlManager.VendorCommandListener listener) {
        this.setVendorCommandListener(listener, 0xFFFFFF);
    }

    public void setVendorCommandListener(HdmiControlManager.VendorCommandListener listener, int vendorId) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        if (this.mIHdmiVendorCommandListener != null) {
            throw new IllegalStateException("listener was already set");
        }
        try {
            IHdmiVendorCommandListener wrappedListener = HdmiClient.getListenerWrapper(listener);
            this.mService.addVendorCommandListener(wrappedListener, vendorId);
            this.mIHdmiVendorCommandListener = wrappedListener;
        }
        catch (RemoteException e) {
            Log.e(TAG, "failed to set vendor command listener: ", e);
        }
    }

    private static IHdmiVendorCommandListener getListenerWrapper(final HdmiControlManager.VendorCommandListener listener) {
        return new IHdmiVendorCommandListener.Stub(){

            @Override
            public void onReceived(int srcAddress, int destAddress, byte[] params, boolean hasVendorId) {
                listener.onReceived(srcAddress, destAddress, params, hasVendorId);
            }

            @Override
            public void onControlStateChanged(boolean enabled, int reason) {
                listener.onControlStateChanged(enabled, reason);
            }
        };
    }

    public static interface OnDeviceSelectedListener {
        public void onDeviceSelected(@HdmiControlManager.ControlCallbackResult int var1, int var2);
    }
}

