/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.devicestate;

import android.hardware.devicestate.DeviceStateInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IDeviceStateManagerCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.devicestate.IDeviceStateManagerCallback";

    public void onDeviceStateInfoChanged(DeviceStateInfo var1) throws RemoteException;

    public void onRequestActive(IBinder var1) throws RemoteException;

    public void onRequestCanceled(IBinder var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IDeviceStateManagerCallback {
        static final int TRANSACTION_onDeviceStateInfoChanged = 1;
        static final int TRANSACTION_onRequestActive = 2;
        static final int TRANSACTION_onRequestCanceled = 3;

        public Stub() {
            this.attachInterface(this, IDeviceStateManagerCallback.DESCRIPTOR);
        }

        public static IDeviceStateManagerCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IDeviceStateManagerCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IDeviceStateManagerCallback) {
                return (IDeviceStateManagerCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onDeviceStateInfoChanged";
                }
                case 2: {
                    return "onRequestActive";
                }
                case 3: {
                    return "onRequestCanceled";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IDeviceStateManagerCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    DeviceStateInfo _arg0 = data.readTypedObject(DeviceStateInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onDeviceStateInfoChanged(_arg0);
                    break;
                }
                case 2: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.onRequestActive(_arg0);
                    break;
                }
                case 3: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.onRequestCanceled(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 2;
        }

        private static class Proxy
        implements IDeviceStateManagerCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IDeviceStateManagerCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDeviceStateInfoChanged(DeviceStateInfo info) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDeviceStateManagerCallback.DESCRIPTOR);
                    _data.writeTypedObject(info, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequestActive(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDeviceStateManagerCallback.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequestCanceled(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDeviceStateManagerCallback.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IDeviceStateManagerCallback {
        @Override
        public void onDeviceStateInfoChanged(DeviceStateInfo info) throws RemoteException {
        }

        @Override
        public void onRequestActive(IBinder token) throws RemoteException {
        }

        @Override
        public void onRequestCanceled(IBinder token) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

