/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.devicestate;

import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Objects;

public class DeviceStateInfo
implements Parcelable {
    public static final int CHANGED_SUPPORTED_STATES = 1;
    public static final int CHANGED_BASE_STATE = 2;
    public static final int CHANGED_CURRENT_STATE = 4;
    public final int[] supportedStates;
    public final int baseState;
    public final int currentState;
    public static final Parcelable.Creator<DeviceStateInfo> CREATOR = new Parcelable.Creator<DeviceStateInfo>(){

        @Override
        public DeviceStateInfo createFromParcel(Parcel source) {
            int numberOfSupportedStates = source.readInt();
            int[] supportedStates = new int[numberOfSupportedStates];
            for (int i = 0; i < numberOfSupportedStates; ++i) {
                supportedStates[i] = source.readInt();
            }
            int baseState = source.readInt();
            int currentState = source.readInt();
            return new DeviceStateInfo(supportedStates, baseState, currentState);
        }

        public DeviceStateInfo[] newArray(int size) {
            return new DeviceStateInfo[size];
        }
    };

    public DeviceStateInfo(int[] supportedStates, int baseState, int state) {
        this.supportedStates = supportedStates;
        this.baseState = baseState;
        this.currentState = state;
    }

    public DeviceStateInfo(DeviceStateInfo info) {
        this(Arrays.copyOf(info.supportedStates, info.supportedStates.length), info.baseState, info.currentState);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DeviceStateInfo that = (DeviceStateInfo)other;
        return this.baseState == that.baseState && this.currentState == that.currentState && Arrays.equals(this.supportedStates, that.supportedStates);
    }

    public int hashCode() {
        int result = Objects.hash(this.baseState, this.currentState);
        result = 31 * result + Arrays.hashCode(this.supportedStates);
        return result;
    }

    public int diff(DeviceStateInfo other) {
        int diff = 0;
        if (!Arrays.equals(this.supportedStates, other.supportedStates)) {
            diff |= 1;
        }
        if (this.baseState != other.baseState) {
            diff |= 2;
        }
        if (this.currentState != other.currentState) {
            diff |= 4;
        }
        return diff;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.supportedStates.length);
        for (int i = 0; i < this.supportedStates.length; ++i) {
            dest.writeInt(this.supportedStates[i]);
        }
        dest.writeInt(this.baseState);
        dest.writeInt(this.currentState);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ChangeFlags {
    }
}

