/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import android.hardware.camera2.utils.HashCodeHelpers;
import android.util.Range;
import android.util.Size;
import com.android.internal.util.Preconditions;

public class Capability {
    public static final int COUNT = 3;
    private final int mMode;
    private final int mMaxStreamingWidth;
    private final int mMaxStreamingHeight;
    private final float mMinZoomRatio;
    private final float mMaxZoomRatio;

    public Capability(int mode, int maxStreamingWidth, int maxStreamingHeight, float minZoomRatio, float maxZoomRatio) {
        this.mMode = mode;
        this.mMaxStreamingWidth = Preconditions.checkArgumentNonnegative(maxStreamingWidth, "maxStreamingWidth must be nonnegative");
        this.mMaxStreamingHeight = Preconditions.checkArgumentNonnegative(maxStreamingHeight, "maxStreamingHeight must be nonnegative");
        if (minZoomRatio > maxZoomRatio) {
            throw new IllegalArgumentException("minZoomRatio " + minZoomRatio + " is greater than maxZoomRatio " + maxZoomRatio);
        }
        this.mMinZoomRatio = Preconditions.checkArgumentPositive(minZoomRatio, "minZoomRatio must be positive");
        this.mMaxZoomRatio = Preconditions.checkArgumentPositive(maxZoomRatio, "maxZoomRatio must be positive");
    }

    public int getMode() {
        return this.mMode;
    }

    public Size getMaxStreamingSize() {
        return new Size(this.mMaxStreamingWidth, this.mMaxStreamingHeight);
    }

    public Range<Float> getZoomRatioRange() {
        return new Range<Float>(Float.valueOf(this.mMinZoomRatio), Float.valueOf(this.mMaxZoomRatio));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof Capability) {
            Capability other = (Capability)obj;
            return this.mMode == other.mMode && this.mMaxStreamingWidth == other.mMaxStreamingWidth && this.mMaxStreamingHeight == other.mMaxStreamingHeight && this.mMinZoomRatio == other.mMinZoomRatio && this.mMaxZoomRatio == other.mMaxZoomRatio;
        }
        return false;
    }

    public int hashCode() {
        return HashCodeHelpers.hashCode(this.mMode, this.mMaxStreamingWidth, this.mMaxStreamingHeight, this.mMinZoomRatio, this.mMaxZoomRatio);
    }

    public String toString() {
        return String.format("(mode:%d, maxStreamingSize:%d x %d, zoomRatio: %f-%f)", this.mMode, this.mMaxStreamingWidth, this.mMaxStreamingHeight, Float.valueOf(this.mMinZoomRatio), Float.valueOf(this.mMaxZoomRatio));
    }
}

