/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.impl;

import android.hardware.camera2.CaptureResult;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class FrameNumberTracker {
    private static final String TAG = "FrameNumberTracker";
    private long[] mCompletedFrameNumber = new long[3];
    private final LinkedList<Long>[] mPendingFrameNumbersWithOtherType = new LinkedList[3];
    private final LinkedList<Long>[] mPendingFrameNumbers = new LinkedList[3];
    private final TreeMap<Long, Integer> mFutureErrorMap = new TreeMap();
    private final HashMap<Long, List<CaptureResult>> mPartialResults = new HashMap();

    public FrameNumberTracker() {
        for (int i = 0; i < 3; ++i) {
            this.mCompletedFrameNumber[i] = -1L;
            this.mPendingFrameNumbersWithOtherType[i] = new LinkedList();
            this.mPendingFrameNumbers[i] = new LinkedList();
        }
    }

    private void update() {
        Iterator<Map.Entry<Long, Integer>> iter = this.mFutureErrorMap.entrySet().iterator();
        while (iter.hasNext()) {
            Boolean removeError;
            Long errorFrameNumber;
            block4: {
                int requestType;
                block3: {
                    Map.Entry<Long, Integer> pair = iter.next();
                    errorFrameNumber = pair.getKey();
                    requestType = pair.getValue();
                    removeError = false;
                    if (errorFrameNumber == this.mCompletedFrameNumber[requestType] + 1L) {
                        removeError = true;
                    }
                    if (this.mPendingFrameNumbers[requestType].isEmpty()) break block3;
                    if (errorFrameNumber != this.mPendingFrameNumbers[requestType].element()) break block4;
                    this.mPendingFrameNumbers[requestType].remove();
                    removeError = true;
                    break block4;
                }
                for (int i = 1; i < 3; ++i) {
                    int otherType = (requestType + i) % 3;
                    if (this.mPendingFrameNumbersWithOtherType[otherType].isEmpty() || errorFrameNumber != this.mPendingFrameNumbersWithOtherType[otherType].element()) continue;
                    this.mPendingFrameNumbersWithOtherType[otherType].remove();
                    removeError = true;
                    break;
                }
            }
            if (!removeError.booleanValue()) continue;
            this.mCompletedFrameNumber[requestType] = errorFrameNumber;
            this.mPartialResults.remove(errorFrameNumber);
            iter.remove();
        }
    }

    public void updateTracker(long frameNumber, boolean isError, int requestType) {
        if (isError) {
            this.mFutureErrorMap.put(frameNumber, requestType);
        } else {
            try {
                this.updateCompletedFrameNumber(frameNumber, requestType);
            }
            catch (IllegalArgumentException e) {
                Log.e(TAG, e.getMessage());
            }
        }
        this.update();
    }

    public void updateTracker(long frameNumber, CaptureResult result, boolean partial, int requestType) {
        if (!partial) {
            this.updateTracker(frameNumber, false, requestType);
            return;
        }
        if (result == null) {
            return;
        }
        List<CaptureResult> partials = this.mPartialResults.get(frameNumber);
        if (partials == null) {
            partials = new ArrayList<CaptureResult>();
            this.mPartialResults.put(frameNumber, partials);
        }
        partials.add(result);
    }

    public List<CaptureResult> popPartialResults(long frameNumber) {
        return this.mPartialResults.remove(frameNumber);
    }

    public long getCompletedFrameNumber() {
        return this.mCompletedFrameNumber[0];
    }

    public long getCompletedReprocessFrameNumber() {
        return this.mCompletedFrameNumber[1];
    }

    public long getCompletedZslStillFrameNumber() {
        return this.mCompletedFrameNumber[2];
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateCompletedFrameNumber(long frameNumber, int requestType) throws IllegalArgumentException {
        block12: {
            if (frameNumber <= this.mCompletedFrameNumber[requestType]) {
                throw new IllegalArgumentException("frame number " + frameNumber + " is a repeat");
            }
            int otherType1 = (requestType + 1) % 3;
            int otherType2 = (requestType + 2) % 3;
            long maxOtherFrameNumberSeen = Math.max(this.mCompletedFrameNumber[otherType1], this.mCompletedFrameNumber[otherType2]);
            if (frameNumber < maxOtherFrameNumberSeen) {
                int index;
                LinkedList<Long> dstList;
                LinkedList<Long> srcList;
                boolean inSkippedOther2;
                if (!this.mPendingFrameNumbers[requestType].isEmpty()) {
                    Long pendingFrameNumberSameType = this.mPendingFrameNumbers[requestType].element();
                    if (frameNumber == pendingFrameNumberSameType) {
                        this.mPendingFrameNumbers[requestType].remove();
                        break block12;
                    } else {
                        if (frameNumber < pendingFrameNumberSameType) {
                            throw new IllegalArgumentException("frame number " + frameNumber + " is a repeat");
                        }
                        throw new IllegalArgumentException("frame number " + frameNumber + " comes out of order. Expecting " + pendingFrameNumberSameType);
                    }
                }
                int index1 = this.mPendingFrameNumbersWithOtherType[otherType1].indexOf(frameNumber);
                int index2 = this.mPendingFrameNumbersWithOtherType[otherType2].indexOf(frameNumber);
                boolean inSkippedOther1 = index1 != -1;
                boolean bl = inSkippedOther2 = index2 != -1;
                if (!(inSkippedOther1 ^ inSkippedOther2)) {
                    throw new IllegalArgumentException("frame number " + frameNumber + " is a repeat or invalid");
                }
                if (inSkippedOther1) {
                    srcList = this.mPendingFrameNumbersWithOtherType[otherType1];
                    dstList = this.mPendingFrameNumbers[otherType2];
                    index = index1;
                } else {
                    srcList = this.mPendingFrameNumbersWithOtherType[otherType2];
                    dstList = this.mPendingFrameNumbers[otherType1];
                    index = index2;
                }
                for (int i = 0; i < index; ++i) {
                    dstList.add(srcList.removeFirst());
                }
                srcList.remove();
            } else {
                for (long i = Math.max(maxOtherFrameNumberSeen, this.mCompletedFrameNumber[requestType]) + 1L; i < frameNumber; ++i) {
                    this.mPendingFrameNumbersWithOtherType[requestType].add(i);
                }
            }
        }
        this.mCompletedFrameNumber[requestType] = frameNumber;
    }
}

