/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.impl;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraOfflineSession;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.ICameraDeviceCallbacks;
import android.hardware.camera2.ICameraOfflineSession;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.impl.CaptureCallbackHolder;
import android.hardware.camera2.impl.CaptureResultExtras;
import android.hardware.camera2.impl.FrameNumberTracker;
import android.hardware.camera2.impl.PhysicalCaptureResultInfo;
import android.hardware.camera2.impl.RequestLastFrameNumbersHolder;
import android.hardware.camera2.params.InputConfiguration;
import android.hardware.camera2.params.OutputConfiguration;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import android.util.Range;
import android.util.SparseArray;
import android.view.Surface;
import com.android.internal.util.Preconditions;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

public class CameraOfflineSessionImpl
extends CameraOfflineSession
implements IBinder.DeathRecipient {
    private static final String TAG = "CameraOfflineSessionImpl";
    private static final int REQUEST_ID_NONE = -1;
    private static final long NANO_PER_SECOND = 1000000000L;
    private final boolean DEBUG = false;
    private ICameraOfflineSession mRemoteSession;
    private final AtomicBoolean mClosing = new AtomicBoolean();
    private AbstractMap.SimpleEntry<Integer, InputConfiguration> mOfflineInput = new AbstractMap.SimpleEntry<Integer, Object>(-1, null);
    private SparseArray<OutputConfiguration> mOfflineOutputs = new SparseArray();
    private SparseArray<OutputConfiguration> mConfiguredOutputs = new SparseArray();
    final Object mInterfaceLock = new Object();
    private final String mCameraId;
    private final CameraCharacteristics mCharacteristics;
    private final int mTotalPartialCount;
    private final Executor mOfflineExecutor;
    private final CameraOfflineSession.CameraOfflineSessionCallback mOfflineCallback;
    private final CameraDeviceCallbacks mCallbacks = new CameraDeviceCallbacks();
    private List<RequestLastFrameNumbersHolder> mOfflineRequestLastFrameNumbersList = new ArrayList<RequestLastFrameNumbersHolder>();
    private FrameNumberTracker mFrameNumberTracker = new FrameNumberTracker();
    private SparseArray<CaptureCallbackHolder> mCaptureCallbackMap = new SparseArray();

    public CameraOfflineSessionImpl(String cameraId, CameraCharacteristics characteristics, Executor offlineExecutor, CameraOfflineSession.CameraOfflineSessionCallback offlineCallback, SparseArray<OutputConfiguration> offlineOutputs, AbstractMap.SimpleEntry<Integer, InputConfiguration> offlineInput, SparseArray<OutputConfiguration> configuredOutputs, FrameNumberTracker frameNumberTracker, SparseArray<CaptureCallbackHolder> callbackMap, List<RequestLastFrameNumbersHolder> frameNumberList) {
        if (cameraId == null || characteristics == null) {
            throw new IllegalArgumentException("Null argument given");
        }
        this.mCameraId = cameraId;
        this.mCharacteristics = characteristics;
        Integer partialCount = this.mCharacteristics.get(CameraCharacteristics.REQUEST_PARTIAL_RESULT_COUNT);
        this.mTotalPartialCount = partialCount == null ? 1 : partialCount;
        this.mOfflineRequestLastFrameNumbersList.addAll(frameNumberList);
        this.mFrameNumberTracker = frameNumberTracker;
        this.mCaptureCallbackMap = callbackMap;
        this.mConfiguredOutputs = configuredOutputs;
        this.mOfflineOutputs = offlineOutputs;
        this.mOfflineInput = offlineInput;
        this.mOfflineExecutor = Preconditions.checkNotNull(offlineExecutor, "offline executor must not be null");
        this.mOfflineCallback = Preconditions.checkNotNull(offlineCallback, "offline callback must not be null");
    }

    public CameraDeviceCallbacks getCallbacks() {
        return this.mCallbacks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndFireSequenceComplete() {
        long completedFrameNumber = this.mFrameNumberTracker.getCompletedFrameNumber();
        long completedReprocessFrameNumber = this.mFrameNumberTracker.getCompletedReprocessFrameNumber();
        long completedZslStillFrameNumber = this.mFrameNumberTracker.getCompletedZslStillFrameNumber();
        Iterator<RequestLastFrameNumbersHolder> iter = this.mOfflineRequestLastFrameNumbersList.iterator();
        while (iter.hasNext()) {
            CameraCaptureSession.CaptureCallback callback;
            Executor executor;
            CaptureCallbackHolder holder;
            final RequestLastFrameNumbersHolder requestLastFrameNumbers = iter.next();
            boolean sequenceCompleted = false;
            final int requestId = requestLastFrameNumbers.getRequestId();
            Object object = this.mInterfaceLock;
            synchronized (object) {
                int index = this.mCaptureCallbackMap.indexOfKey(requestId);
                CaptureCallbackHolder captureCallbackHolder = holder = index >= 0 ? this.mCaptureCallbackMap.valueAt(index) : null;
                if (holder != null) {
                    long lastRegularFrameNumber = requestLastFrameNumbers.getLastRegularFrameNumber();
                    long lastReprocessFrameNumber = requestLastFrameNumbers.getLastReprocessFrameNumber();
                    long lastZslStillFrameNumber = requestLastFrameNumbers.getLastZslStillFrameNumber();
                    executor = holder.getCallback().getExecutor();
                    callback = holder.getCallback().getSessionCallback();
                    if (lastRegularFrameNumber <= completedFrameNumber && lastReprocessFrameNumber <= completedReprocessFrameNumber && lastZslStillFrameNumber <= completedZslStillFrameNumber) {
                        sequenceCompleted = true;
                        this.mCaptureCallbackMap.removeAt(index);
                    }
                } else {
                    executor = null;
                    callback = null;
                }
            }
            if (holder == null || sequenceCompleted) {
                iter.remove();
            }
            if (!sequenceCompleted || callback == null || executor == null) continue;
            Runnable resultDispatch = new Runnable(){

                @Override
                public void run() {
                    if (!CameraOfflineSessionImpl.this.isClosed()) {
                        callback.onCaptureSequenceCompleted(CameraOfflineSessionImpl.this, requestId, requestLastFrameNumbers.getLastFrameNumber());
                    }
                }
            };
            long ident = Binder.clearCallingIdentity();
            try {
                executor.execute(resultDispatch);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
            if (this.mCaptureCallbackMap.size() != 0) continue;
            this.getCallbacks().onDeviceIdle();
        }
    }

    private void removeCompletedCallbackHolderLocked(long lastCompletedRegularFrameNumber, long lastCompletedReprocessFrameNumber, long lastCompletedZslStillFrameNumber) {
        boolean isReprocess = false;
        Iterator<RequestLastFrameNumbersHolder> iter = this.mOfflineRequestLastFrameNumbersList.iterator();
        while (iter.hasNext()) {
            RequestLastFrameNumbersHolder requestLastFrameNumbers = iter.next();
            int requestId = requestLastFrameNumbers.getRequestId();
            int index = this.mCaptureCallbackMap.indexOfKey(requestId);
            CaptureCallbackHolder holder = index >= 0 ? this.mCaptureCallbackMap.valueAt(index) : null;
            if (holder == null) continue;
            long lastRegularFrameNumber = requestLastFrameNumbers.getLastRegularFrameNumber();
            long lastReprocessFrameNumber = requestLastFrameNumbers.getLastReprocessFrameNumber();
            long lastZslStillFrameNumber = requestLastFrameNumbers.getLastZslStillFrameNumber();
            if (lastRegularFrameNumber > lastCompletedRegularFrameNumber || lastReprocessFrameNumber > lastCompletedReprocessFrameNumber || lastZslStillFrameNumber > lastCompletedZslStillFrameNumber) continue;
            if (requestLastFrameNumbers.isSequenceCompleted()) {
                this.mCaptureCallbackMap.removeAt(index);
                iter.remove();
                continue;
            }
            Log.e(TAG, "Sequence not yet completed for request id " + requestId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyFailedSwitch() {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            Runnable switchFailDispatch = new Runnable(){

                @Override
                public void run() {
                    CameraOfflineSessionImpl.this.mOfflineCallback.onSwitchFailed(CameraOfflineSessionImpl.this);
                }
            };
            long ident = Binder.clearCallingIdentity();
            try {
                this.mOfflineExecutor.execute(switchFailDispatch);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemoteSession(ICameraOfflineSession remoteSession) throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            if (remoteSession == null) {
                this.notifyFailedSwitch();
                return;
            }
            this.mRemoteSession = remoteSession;
            IBinder remoteSessionBinder = remoteSession.asBinder();
            if (remoteSessionBinder == null) {
                throw new CameraAccessException(2, "The camera offline session has encountered a serious error");
            }
            try {
                remoteSessionBinder.linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                throw new CameraAccessException(2, "The camera offline session has encountered a serious error");
            }
            Runnable readyDispatch = new Runnable(){

                @Override
                public void run() {
                    if (!CameraOfflineSessionImpl.this.isClosed()) {
                        CameraOfflineSessionImpl.this.mOfflineCallback.onReady(CameraOfflineSessionImpl.this);
                    }
                }
            };
            long ident = Binder.clearCallingIdentity();
            try {
                this.mOfflineExecutor.execute(readyDispatch);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    private boolean isClosed() {
        return this.mClosing.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect() {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            if (this.mClosing.getAndSet(true)) {
                return;
            }
            if (this.mRemoteSession != null) {
                this.mRemoteSession.asBinder().unlinkToDeath(this, 0);
                try {
                    this.mRemoteSession.disconnect();
                }
                catch (RemoteException e) {
                    Log.e(TAG, "Exception while disconnecting from offline session: ", e);
                }
            } else {
                throw new IllegalStateException("Offline session is not yet ready");
            }
            this.mRemoteSession = null;
            Runnable closeDispatch = new Runnable(){

                @Override
                public void run() {
                    CameraOfflineSessionImpl.this.mOfflineCallback.onClosed(CameraOfflineSessionImpl.this);
                }
            };
            long ident = Binder.clearCallingIdentity();
            try {
                this.mOfflineExecutor.execute(closeDispatch);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.disconnect();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void binderDied() {
        Log.w(TAG, "CameraOfflineSession on device " + this.mCameraId + " died unexpectedly");
        this.disconnect();
    }

    @Override
    public CameraDevice getDevice() {
        throw new UnsupportedOperationException("Operation not supported in offline mode");
    }

    @Override
    public void prepare(Surface surface) throws CameraAccessException {
        throw new UnsupportedOperationException("Operation not supported in offline mode");
    }

    @Override
    public void prepare(int maxCount, Surface surface) throws CameraAccessException {
        throw new UnsupportedOperationException("Operation not supported in offline mode");
    }

    @Override
    public void tearDown(Surface surface) throws CameraAccessException {
        throw new UnsupportedOperationException("Operation not supported in offline mode");
    }

    @Override
    public void finalizeOutputConfigurations(List<OutputConfiguration> outputConfigs) throws CameraAccessException {
        throw new UnsupportedOperationException("Operation not supported in offline mode");
    }

    @Override
    public int capture(CaptureRequest request, CameraCaptureSession.CaptureCallback callback, Handler handler) throws CameraAccessException {
        throw new UnsupportedOperationException("Operation not supported in offline mode");
    }

    @Override
    public int captureSingleRequest(CaptureRequest request, Executor executor, CameraCaptureSession.CaptureCallback callback) throws CameraAccessException {
        throw new UnsupportedOperationException("Operation not supported in offline mode");
    }

    @Override
    public int captureBurst(List<CaptureRequest> requests, CameraCaptureSession.CaptureCallback callback, Handler handler) throws CameraAccessException {
        throw new UnsupportedOperationException("Operation not supported in offline mode");
    }

    @Override
    public int captureBurstRequests(List<CaptureRequest> requests, Executor executor, CameraCaptureSession.CaptureCallback callback) throws CameraAccessException {
        throw new UnsupportedOperationException("Operation not supported in offline mode");
    }

    @Override
    public int setRepeatingRequest(CaptureRequest request, CameraCaptureSession.CaptureCallback callback, Handler handler) throws CameraAccessException {
        throw new UnsupportedOperationException("Operation not supported in offline mode");
    }

    @Override
    public int setSingleRepeatingRequest(CaptureRequest request, Executor executor, CameraCaptureSession.CaptureCallback callback) throws CameraAccessException {
        throw new UnsupportedOperationException("Operation not supported in offline mode");
    }

    @Override
    public int setRepeatingBurst(List<CaptureRequest> requests, CameraCaptureSession.CaptureCallback callback, Handler handler) throws CameraAccessException {
        throw new UnsupportedOperationException("Operation not supported in offline mode");
    }

    @Override
    public int setRepeatingBurstRequests(List<CaptureRequest> requests, Executor executor, CameraCaptureSession.CaptureCallback callback) throws CameraAccessException {
        throw new UnsupportedOperationException("Operation not supported in offline mode");
    }

    @Override
    public void stopRepeating() throws CameraAccessException {
        throw new UnsupportedOperationException("Operation not supported in offline mode");
    }

    @Override
    public void abortCaptures() throws CameraAccessException {
        throw new UnsupportedOperationException("Operation not supported in offline mode");
    }

    @Override
    public void updateOutputConfiguration(OutputConfiguration config) throws CameraAccessException {
        throw new UnsupportedOperationException("Operation not supported in offline mode");
    }

    @Override
    public boolean isReprocessable() {
        throw new UnsupportedOperationException("Operation not supported in offline mode");
    }

    @Override
    public Surface getInputSurface() {
        throw new UnsupportedOperationException("Operation not supported in offline mode");
    }

    @Override
    public CameraOfflineSession switchToOffline(Collection<Surface> offlineOutputs, Executor executor, CameraOfflineSession.CameraOfflineSessionCallback listener) throws CameraAccessException {
        throw new UnsupportedOperationException("Operation not supported in offline mode");
    }

    @Override
    public boolean supportsOfflineProcessing(Surface surface) {
        throw new UnsupportedOperationException("Operation not supported in offline mode");
    }

    @Override
    public void close() {
        this.disconnect();
    }

    public class CameraDeviceCallbacks
    extends ICameraDeviceCallbacks.Stub {
        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDeviceError(int errorCode, CaptureResultExtras resultExtras) {
            Object object = CameraOfflineSessionImpl.this.mInterfaceLock;
            synchronized (object) {
                switch (errorCode) {
                    case 3: 
                    case 4: 
                    case 5: {
                        this.onCaptureErrorLocked(errorCode, resultExtras);
                        break;
                    }
                    default: {
                        Runnable errorDispatch = new Runnable(){

                            @Override
                            public void run() {
                                if (!CameraOfflineSessionImpl.this.isClosed()) {
                                    CameraOfflineSessionImpl.this.mOfflineCallback.onError(CameraOfflineSessionImpl.this, 0);
                                }
                            }
                        };
                        long ident = Binder.clearCallingIdentity();
                        try {
                            CameraOfflineSessionImpl.this.mOfflineExecutor.execute(errorDispatch);
                            break;
                        }
                        finally {
                            Binder.restoreCallingIdentity(ident);
                        }
                    }
                }
            }
        }

        @Override
        public void onRepeatingRequestError(long lastFrameNumber, int repeatingRequestId) {
            Log.e(CameraOfflineSessionImpl.TAG, "Unexpected repeating request error received. Last frame number is " + lastFrameNumber);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDeviceIdle() {
            Object object = CameraOfflineSessionImpl.this.mInterfaceLock;
            synchronized (object) {
                if (CameraOfflineSessionImpl.this.mRemoteSession == null) {
                    Log.v(CameraOfflineSessionImpl.TAG, "Ignoring idle state notifications during offline switches");
                    return;
                }
                CameraOfflineSessionImpl.this.removeCompletedCallbackHolderLocked(Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE);
                Runnable idleDispatch = new Runnable(){

                    @Override
                    public void run() {
                        if (!CameraOfflineSessionImpl.this.isClosed()) {
                            CameraOfflineSessionImpl.this.mOfflineCallback.onIdle(CameraOfflineSessionImpl.this);
                        }
                    }
                };
                long ident = Binder.clearCallingIdentity();
                try {
                    CameraOfflineSessionImpl.this.mOfflineExecutor.execute(idleDispatch);
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCaptureStarted(final CaptureResultExtras resultExtras, final long timestamp) {
            int requestId = resultExtras.getRequestId();
            final long frameNumber = resultExtras.getFrameNumber();
            long lastCompletedRegularFrameNumber = resultExtras.getLastCompletedRegularFrameNumber();
            long lastCompletedReprocessFrameNumber = resultExtras.getLastCompletedReprocessFrameNumber();
            long lastCompletedZslFrameNumber = resultExtras.getLastCompletedZslFrameNumber();
            Object object = CameraOfflineSessionImpl.this.mInterfaceLock;
            synchronized (object) {
                CameraOfflineSessionImpl.this.removeCompletedCallbackHolderLocked(lastCompletedRegularFrameNumber, lastCompletedReprocessFrameNumber, lastCompletedZslFrameNumber);
                final CaptureCallbackHolder holder = CameraOfflineSessionImpl.this.mCaptureCallbackMap.get(requestId);
                if (holder == null) {
                    return;
                }
                Executor executor = holder.getCallback().getExecutor();
                if (CameraOfflineSessionImpl.this.isClosed() || executor == null) {
                    return;
                }
                long ident = Binder.clearCallingIdentity();
                try {
                    executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            CameraCaptureSession.CaptureCallback callback = holder.getCallback().getSessionCallback();
                            if (!CameraOfflineSessionImpl.this.isClosed() && callback != null) {
                                int subsequenceId = resultExtras.getSubsequenceId();
                                CaptureRequest request = holder.getRequest(subsequenceId);
                                if (holder.hasBatchedOutputs()) {
                                    Range<Integer> fpsRange = request.get(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE);
                                    for (int i = 0; i < holder.getRequestCount(); ++i) {
                                        CaptureRequest cbRequest = holder.getRequest(i);
                                        long cbTimestamp = timestamp - (long)(subsequenceId - i) * 1000000000L / (long)fpsRange.getUpper().intValue();
                                        long cbFrameNumber = frameNumber - (long)(subsequenceId - i);
                                        callback.onCaptureStarted(CameraOfflineSessionImpl.this, cbRequest, cbTimestamp, cbFrameNumber);
                                    }
                                } else {
                                    callback.onCaptureStarted(CameraOfflineSessionImpl.this, holder.getRequest(resultExtras.getSubsequenceId()), timestamp, frameNumber);
                                }
                            }
                        }
                    });
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onResultReceived(CameraMetadataNative result, final CaptureResultExtras resultExtras, PhysicalCaptureResultInfo[] physicalResults) throws RemoteException {
            int requestId = resultExtras.getRequestId();
            long frameNumber = resultExtras.getFrameNumber();
            Object object = CameraOfflineSessionImpl.this.mInterfaceLock;
            synchronized (object) {
                CaptureResult finalResult;
                result.set(CameraCharacteristics.LENS_INFO_SHADING_MAP_SIZE, CameraOfflineSessionImpl.this.mCharacteristics.get(CameraCharacteristics.LENS_INFO_SHADING_MAP_SIZE));
                final CaptureCallbackHolder holder = CameraOfflineSessionImpl.this.mCaptureCallbackMap.get(requestId);
                final CaptureRequest request = holder.getRequest(resultExtras.getSubsequenceId());
                boolean isPartialResult = resultExtras.getPartialResultCount() < CameraOfflineSessionImpl.this.mTotalPartialCount;
                int requestType = request.getRequestType();
                if (holder == null) {
                    CameraOfflineSessionImpl.this.mFrameNumberTracker.updateTracker(frameNumber, null, isPartialResult, requestType);
                    return;
                }
                if (CameraOfflineSessionImpl.this.isClosed()) {
                    CameraOfflineSessionImpl.this.mFrameNumberTracker.updateTracker(frameNumber, null, isPartialResult, requestType);
                    return;
                }
                Runnable resultDispatch = null;
                final CameraMetadataNative resultCopy = holder.hasBatchedOutputs() ? new CameraMetadataNative(result) : null;
                Executor executor = holder.getCallback().getExecutor();
                if (isPartialResult) {
                    final CaptureResult resultAsCapture = new CaptureResult(CameraOfflineSessionImpl.this.mCameraId, result, request, resultExtras);
                    resultDispatch = new Runnable(){

                        @Override
                        public void run() {
                            CameraCaptureSession.CaptureCallback callback = holder.getCallback().getSessionCallback();
                            if (!CameraOfflineSessionImpl.this.isClosed() && callback != null) {
                                if (holder.hasBatchedOutputs()) {
                                    for (int i = 0; i < holder.getRequestCount(); ++i) {
                                        CameraMetadataNative resultLocal = new CameraMetadataNative(resultCopy);
                                        CaptureResult resultInBatch = new CaptureResult(CameraOfflineSessionImpl.this.mCameraId, resultLocal, holder.getRequest(i), resultExtras);
                                        CaptureRequest cbRequest = holder.getRequest(i);
                                        callback.onCaptureProgressed(CameraOfflineSessionImpl.this, cbRequest, resultInBatch);
                                    }
                                } else {
                                    callback.onCaptureProgressed(CameraOfflineSessionImpl.this, request, resultAsCapture);
                                }
                            }
                        }
                    };
                    finalResult = resultAsCapture;
                } else {
                    final List<CaptureResult> partialResults = CameraOfflineSessionImpl.this.mFrameNumberTracker.popPartialResults(frameNumber);
                    final long sensorTimestamp = result.get(CaptureResult.SENSOR_TIMESTAMP);
                    final Range<Integer> fpsRange = request.get(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE);
                    final int subsequenceId = resultExtras.getSubsequenceId();
                    final TotalCaptureResult resultAsCapture = new TotalCaptureResult(CameraOfflineSessionImpl.this.mCameraId, result, request, resultExtras, partialResults, holder.getSessionId(), physicalResults);
                    resultDispatch = new Runnable(){

                        @Override
                        public void run() {
                            CameraCaptureSession.CaptureCallback callback = holder.getCallback().getSessionCallback();
                            if (!CameraOfflineSessionImpl.this.isClosed() && callback != null) {
                                if (holder.hasBatchedOutputs()) {
                                    for (int i = 0; i < holder.getRequestCount(); ++i) {
                                        resultCopy.set(CaptureResult.SENSOR_TIMESTAMP, Long.valueOf(sensorTimestamp - (long)(subsequenceId - i) * 1000000000L / (long)((Integer)fpsRange.getUpper()).intValue()));
                                        CameraMetadataNative resultLocal = new CameraMetadataNative(resultCopy);
                                        TotalCaptureResult resultInBatch = new TotalCaptureResult(CameraOfflineSessionImpl.this.mCameraId, resultLocal, holder.getRequest(i), resultExtras, partialResults, holder.getSessionId(), new PhysicalCaptureResultInfo[0]);
                                        CaptureRequest cbRequest = holder.getRequest(i);
                                        callback.onCaptureCompleted(CameraOfflineSessionImpl.this, cbRequest, resultInBatch);
                                    }
                                } else {
                                    callback.onCaptureCompleted(CameraOfflineSessionImpl.this, request, resultAsCapture);
                                }
                            }
                        }
                    };
                    finalResult = resultAsCapture;
                }
                if (executor != null) {
                    long ident = Binder.clearCallingIdentity();
                    try {
                        executor.execute(resultDispatch);
                    }
                    finally {
                        Binder.restoreCallingIdentity(ident);
                    }
                }
                CameraOfflineSessionImpl.this.mFrameNumberTracker.updateTracker(frameNumber, finalResult, isPartialResult, requestType);
                if (!isPartialResult) {
                    CameraOfflineSessionImpl.this.checkAndFireSequenceComplete();
                }
            }
        }

        @Override
        public void onPrepared(int streamId) {
            Log.e(CameraOfflineSessionImpl.TAG, "Unexpected stream " + streamId + " is prepared");
        }

        @Override
        public void onRequestQueueEmpty() {
            Log.v(CameraOfflineSessionImpl.TAG, "onRequestQueueEmpty");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onCaptureErrorLocked(int errorCode, CaptureResultExtras resultExtras) {
            int requestId = resultExtras.getRequestId();
            int subsequenceId = resultExtras.getSubsequenceId();
            final long frameNumber = resultExtras.getFrameNumber();
            String errorPhysicalCameraId = resultExtras.getErrorPhysicalCameraId();
            final CaptureCallbackHolder holder = CameraOfflineSessionImpl.this.mCaptureCallbackMap.get(requestId);
            if (holder == null) {
                Log.e(CameraOfflineSessionImpl.TAG, String.format("Receive capture error on unknown request ID %d", requestId));
                return;
            }
            final CaptureRequest request = holder.getRequest(subsequenceId);
            Runnable failureDispatch = null;
            if (errorCode == 5) {
                OutputConfiguration config = CameraOfflineSessionImpl.this.mRemoteSession == null && !CameraOfflineSessionImpl.this.isClosed() ? CameraOfflineSessionImpl.this.mConfiguredOutputs.get(resultExtras.getErrorStreamId()) : CameraOfflineSessionImpl.this.mOfflineOutputs.get(resultExtras.getErrorStreamId());
                if (config == null) {
                    Log.v(CameraOfflineSessionImpl.TAG, String.format("Stream %d has been removed. Skipping buffer lost callback", resultExtras.getErrorStreamId()));
                    return;
                }
                for (final Surface surface : config.getSurfaces()) {
                    if (!request.containsTarget(surface)) continue;
                    Executor executor = holder.getCallback().getExecutor();
                    failureDispatch = new Runnable(){

                        @Override
                        public void run() {
                            CameraCaptureSession.CaptureCallback callback = holder.getCallback().getSessionCallback();
                            if (!CameraOfflineSessionImpl.this.isClosed() && callback != null) {
                                callback.onCaptureBufferLost(CameraOfflineSessionImpl.this, request, surface, frameNumber);
                            }
                        }
                    };
                    if (executor == null) continue;
                    long ident = Binder.clearCallingIdentity();
                    try {
                        executor.execute(failureDispatch);
                    }
                    finally {
                        Binder.restoreCallingIdentity(ident);
                    }
                }
            } else {
                boolean mayHaveBuffers = errorCode == 4;
                int reason = 0;
                final CaptureFailure failure = new CaptureFailure(request, reason, mayHaveBuffers, requestId, frameNumber, errorPhysicalCameraId);
                Executor executor = holder.getCallback().getExecutor();
                failureDispatch = new Runnable(){

                    @Override
                    public void run() {
                        CameraCaptureSession.CaptureCallback callback = holder.getCallback().getSessionCallback();
                        if (!CameraOfflineSessionImpl.this.isClosed() && callback != null) {
                            callback.onCaptureFailed(CameraOfflineSessionImpl.this, request, failure);
                        }
                    }
                };
                CameraOfflineSessionImpl.this.mFrameNumberTracker.updateTracker(frameNumber, true, request.getRequestType());
                CameraOfflineSessionImpl.this.checkAndFireSequenceComplete();
                if (executor != null) {
                    long ident = Binder.clearCallingIdentity();
                    try {
                        executor.execute(failureDispatch);
                    }
                    finally {
                        Binder.restoreCallingIdentity(ident);
                    }
                }
            }
        }
    }
}

