/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.extension;

import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.extension.CameraSessionConfig;
import android.hardware.camera2.extension.ICaptureCallback;
import android.hardware.camera2.extension.IRequestProcessorImpl;
import android.hardware.camera2.extension.OutputSurface;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ISessionProcessorImpl
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.camera2.extension.ISessionProcessorImpl";

    public CameraSessionConfig initSession(String var1, OutputSurface var2, OutputSurface var3) throws RemoteException;

    public void deInitSession() throws RemoteException;

    public void onCaptureSessionStart(IRequestProcessorImpl var1) throws RemoteException;

    public void onCaptureSessionEnd() throws RemoteException;

    public int startRepeating(ICaptureCallback var1) throws RemoteException;

    public void stopRepeating() throws RemoteException;

    public int startCapture(ICaptureCallback var1) throws RemoteException;

    public void setParameters(CaptureRequest var1) throws RemoteException;

    public int startTrigger(CaptureRequest var1, ICaptureCallback var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISessionProcessorImpl {
        static final int TRANSACTION_initSession = 1;
        static final int TRANSACTION_deInitSession = 2;
        static final int TRANSACTION_onCaptureSessionStart = 3;
        static final int TRANSACTION_onCaptureSessionEnd = 4;
        static final int TRANSACTION_startRepeating = 5;
        static final int TRANSACTION_stopRepeating = 6;
        static final int TRANSACTION_startCapture = 7;
        static final int TRANSACTION_setParameters = 8;
        static final int TRANSACTION_startTrigger = 9;

        public Stub() {
            this.attachInterface(this, ISessionProcessorImpl.DESCRIPTOR);
        }

        public static ISessionProcessorImpl asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ISessionProcessorImpl.DESCRIPTOR);
            if (iin != null && iin instanceof ISessionProcessorImpl) {
                return (ISessionProcessorImpl)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "initSession";
                }
                case 2: {
                    return "deInitSession";
                }
                case 3: {
                    return "onCaptureSessionStart";
                }
                case 4: {
                    return "onCaptureSessionEnd";
                }
                case 5: {
                    return "startRepeating";
                }
                case 6: {
                    return "stopRepeating";
                }
                case 7: {
                    return "startCapture";
                }
                case 8: {
                    return "setParameters";
                }
                case 9: {
                    return "startTrigger";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ISessionProcessorImpl.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    OutputSurface _arg1 = data.readTypedObject(OutputSurface.CREATOR);
                    OutputSurface _arg2 = data.readTypedObject(OutputSurface.CREATOR);
                    data.enforceNoDataAvail();
                    CameraSessionConfig _result = this.initSession(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 2: {
                    this.deInitSession();
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    IRequestProcessorImpl _arg0 = IRequestProcessorImpl.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.onCaptureSessionStart(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    this.onCaptureSessionEnd();
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    ICaptureCallback _arg0 = ICaptureCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    int _result = this.startRepeating(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 6: {
                    this.stopRepeating();
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    ICaptureCallback _arg0 = ICaptureCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    int _result = this.startCapture(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 8: {
                    CaptureRequest _arg0 = data.readTypedObject(CaptureRequest.CREATOR);
                    data.enforceNoDataAvail();
                    this.setParameters(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    CaptureRequest _arg0 = data.readTypedObject(CaptureRequest.CREATOR);
                    ICaptureCallback _arg1 = ICaptureCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    int _result = this.startTrigger(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 8;
        }

        private static class Proxy
        implements ISessionProcessorImpl {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ISessionProcessorImpl.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CameraSessionConfig initSession(String cameraId, OutputSurface previewSurface, OutputSurface imageCaptureSurface) throws RemoteException {
                CameraSessionConfig _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISessionProcessorImpl.DESCRIPTOR);
                    _data.writeString(cameraId);
                    _data.writeTypedObject(previewSurface, 0);
                    _data.writeTypedObject(imageCaptureSurface, 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(CameraSessionConfig.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deInitSession() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISessionProcessorImpl.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCaptureSessionStart(IRequestProcessorImpl requestProcessor) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISessionProcessorImpl.DESCRIPTOR);
                    _data.writeStrongInterface(requestProcessor);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCaptureSessionEnd() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISessionProcessorImpl.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int startRepeating(ICaptureCallback callback) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISessionProcessorImpl.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopRepeating() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISessionProcessorImpl.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int startCapture(ICaptureCallback callback) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISessionProcessorImpl.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setParameters(CaptureRequest captureRequest) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISessionProcessorImpl.DESCRIPTOR);
                    _data.writeTypedObject(captureRequest, 0);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int startTrigger(CaptureRequest captureRequest, ICaptureCallback callback) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISessionProcessorImpl.DESCRIPTOR);
                    _data.writeTypedObject(captureRequest, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements ISessionProcessorImpl {
        @Override
        public CameraSessionConfig initSession(String cameraId, OutputSurface previewSurface, OutputSurface imageCaptureSurface) throws RemoteException {
            return null;
        }

        @Override
        public void deInitSession() throws RemoteException {
        }

        @Override
        public void onCaptureSessionStart(IRequestProcessorImpl requestProcessor) throws RemoteException {
        }

        @Override
        public void onCaptureSessionEnd() throws RemoteException {
        }

        @Override
        public int startRepeating(ICaptureCallback callback) throws RemoteException {
            return 0;
        }

        @Override
        public void stopRepeating() throws RemoteException {
        }

        @Override
        public int startCapture(ICaptureCallback callback) throws RemoteException {
            return 0;
        }

        @Override
        public void setParameters(CaptureRequest captureRequest) throws RemoteException {
        }

        @Override
        public int startTrigger(CaptureRequest captureRequest, ICaptureCallback callback) throws RemoteException {
            return 0;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

