/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.extension;

import android.hardware.camera2.extension.CaptureStageImpl;
import android.hardware.camera2.extension.ICaptureProcessorImpl;
import android.hardware.camera2.extension.LatencyRange;
import android.hardware.camera2.extension.Size;
import android.hardware.camera2.extension.SizeList;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IImageCaptureExtenderImpl
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.camera2.extension.IImageCaptureExtenderImpl";

    public void onInit(String var1, CameraMetadataNative var2) throws RemoteException;

    public void onDeInit() throws RemoteException;

    public CaptureStageImpl onPresetSession() throws RemoteException;

    public CaptureStageImpl onEnableSession() throws RemoteException;

    public CaptureStageImpl onDisableSession() throws RemoteException;

    public boolean isExtensionAvailable(String var1, CameraMetadataNative var2) throws RemoteException;

    public void init(String var1, CameraMetadataNative var2) throws RemoteException;

    public ICaptureProcessorImpl getCaptureProcessor() throws RemoteException;

    public List<CaptureStageImpl> getCaptureStages() throws RemoteException;

    public int getMaxCaptureStage() throws RemoteException;

    public List<SizeList> getSupportedResolutions() throws RemoteException;

    public LatencyRange getEstimatedCaptureLatencyRange(Size var1) throws RemoteException;

    public CameraMetadataNative getAvailableCaptureRequestKeys() throws RemoteException;

    public CameraMetadataNative getAvailableCaptureResultKeys() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IImageCaptureExtenderImpl {
        static final int TRANSACTION_onInit = 1;
        static final int TRANSACTION_onDeInit = 2;
        static final int TRANSACTION_onPresetSession = 3;
        static final int TRANSACTION_onEnableSession = 4;
        static final int TRANSACTION_onDisableSession = 5;
        static final int TRANSACTION_isExtensionAvailable = 6;
        static final int TRANSACTION_init = 7;
        static final int TRANSACTION_getCaptureProcessor = 8;
        static final int TRANSACTION_getCaptureStages = 9;
        static final int TRANSACTION_getMaxCaptureStage = 10;
        static final int TRANSACTION_getSupportedResolutions = 11;
        static final int TRANSACTION_getEstimatedCaptureLatencyRange = 12;
        static final int TRANSACTION_getAvailableCaptureRequestKeys = 13;
        static final int TRANSACTION_getAvailableCaptureResultKeys = 14;

        public Stub() {
            this.attachInterface(this, IImageCaptureExtenderImpl.DESCRIPTOR);
        }

        public static IImageCaptureExtenderImpl asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IImageCaptureExtenderImpl.DESCRIPTOR);
            if (iin != null && iin instanceof IImageCaptureExtenderImpl) {
                return (IImageCaptureExtenderImpl)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onInit";
                }
                case 2: {
                    return "onDeInit";
                }
                case 3: {
                    return "onPresetSession";
                }
                case 4: {
                    return "onEnableSession";
                }
                case 5: {
                    return "onDisableSession";
                }
                case 6: {
                    return "isExtensionAvailable";
                }
                case 7: {
                    return "init";
                }
                case 8: {
                    return "getCaptureProcessor";
                }
                case 9: {
                    return "getCaptureStages";
                }
                case 10: {
                    return "getMaxCaptureStage";
                }
                case 11: {
                    return "getSupportedResolutions";
                }
                case 12: {
                    return "getEstimatedCaptureLatencyRange";
                }
                case 13: {
                    return "getAvailableCaptureRequestKeys";
                }
                case 14: {
                    return "getAvailableCaptureResultKeys";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IImageCaptureExtenderImpl.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    CameraMetadataNative _arg1 = data.readTypedObject(CameraMetadataNative.CREATOR);
                    data.enforceNoDataAvail();
                    this.onInit(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    this.onDeInit();
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    CaptureStageImpl _result = this.onPresetSession();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 4: {
                    CaptureStageImpl _result = this.onEnableSession();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 5: {
                    CaptureStageImpl _result = this.onDisableSession();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 6: {
                    String _arg0 = data.readString();
                    CameraMetadataNative _arg1 = data.readTypedObject(CameraMetadataNative.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.isExtensionAvailable(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 7: {
                    String _arg0 = data.readString();
                    CameraMetadataNative _arg1 = data.readTypedObject(CameraMetadataNative.CREATOR);
                    data.enforceNoDataAvail();
                    this.init(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    ICaptureProcessorImpl _result = this.getCaptureProcessor();
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 9: {
                    List<CaptureStageImpl> _result = this.getCaptureStages();
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    break;
                }
                case 10: {
                    int _result = this.getMaxCaptureStage();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 11: {
                    List<SizeList> _result = this.getSupportedResolutions();
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    break;
                }
                case 12: {
                    Size _arg0 = data.readTypedObject(Size.CREATOR);
                    data.enforceNoDataAvail();
                    LatencyRange _result = this.getEstimatedCaptureLatencyRange(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 13: {
                    CameraMetadataNative _result = this.getAvailableCaptureRequestKeys();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 14: {
                    CameraMetadataNative _result = this.getAvailableCaptureResultKeys();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 13;
        }

        private static class Proxy
        implements IImageCaptureExtenderImpl {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IImageCaptureExtenderImpl.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onInit(String cameraId, CameraMetadataNative cameraCharacteristics) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IImageCaptureExtenderImpl.DESCRIPTOR);
                    _data.writeString(cameraId);
                    _data.writeTypedObject(cameraCharacteristics, 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDeInit() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IImageCaptureExtenderImpl.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CaptureStageImpl onPresetSession() throws RemoteException {
                CaptureStageImpl _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IImageCaptureExtenderImpl.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(CaptureStageImpl.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CaptureStageImpl onEnableSession() throws RemoteException {
                CaptureStageImpl _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IImageCaptureExtenderImpl.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(CaptureStageImpl.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CaptureStageImpl onDisableSession() throws RemoteException {
                CaptureStageImpl _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IImageCaptureExtenderImpl.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(CaptureStageImpl.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isExtensionAvailable(String cameraId, CameraMetadataNative chars) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IImageCaptureExtenderImpl.DESCRIPTOR);
                    _data.writeString(cameraId);
                    _data.writeTypedObject(chars, 0);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void init(String cameraId, CameraMetadataNative chars) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IImageCaptureExtenderImpl.DESCRIPTOR);
                    _data.writeString(cameraId);
                    _data.writeTypedObject(chars, 0);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ICaptureProcessorImpl getCaptureProcessor() throws RemoteException {
                ICaptureProcessorImpl _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IImageCaptureExtenderImpl.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = ICaptureProcessorImpl.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<CaptureStageImpl> getCaptureStages() throws RemoteException {
                ArrayList<CaptureStageImpl> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IImageCaptureExtenderImpl.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(CaptureStageImpl.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getMaxCaptureStage() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IImageCaptureExtenderImpl.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<SizeList> getSupportedResolutions() throws RemoteException {
                ArrayList<SizeList> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IImageCaptureExtenderImpl.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(SizeList.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public LatencyRange getEstimatedCaptureLatencyRange(Size outputSize) throws RemoteException {
                LatencyRange _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IImageCaptureExtenderImpl.DESCRIPTOR);
                    _data.writeTypedObject(outputSize, 0);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(LatencyRange.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CameraMetadataNative getAvailableCaptureRequestKeys() throws RemoteException {
                CameraMetadataNative _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IImageCaptureExtenderImpl.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(CameraMetadataNative.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CameraMetadataNative getAvailableCaptureResultKeys() throws RemoteException {
                CameraMetadataNative _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IImageCaptureExtenderImpl.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(CameraMetadataNative.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IImageCaptureExtenderImpl {
        @Override
        public void onInit(String cameraId, CameraMetadataNative cameraCharacteristics) throws RemoteException {
        }

        @Override
        public void onDeInit() throws RemoteException {
        }

        @Override
        public CaptureStageImpl onPresetSession() throws RemoteException {
            return null;
        }

        @Override
        public CaptureStageImpl onEnableSession() throws RemoteException {
            return null;
        }

        @Override
        public CaptureStageImpl onDisableSession() throws RemoteException {
            return null;
        }

        @Override
        public boolean isExtensionAvailable(String cameraId, CameraMetadataNative chars) throws RemoteException {
            return false;
        }

        @Override
        public void init(String cameraId, CameraMetadataNative chars) throws RemoteException {
        }

        @Override
        public ICaptureProcessorImpl getCaptureProcessor() throws RemoteException {
            return null;
        }

        @Override
        public List<CaptureStageImpl> getCaptureStages() throws RemoteException {
            return null;
        }

        @Override
        public int getMaxCaptureStage() throws RemoteException {
            return 0;
        }

        @Override
        public List<SizeList> getSupportedResolutions() throws RemoteException {
            return null;
        }

        @Override
        public LatencyRange getEstimatedCaptureLatencyRange(Size outputSize) throws RemoteException {
            return null;
        }

        @Override
        public CameraMetadataNative getAvailableCaptureRequestKeys() throws RemoteException {
            return null;
        }

        @Override
        public CameraMetadataNative getAvailableCaptureResultKeys() throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

