/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2;

import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.ICameraDeviceCallbacks;
import android.hardware.camera2.ICameraOfflineSession;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.params.OutputConfiguration;
import android.hardware.camera2.params.SessionConfiguration;
import android.hardware.camera2.utils.SubmitInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.Surface;

public interface ICameraDeviceUser
extends IInterface {
    public static final int NO_IN_FLIGHT_REPEATING_FRAMES = -1;
    public static final int NORMAL_MODE = 0;
    public static final int CONSTRAINED_HIGH_SPEED_MODE = 1;
    public static final int VENDOR_MODE_START = 32768;
    public static final int TEMPLATE_PREVIEW = 1;
    public static final int TEMPLATE_STILL_CAPTURE = 2;
    public static final int TEMPLATE_RECORD = 3;
    public static final int TEMPLATE_VIDEO_SNAPSHOT = 4;
    public static final int TEMPLATE_ZERO_SHUTTER_LAG = 5;
    public static final int TEMPLATE_MANUAL = 6;
    public static final int AUDIO_RESTRICTION_NONE = 0;
    public static final int AUDIO_RESTRICTION_VIBRATION = 1;
    public static final int AUDIO_RESTRICTION_VIBRATION_SOUND = 3;

    public void disconnect() throws RemoteException;

    public SubmitInfo submitRequest(CaptureRequest var1, boolean var2) throws RemoteException;

    public SubmitInfo submitRequestList(CaptureRequest[] var1, boolean var2) throws RemoteException;

    public long cancelRequest(int var1) throws RemoteException;

    public void beginConfigure() throws RemoteException;

    public int[] endConfigure(int var1, CameraMetadataNative var2, long var3) throws RemoteException;

    public boolean isSessionConfigurationSupported(SessionConfiguration var1) throws RemoteException;

    public void deleteStream(int var1) throws RemoteException;

    public int createStream(OutputConfiguration var1) throws RemoteException;

    public int createInputStream(int var1, int var2, int var3, boolean var4) throws RemoteException;

    public Surface getInputSurface() throws RemoteException;

    public CameraMetadataNative createDefaultRequest(int var1) throws RemoteException;

    public CameraMetadataNative getCameraInfo() throws RemoteException;

    public void waitUntilIdle() throws RemoteException;

    public long flush() throws RemoteException;

    public void prepare(int var1) throws RemoteException;

    public void tearDown(int var1) throws RemoteException;

    public void prepare2(int var1, int var2) throws RemoteException;

    public void updateOutputConfiguration(int var1, OutputConfiguration var2) throws RemoteException;

    public void finalizeOutputConfigurations(int var1, OutputConfiguration var2) throws RemoteException;

    public void setCameraAudioRestriction(int var1) throws RemoteException;

    public int getGlobalAudioRestriction() throws RemoteException;

    public ICameraOfflineSession switchToOffline(ICameraDeviceCallbacks var1, int[] var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ICameraDeviceUser {
        public static final String DESCRIPTOR = "android.hardware.camera2.ICameraDeviceUser";
        static final int TRANSACTION_disconnect = 1;
        static final int TRANSACTION_submitRequest = 2;
        static final int TRANSACTION_submitRequestList = 3;
        static final int TRANSACTION_cancelRequest = 4;
        static final int TRANSACTION_beginConfigure = 5;
        static final int TRANSACTION_endConfigure = 6;
        static final int TRANSACTION_isSessionConfigurationSupported = 7;
        static final int TRANSACTION_deleteStream = 8;
        static final int TRANSACTION_createStream = 9;
        static final int TRANSACTION_createInputStream = 10;
        static final int TRANSACTION_getInputSurface = 11;
        static final int TRANSACTION_createDefaultRequest = 12;
        static final int TRANSACTION_getCameraInfo = 13;
        static final int TRANSACTION_waitUntilIdle = 14;
        static final int TRANSACTION_flush = 15;
        static final int TRANSACTION_prepare = 16;
        static final int TRANSACTION_tearDown = 17;
        static final int TRANSACTION_prepare2 = 18;
        static final int TRANSACTION_updateOutputConfiguration = 19;
        static final int TRANSACTION_finalizeOutputConfigurations = 20;
        static final int TRANSACTION_setCameraAudioRestriction = 21;
        static final int TRANSACTION_getGlobalAudioRestriction = 22;
        static final int TRANSACTION_switchToOffline = 23;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ICameraDeviceUser asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ICameraDeviceUser) {
                return (ICameraDeviceUser)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "disconnect";
                }
                case 2: {
                    return "submitRequest";
                }
                case 3: {
                    return "submitRequestList";
                }
                case 4: {
                    return "cancelRequest";
                }
                case 5: {
                    return "beginConfigure";
                }
                case 6: {
                    return "endConfigure";
                }
                case 7: {
                    return "isSessionConfigurationSupported";
                }
                case 8: {
                    return "deleteStream";
                }
                case 9: {
                    return "createStream";
                }
                case 10: {
                    return "createInputStream";
                }
                case 11: {
                    return "getInputSurface";
                }
                case 12: {
                    return "createDefaultRequest";
                }
                case 13: {
                    return "getCameraInfo";
                }
                case 14: {
                    return "waitUntilIdle";
                }
                case 15: {
                    return "flush";
                }
                case 16: {
                    return "prepare";
                }
                case 17: {
                    return "tearDown";
                }
                case 18: {
                    return "prepare2";
                }
                case 19: {
                    return "updateOutputConfiguration";
                }
                case 20: {
                    return "finalizeOutputConfigurations";
                }
                case 21: {
                    return "setCameraAudioRestriction";
                }
                case 22: {
                    return "getGlobalAudioRestriction";
                }
                case 23: {
                    return "switchToOffline";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    this.disconnect();
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    CaptureRequest _arg0 = data.readTypedObject(CaptureRequest.CREATOR);
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    SubmitInfo _result = this.submitRequest(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 3: {
                    CaptureRequest[] _arg0 = data.createTypedArray(CaptureRequest.CREATOR);
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    SubmitInfo _result = this.submitRequestList(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    long _result = this.cancelRequest(_arg0);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 5: {
                    this.beginConfigure();
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    CameraMetadataNative _arg1 = data.readTypedObject(CameraMetadataNative.CREATOR);
                    long _arg2 = data.readLong();
                    data.enforceNoDataAvail();
                    int[] _result = this.endConfigure(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 7: {
                    SessionConfiguration _arg0 = data.readTypedObject(SessionConfiguration.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.isSessionConfigurationSupported(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.deleteStream(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    OutputConfiguration _arg0 = data.readTypedObject(OutputConfiguration.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.createStream(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    boolean _arg3 = data.readBoolean();
                    data.enforceNoDataAvail();
                    int _result = this.createInputStream(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 11: {
                    Surface _result = this.getInputSurface();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    CameraMetadataNative _result = this.createDefaultRequest(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 13: {
                    CameraMetadataNative _result = this.getCameraInfo();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 14: {
                    this.waitUntilIdle();
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    long _result = this.flush();
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 16: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.prepare(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.tearDown(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.prepare2(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    int _arg0 = data.readInt();
                    OutputConfiguration _arg1 = data.readTypedObject(OutputConfiguration.CREATOR);
                    data.enforceNoDataAvail();
                    this.updateOutputConfiguration(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 20: {
                    int _arg0 = data.readInt();
                    OutputConfiguration _arg1 = data.readTypedObject(OutputConfiguration.CREATOR);
                    data.enforceNoDataAvail();
                    this.finalizeOutputConfigurations(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 21: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setCameraAudioRestriction(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 22: {
                    int _result = this.getGlobalAudioRestriction();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 23: {
                    ICameraDeviceCallbacks _arg0 = ICameraDeviceCallbacks.Stub.asInterface(data.readStrongBinder());
                    int[] _arg1 = data.createIntArray();
                    data.enforceNoDataAvail();
                    ICameraOfflineSession _result = this.switchToOffline(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 22;
        }

        private static class Proxy
        implements ICameraDeviceUser {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disconnect() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SubmitInfo submitRequest(CaptureRequest request, boolean streaming) throws RemoteException {
                SubmitInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    _data.writeBoolean(streaming);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(SubmitInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SubmitInfo submitRequestList(CaptureRequest[] requestList, boolean streaming) throws RemoteException {
                SubmitInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedArray(requestList, 0);
                    _data.writeBoolean(streaming);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(SubmitInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long cancelRequest(int requestId) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(requestId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void beginConfigure() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] endConfigure(int operatingMode, CameraMetadataNative sessionParams, long startTimeMs) throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(operatingMode);
                    _data.writeTypedObject(sessionParams, 0);
                    _data.writeLong(startTimeMs);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSessionConfigurationSupported(SessionConfiguration sessionConfiguration) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(sessionConfiguration, 0);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deleteStream(int streamId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamId);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int createStream(OutputConfiguration outputConfiguration) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(outputConfiguration, 0);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int createInputStream(int width, int height, int format, boolean isMultiResolution) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(width);
                    _data.writeInt(height);
                    _data.writeInt(format);
                    _data.writeBoolean(isMultiResolution);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Surface getInputSurface() throws RemoteException {
                Surface _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Surface.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CameraMetadataNative createDefaultRequest(int templateId) throws RemoteException {
                CameraMetadataNative _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(templateId);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(CameraMetadataNative.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CameraMetadataNative getCameraInfo() throws RemoteException {
                CameraMetadataNative _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(CameraMetadataNative.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void waitUntilIdle() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long flush() throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void prepare(int streamId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamId);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void tearDown(int streamId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamId);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void prepare2(int maxCount, int streamId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(maxCount);
                    _data.writeInt(streamId);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateOutputConfiguration(int streamId, OutputConfiguration outputConfiguration) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamId);
                    _data.writeTypedObject(outputConfiguration, 0);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finalizeOutputConfigurations(int streamId, OutputConfiguration outputConfiguration) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamId);
                    _data.writeTypedObject(outputConfiguration, 0);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setCameraAudioRestriction(int mode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(mode);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getGlobalAudioRestriction() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ICameraOfflineSession switchToOffline(ICameraDeviceCallbacks callbacks, int[] offlineOutputIds) throws RemoteException {
                ICameraOfflineSession _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callbacks);
                    _data.writeIntArray(offlineOutputIds);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                    _result = ICameraOfflineSession.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements ICameraDeviceUser {
        @Override
        public void disconnect() throws RemoteException {
        }

        @Override
        public SubmitInfo submitRequest(CaptureRequest request, boolean streaming) throws RemoteException {
            return null;
        }

        @Override
        public SubmitInfo submitRequestList(CaptureRequest[] requestList, boolean streaming) throws RemoteException {
            return null;
        }

        @Override
        public long cancelRequest(int requestId) throws RemoteException {
            return 0L;
        }

        @Override
        public void beginConfigure() throws RemoteException {
        }

        @Override
        public int[] endConfigure(int operatingMode, CameraMetadataNative sessionParams, long startTimeMs) throws RemoteException {
            return null;
        }

        @Override
        public boolean isSessionConfigurationSupported(SessionConfiguration sessionConfiguration) throws RemoteException {
            return false;
        }

        @Override
        public void deleteStream(int streamId) throws RemoteException {
        }

        @Override
        public int createStream(OutputConfiguration outputConfiguration) throws RemoteException {
            return 0;
        }

        @Override
        public int createInputStream(int width, int height, int format, boolean isMultiResolution) throws RemoteException {
            return 0;
        }

        @Override
        public Surface getInputSurface() throws RemoteException {
            return null;
        }

        @Override
        public CameraMetadataNative createDefaultRequest(int templateId) throws RemoteException {
            return null;
        }

        @Override
        public CameraMetadataNative getCameraInfo() throws RemoteException {
            return null;
        }

        @Override
        public void waitUntilIdle() throws RemoteException {
        }

        @Override
        public long flush() throws RemoteException {
            return 0L;
        }

        @Override
        public void prepare(int streamId) throws RemoteException {
        }

        @Override
        public void tearDown(int streamId) throws RemoteException {
        }

        @Override
        public void prepare2(int maxCount, int streamId) throws RemoteException {
        }

        @Override
        public void updateOutputConfiguration(int streamId, OutputConfiguration outputConfiguration) throws RemoteException {
        }

        @Override
        public void finalizeOutputConfigurations(int streamId, OutputConfiguration outputConfiguration) throws RemoteException {
        }

        @Override
        public void setCameraAudioRestriction(int mode) throws RemoteException {
        }

        @Override
        public int getGlobalAudioRestriction() throws RemoteException {
            return 0;
        }

        @Override
        public ICameraOfflineSession switchToOffline(ICameraDeviceCallbacks callbacks, int[] offlineOutputIds) throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

