/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.biometrics;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IBiometricServiceReceiver
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.biometrics.IBiometricServiceReceiver";

    public void onAuthenticationSucceeded(int var1) throws RemoteException;

    public void onAuthenticationFailed() throws RemoteException;

    public void onError(int var1, int var2, int var3) throws RemoteException;

    public void onAcquired(int var1, String var2) throws RemoteException;

    public void onDialogDismissed(int var1) throws RemoteException;

    public void onSystemEvent(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBiometricServiceReceiver {
        static final int TRANSACTION_onAuthenticationSucceeded = 1;
        static final int TRANSACTION_onAuthenticationFailed = 2;
        static final int TRANSACTION_onError = 3;
        static final int TRANSACTION_onAcquired = 4;
        static final int TRANSACTION_onDialogDismissed = 5;
        static final int TRANSACTION_onSystemEvent = 6;

        public Stub() {
            this.attachInterface(this, IBiometricServiceReceiver.DESCRIPTOR);
        }

        public static IBiometricServiceReceiver asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IBiometricServiceReceiver.DESCRIPTOR);
            if (iin != null && iin instanceof IBiometricServiceReceiver) {
                return (IBiometricServiceReceiver)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onAuthenticationSucceeded";
                }
                case 2: {
                    return "onAuthenticationFailed";
                }
                case 3: {
                    return "onError";
                }
                case 4: {
                    return "onAcquired";
                }
                case 5: {
                    return "onDialogDismissed";
                }
                case 6: {
                    return "onSystemEvent";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IBiometricServiceReceiver.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onAuthenticationSucceeded(_arg0);
                    break;
                }
                case 2: {
                    this.onAuthenticationFailed();
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onError(_arg0, _arg1, _arg2);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.onAcquired(_arg0, _arg1);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onDialogDismissed(_arg0);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSystemEvent(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 5;
        }

        private static class Proxy
        implements IBiometricServiceReceiver {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IBiometricServiceReceiver.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAuthenticationSucceeded(int authenticationType) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBiometricServiceReceiver.DESCRIPTOR);
                    _data.writeInt(authenticationType);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onAuthenticationFailed() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBiometricServiceReceiver.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(int modality, int error, int vendorCode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBiometricServiceReceiver.DESCRIPTOR);
                    _data.writeInt(modality);
                    _data.writeInt(error);
                    _data.writeInt(vendorCode);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAcquired(int acquiredInfo, String message) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBiometricServiceReceiver.DESCRIPTOR);
                    _data.writeInt(acquiredInfo);
                    _data.writeString(message);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDialogDismissed(int reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBiometricServiceReceiver.DESCRIPTOR);
                    _data.writeInt(reason);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSystemEvent(int event) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBiometricServiceReceiver.DESCRIPTOR);
                    _data.writeInt(event);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IBiometricServiceReceiver {
        @Override
        public void onAuthenticationSucceeded(int authenticationType) throws RemoteException {
        }

        @Override
        public void onAuthenticationFailed() throws RemoteException {
        }

        @Override
        public void onError(int modality, int error, int vendorCode) throws RemoteException {
        }

        @Override
        public void onAcquired(int acquiredInfo, String message) throws RemoteException {
        }

        @Override
        public void onDialogDismissed(int reason) throws RemoteException {
        }

        @Override
        public void onSystemEvent(int event) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

