/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.text;

import android.graphics.Paint;
import android.graphics.text.PositionedGlyphs;
import android.text.TextUtils;
import com.android.internal.util.Preconditions;

public class TextRunShaper {
    private TextRunShaper() {
    }

    public static PositionedGlyphs shapeTextRun(char[] text, int start, int count, int contextStart, int contextCount, float xOffset, float yOffset, boolean isRtl, Paint paint) {
        Preconditions.checkNotNull(text);
        Preconditions.checkNotNull(paint);
        return new PositionedGlyphs(TextRunShaper.nativeShapeTextRun(text, start, count, contextStart, contextCount, isRtl, paint.getNativeInstance()), xOffset, yOffset);
    }

    public static PositionedGlyphs shapeTextRun(CharSequence text, int start, int count, int contextStart, int contextCount, float xOffset, float yOffset, boolean isRtl, Paint paint) {
        Preconditions.checkNotNull(text);
        Preconditions.checkNotNull(paint);
        if (text instanceof String) {
            return new PositionedGlyphs(TextRunShaper.nativeShapeTextRun((String)text, start, count, contextStart, contextCount, isRtl, paint.getNativeInstance()), xOffset, yOffset);
        }
        char[] buf = new char[contextCount];
        TextUtils.getChars(text, contextStart, contextStart + contextCount, buf, 0);
        return new PositionedGlyphs(TextRunShaper.nativeShapeTextRun(buf, start - contextStart, count, 0, contextCount, isRtl, paint.getNativeInstance()), xOffset, yOffset);
    }

    private static native long nativeShapeTextRun(char[] var0, int var1, int var2, int var3, int var4, boolean var5, long var6);

    private static native long nativeShapeTextRun(String var0, int var1, int var2, int var3, int var4, boolean var5, long var6);
}

