/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.fonts;

import android.graphics.fonts.Font;
import android.util.SparseIntArray;
import com.android.internal.util.Preconditions;
import dalvik.annotation.optimization.CriticalNative;
import dalvik.annotation.optimization.FastNative;
import java.util.ArrayList;
import libcore.util.NativeAllocationRegistry;

public final class FontFamily {
    private static final String TAG = "FontFamily";
    private final long mNativePtr;

    public FontFamily(long ptr) {
        this.mNativePtr = ptr;
    }

    public String getLangTags() {
        return FontFamily.nGetLangTags(this.mNativePtr);
    }

    public int getVariant() {
        return FontFamily.nGetVariant(this.mNativePtr);
    }

    public Font getFont(int index) {
        if (index < 0 || this.getSize() <= index) {
            throw new IndexOutOfBoundsException();
        }
        return new Font(FontFamily.nGetFont(this.mNativePtr, index));
    }

    public int getSize() {
        return FontFamily.nGetFontSize(this.mNativePtr);
    }

    public long getNativePtr() {
        return this.mNativePtr;
    }

    @CriticalNative
    private static native int nGetFontSize(long var0);

    @CriticalNative
    private static native long nGetFont(long var0, int var2);

    @FastNative
    private static native String nGetLangTags(long var0);

    @CriticalNative
    private static native int nGetVariant(long var0);

    public static final class Builder {
        private static NativeAllocationRegistry sFamilyRegistory;
        private final ArrayList<Font> mFonts = new ArrayList();
        private final SparseIntArray mStyles = new SparseIntArray(4);

        public Builder(Font font) {
            Preconditions.checkNotNull(font, "font can not be null");
            this.mStyles.append(Builder.makeStyleIdentifier(font), 0);
            this.mFonts.add(font);
        }

        public Builder addFont(Font font) {
            Preconditions.checkNotNull(font, "font can not be null");
            int key = Builder.makeStyleIdentifier(font);
            if (this.mStyles.indexOfKey(key) >= 0) {
                throw new IllegalArgumentException(font + " has already been added");
            }
            this.mStyles.append(key, 0);
            this.mFonts.add(font);
            return this;
        }

        public FontFamily build() {
            return this.build("", 0, true);
        }

        public FontFamily build(String langTags, int variant, boolean isCustomFallback) {
            long builderPtr = Builder.nInitBuilder();
            for (int i = 0; i < this.mFonts.size(); ++i) {
                Builder.nAddFont(builderPtr, this.mFonts.get(i).getNativePtr());
            }
            long ptr = Builder.nBuild(builderPtr, langTags, variant, isCustomFallback);
            FontFamily family = new FontFamily(ptr);
            sFamilyRegistory.registerNativeAllocation(family, ptr);
            return family;
        }

        private static int makeStyleIdentifier(Font font) {
            return font.getStyle().getWeight() | font.getStyle().getSlant() << 16;
        }

        private static native long nInitBuilder();

        @CriticalNative
        private static native void nAddFont(long var0, long var2);

        private static native long nBuild(long var0, String var2, int var3, boolean var4);

        @CriticalNative
        private static native long nGetReleaseNativeFamily();

        public static void deferredStaticInitializer() {
            sFamilyRegistory = NativeAllocationRegistry.createMalloced(FontFamily.class.getClassLoader(), Builder.nGetReleaseNativeFamily());
        }
    }
}

