/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import java.io.InputStream;
import java.io.OutputStream;

public class Picture {
    private PictureCanvas mRecordingCanvas;
    @UnsupportedAppUsage(maxTargetSdk=28)
    private long mNativePicture;
    private boolean mRequiresHwAcceleration;
    private static final int WORKING_STREAM_STORAGE = 16384;

    public Picture() {
        this(Picture.nativeConstructor(0L));
    }

    public Picture(Picture src) {
        this(Picture.nativeConstructor(src != null ? src.mNativePicture : 0L));
    }

    public Picture(long nativePicture) {
        if (nativePicture == 0L) {
            throw new IllegalArgumentException();
        }
        this.mNativePicture = nativePicture;
    }

    public void close() {
        if (this.mNativePicture != 0L) {
            Picture.nativeDestructor(this.mNativePicture);
            this.mNativePicture = 0L;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private void verifyValid() {
        if (this.mNativePicture == 0L) {
            throw new IllegalStateException("Picture is destroyed");
        }
    }

    public Canvas beginRecording(int width, int height) {
        this.verifyValid();
        if (this.mRecordingCanvas != null) {
            throw new IllegalStateException("Picture already recording, must call #endRecording()");
        }
        long ni = Picture.nativeBeginRecording(this.mNativePicture, width, height);
        this.mRecordingCanvas = new PictureCanvas(this, ni);
        this.mRequiresHwAcceleration = false;
        return this.mRecordingCanvas;
    }

    public void endRecording() {
        this.verifyValid();
        if (this.mRecordingCanvas != null) {
            this.mRequiresHwAcceleration = this.mRecordingCanvas.mUsesHwFeature;
            this.mRecordingCanvas = null;
            Picture.nativeEndRecording(this.mNativePicture);
        }
    }

    public int getWidth() {
        this.verifyValid();
        return Picture.nativeGetWidth(this.mNativePicture);
    }

    public int getHeight() {
        this.verifyValid();
        return Picture.nativeGetHeight(this.mNativePicture);
    }

    public boolean requiresHardwareAcceleration() {
        this.verifyValid();
        return this.mRequiresHwAcceleration;
    }

    public void draw(Canvas canvas) {
        this.verifyValid();
        if (this.mRecordingCanvas != null) {
            this.endRecording();
        }
        if (this.mRequiresHwAcceleration && !canvas.isHardwareAccelerated() && canvas.onHwFeatureInSwMode()) {
            throw new IllegalArgumentException("Software rendering not supported for Pictures that require hardware acceleration");
        }
        Picture.nativeDraw(canvas.getNativeCanvasWrapper(), this.mNativePicture);
    }

    @Deprecated
    public static Picture createFromStream(InputStream stream) {
        return new Picture(Picture.nativeCreateFromStream(stream, new byte[16384]));
    }

    @Deprecated
    public void writeToStream(OutputStream stream) {
        this.verifyValid();
        if (stream == null) {
            throw new IllegalArgumentException("stream cannot be null");
        }
        if (!Picture.nativeWriteToStream(this.mNativePicture, stream, new byte[16384])) {
            throw new RuntimeException();
        }
    }

    private static native long nativeConstructor(long var0);

    private static native long nativeCreateFromStream(InputStream var0, byte[] var1);

    private static native int nativeGetWidth(long var0);

    private static native int nativeGetHeight(long var0);

    private static native long nativeBeginRecording(long var0, int var2, int var3);

    private static native void nativeEndRecording(long var0);

    private static native void nativeDraw(long var0, long var2);

    private static native boolean nativeWriteToStream(long var0, OutputStream var2, byte[] var3);

    private static native void nativeDestructor(long var0);

    private static class PictureCanvas
    extends Canvas {
        private final Picture mPicture;
        boolean mUsesHwFeature;

        public PictureCanvas(Picture pict, long nativeCanvas) {
            super(nativeCanvas);
            this.mPicture = pict;
            this.mDensity = 0;
        }

        @Override
        public void setBitmap(Bitmap bitmap) {
            throw new RuntimeException("Cannot call setBitmap on a picture canvas");
        }

        @Override
        public void drawPicture(Picture picture) {
            if (this.mPicture == picture) {
                throw new RuntimeException("Cannot draw a picture into its recording canvas");
            }
            super.drawPicture(picture);
        }

        @Override
        protected boolean onHwFeatureInSwMode() {
            this.mUsesHwFeature = true;
            return false;
        }
    }
}

