/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.os.Handler;
import com.android.internal.util.VirtualRefBasePtr;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.lang.ref.WeakReference;

public class HardwareRendererObserver {
    private final long[] mFrameMetrics;
    private final Handler mHandler;
    private final OnFrameMetricsAvailableListener mListener;
    private VirtualRefBasePtr mNativePtr;

    public HardwareRendererObserver(OnFrameMetricsAvailableListener listener, long[] frameMetrics, Handler handler, boolean waitForPresentTime) {
        if (handler == null || handler.getLooper() == null) {
            throw new NullPointerException("handler and its looper cannot be null");
        }
        if (handler.getLooper().getQueue() == null) {
            throw new IllegalStateException("invalid looper, null message queue\n");
        }
        this.mFrameMetrics = frameMetrics;
        this.mHandler = handler;
        this.mListener = listener;
        this.mNativePtr = new VirtualRefBasePtr(HardwareRendererObserver.nCreateObserver(new WeakReference<HardwareRendererObserver>(this), waitForPresentTime));
    }

    long getNativeInstance() {
        return this.mNativePtr.get();
    }

    private void notifyDataAvailable() {
        this.mHandler.post(() -> {
            boolean hasMoreData = true;
            while (hasMoreData) {
                int dropCount = HardwareRendererObserver.nGetNextBuffer(this.mNativePtr.get(), this.mFrameMetrics);
                if (dropCount >= 0) {
                    this.mListener.onFrameMetricsAvailable(dropCount);
                    continue;
                }
                hasMoreData = false;
            }
        });
    }

    static boolean invokeDataAvailable(WeakReference<HardwareRendererObserver> weakObserver) {
        HardwareRendererObserver observer = (HardwareRendererObserver)weakObserver.get();
        if (observer != null) {
            observer.notifyDataAvailable();
            return true;
        }
        return false;
    }

    private static long nCreateObserver(WeakReference<HardwareRendererObserver> weakReference, boolean bl) {
        return OverrideMethod.invokeL("android.graphics.HardwareRendererObserver#nCreateObserver(Ljava/lang/ref/WeakReference;Z)J", true, null);
    }

    private static int nGetNextBuffer(long l, long[] lArray) {
        return OverrideMethod.invokeI("android.graphics.HardwareRendererObserver#nGetNextBuffer(J[J)I", true, null);
    }

    public static interface OnFrameMetricsAvailableListener {
        public void onFrameMetricsAvailable(int var1);
    }
}

