/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.database.DatabaseErrorHandler;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.util.Log;
import android.util.Pair;
import java.io.File;
import java.util.List;

public class DefaultDatabaseErrorHandler
implements DatabaseErrorHandler {
    private static final String TAG = "DefaultDatabaseErrorHandler";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCorruption(SQLiteDatabase dbObj) {
        block12: {
            block11: {
                Log.e(TAG, "Corruption reported by sqlite on database: " + dbObj.getPath());
                SQLiteDatabase.wipeDetected(dbObj.getPath(), "corruption");
                if (!dbObj.isOpen()) {
                    this.deleteDatabaseFile(dbObj.getPath());
                    return;
                }
                List<Pair<String, String>> attachedDbs = null;
                try {
                    try {
                        attachedDbs = dbObj.getAttachedDbs();
                    }
                    catch (SQLiteException sQLiteException) {
                        // empty catch block
                    }
                    try {
                        dbObj.close();
                    }
                    catch (SQLiteException sQLiteException) {
                        // empty catch block
                    }
                    if (attachedDbs == null) break block11;
                }
                catch (Throwable throwable) {
                    if (attachedDbs != null) {
                        for (Pair<String, String> p : attachedDbs) {
                            this.deleteDatabaseFile((String)p.second);
                        }
                    } else {
                        this.deleteDatabaseFile(dbObj.getPath());
                    }
                    throw throwable;
                }
                for (Pair<String, String> p : attachedDbs) {
                    this.deleteDatabaseFile((String)p.second);
                }
                break block12;
            }
            this.deleteDatabaseFile(dbObj.getPath());
        }
    }

    private void deleteDatabaseFile(String fileName) {
        if (fileName.equalsIgnoreCase(":memory:") || fileName.trim().length() == 0) {
            return;
        }
        Log.e(TAG, "deleting the database file: " + fileName);
        try {
            SQLiteDatabase.deleteDatabase(new File(fileName), false);
        }
        catch (Exception e) {
            Log.w(TAG, "delete failed: " + e.getMessage());
        }
    }
}

