/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.om.OverlayableInfo;
import android.content.res.StringBlock;
import android.content.res.XmlBlock;
import android.content.res.XmlResourceParser;
import android.content.res.loader.AssetsProvider;
import android.text.TextUtils;
import com.android.internal.annotations.GuardedBy;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class ApkAssets {
    public static final int PROPERTY_SYSTEM = 1;
    public static final int PROPERTY_DYNAMIC = 2;
    public static final int PROPERTY_LOADER = 4;
    private static final int PROPERTY_OVERLAY = 8;
    public static final int PROPERTY_DISABLE_INCREMENTAL_HARDENING = 16;
    private static final int FORMAT_APK = 0;
    private static final int FORMAT_IDMAP = 1;
    private static final int FORMAT_ARSC = 2;
    private static final int FORMAT_DIR = 3;
    @GuardedBy(value={"this"})
    private long mNativePtr;
    @GuardedBy(value={"this"})
    private final StringBlock mStringBlock;
    private final int mFlags;
    private final AssetsProvider mAssets;

    public static ApkAssets loadFromPath(String path) throws IOException {
        return ApkAssets.loadFromPath(path, 0);
    }

    public static ApkAssets loadFromPath(String path, int flags) throws IOException {
        return new ApkAssets(0, path, flags, null);
    }

    public static ApkAssets loadFromPath(String path, int flags, AssetsProvider assets) throws IOException {
        return new ApkAssets(0, path, flags, assets);
    }

    public static ApkAssets loadFromFd(FileDescriptor fd, String friendlyName, int flags, AssetsProvider assets) throws IOException {
        return new ApkAssets(0, fd, friendlyName, flags, assets);
    }

    public static ApkAssets loadFromFd(FileDescriptor fd, String friendlyName, long offset, long length, int flags, AssetsProvider assets) throws IOException {
        return new ApkAssets(0, fd, friendlyName, offset, length, flags, assets);
    }

    public static ApkAssets loadOverlayFromPath(String idmapPath, int flags) throws IOException {
        return new ApkAssets(1, idmapPath, flags, null);
    }

    public static ApkAssets loadTableFromFd(FileDescriptor fd, String friendlyName, int flags, AssetsProvider assets) throws IOException {
        return new ApkAssets(2, fd, friendlyName, flags, assets);
    }

    public static ApkAssets loadTableFromFd(FileDescriptor fd, String friendlyName, long offset, long length, int flags, AssetsProvider assets) throws IOException {
        return new ApkAssets(2, fd, friendlyName, offset, length, flags, assets);
    }

    public static ApkAssets loadFromDir(String path, int flags, AssetsProvider assets) throws IOException {
        return new ApkAssets(3, path, flags, assets);
    }

    public static ApkAssets loadEmptyForLoader(int flags, AssetsProvider assets) {
        return new ApkAssets(flags, assets);
    }

    private ApkAssets(int format, String path, int flags, AssetsProvider assets) throws IOException {
        Objects.requireNonNull(path, "path");
        this.mFlags = flags;
        this.mNativePtr = ApkAssets.nativeLoad(format, path, flags, assets);
        this.mStringBlock = new StringBlock(ApkAssets.nativeGetStringBlock(this.mNativePtr), true);
        this.mAssets = assets;
    }

    private ApkAssets(int format, FileDescriptor fd, String friendlyName, int flags, AssetsProvider assets) throws IOException {
        Objects.requireNonNull(fd, "fd");
        Objects.requireNonNull(friendlyName, "friendlyName");
        this.mFlags = flags;
        this.mNativePtr = ApkAssets.nativeLoadFd(format, fd, friendlyName, flags, assets);
        this.mStringBlock = new StringBlock(ApkAssets.nativeGetStringBlock(this.mNativePtr), true);
        this.mAssets = assets;
    }

    private ApkAssets(int format, FileDescriptor fd, String friendlyName, long offset, long length, int flags, AssetsProvider assets) throws IOException {
        Objects.requireNonNull(fd, "fd");
        Objects.requireNonNull(friendlyName, "friendlyName");
        this.mFlags = flags;
        this.mNativePtr = ApkAssets.nativeLoadFdOffsets(format, fd, friendlyName, offset, length, flags, assets);
        this.mStringBlock = new StringBlock(ApkAssets.nativeGetStringBlock(this.mNativePtr), true);
        this.mAssets = assets;
    }

    private ApkAssets(int flags, AssetsProvider assets) {
        this.mFlags = flags;
        this.mNativePtr = ApkAssets.nativeLoadEmpty(flags, assets);
        this.mStringBlock = null;
        this.mAssets = assets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public String getAssetPath() {
        ApkAssets apkAssets = this;
        synchronized (apkAssets) {
            return TextUtils.emptyIfNull(ApkAssets.nativeGetAssetPath(this.mNativePtr));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDebugName() {
        ApkAssets apkAssets = this;
        synchronized (apkAssets) {
            return ApkAssets.nativeGetDebugName(this.mNativePtr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CharSequence getStringFromPool(int idx) {
        if (this.mStringBlock == null) {
            return null;
        }
        ApkAssets apkAssets = this;
        synchronized (apkAssets) {
            return this.mStringBlock.getSequence(idx);
        }
    }

    public boolean isForLoader() {
        return (this.mFlags & 4) != 0;
    }

    public AssetsProvider getAssetsProvider() {
        return this.mAssets;
    }

    public XmlResourceParser openXml(String fileName) throws IOException {
        Objects.requireNonNull(fileName, "fileName");
        ApkAssets apkAssets = this;
        synchronized (apkAssets) {
            XmlResourceParser xmlResourceParser;
            long nativeXmlPtr = ApkAssets.nativeOpenXml(this.mNativePtr, fileName);
            try (XmlBlock block = new XmlBlock(null, nativeXmlPtr);){
                XmlResourceParser parser = block.newParser();
                if (parser == null) {
                    throw new AssertionError((Object)"block.newParser() returned a null parser");
                }
                xmlResourceParser = parser;
            }
            return xmlResourceParser;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OverlayableInfo getOverlayableInfo(String overlayableName) throws IOException {
        ApkAssets apkAssets = this;
        synchronized (apkAssets) {
            return ApkAssets.nativeGetOverlayableInfo(this.mNativePtr, overlayableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean definesOverlayable() throws IOException {
        ApkAssets apkAssets = this;
        synchronized (apkAssets) {
            return ApkAssets.nativeDefinesOverlayable(this.mNativePtr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUpToDate() {
        ApkAssets apkAssets = this;
        synchronized (apkAssets) {
            return ApkAssets.nativeIsUpToDate(this.mNativePtr);
        }
    }

    public String toString() {
        return "ApkAssets{path=" + this.getDebugName() + "}";
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ApkAssets apkAssets = this;
        synchronized (apkAssets) {
            if (this.mNativePtr != 0L) {
                if (this.mStringBlock != null) {
                    this.mStringBlock.close();
                }
                ApkAssets.nativeDestroy(this.mNativePtr);
                this.mNativePtr = 0L;
            }
        }
    }

    void dump(PrintWriter pw, String prefix) {
        pw.println(prefix + "class=" + this.getClass());
        pw.println(prefix + "debugName=" + this.getDebugName());
        pw.println(prefix + "assetPath=" + this.getAssetPath());
    }

    private static long nativeLoad(int n, String string2, int n2, AssetsProvider assetsProvider) throws IOException {
        return OverrideMethod.invokeL("android.content.res.ApkAssets#nativeLoad(ILjava/lang/String;ILandroid/content/res/loader/AssetsProvider;)J", true, null);
    }

    private static long nativeLoadEmpty(int n, AssetsProvider assetsProvider) {
        return OverrideMethod.invokeL("android.content.res.ApkAssets#nativeLoadEmpty(ILandroid/content/res/loader/AssetsProvider;)J", true, null);
    }

    private static long nativeLoadFd(int n, FileDescriptor fileDescriptor, String string2, int n2, AssetsProvider assetsProvider) throws IOException {
        return OverrideMethod.invokeL("android.content.res.ApkAssets#nativeLoadFd(ILjava/io/FileDescriptor;Ljava/lang/String;ILandroid/content/res/loader/AssetsProvider;)J", true, null);
    }

    private static long nativeLoadFdOffsets(int n, FileDescriptor fileDescriptor, String string2, long l, long l2, int n2, AssetsProvider assetsProvider) throws IOException {
        return OverrideMethod.invokeL("android.content.res.ApkAssets#nativeLoadFdOffsets(ILjava/io/FileDescriptor;Ljava/lang/String;JJILandroid/content/res/loader/AssetsProvider;)J", true, null);
    }

    private static void nativeDestroy(long l) {
        OverrideMethod.invokeV("android.content.res.ApkAssets#nativeDestroy(J)V", true, null);
    }

    private static String nativeGetAssetPath(long l) {
        return (String)OverrideMethod.invokeA("android.content.res.ApkAssets#nativeGetAssetPath(J)Ljava/lang/String;", true, null);
    }

    private static String nativeGetDebugName(long l) {
        return (String)OverrideMethod.invokeA("android.content.res.ApkAssets#nativeGetDebugName(J)Ljava/lang/String;", true, null);
    }

    private static long nativeGetStringBlock(long l) {
        return OverrideMethod.invokeL("android.content.res.ApkAssets#nativeGetStringBlock(J)J", true, null);
    }

    private static boolean nativeIsUpToDate(long l) {
        return OverrideMethod.invokeI("android.content.res.ApkAssets#nativeIsUpToDate(J)Z", true, null) != 0;
    }

    private static long nativeOpenXml(long l, String string2) throws IOException {
        return OverrideMethod.invokeL("android.content.res.ApkAssets#nativeOpenXml(JLjava/lang/String;)J", true, null);
    }

    private static OverlayableInfo nativeGetOverlayableInfo(long l, String string2) throws IOException {
        return (OverlayableInfo)OverrideMethod.invokeA("android.content.res.ApkAssets#nativeGetOverlayableInfo(JLjava/lang/String;)Landroid/content/om/OverlayableInfo;", true, null);
    }

    private static boolean nativeDefinesOverlayable(long l) throws IOException {
        return OverrideMethod.invokeI("android.content.res.ApkAssets#nativeDefinesOverlayable(J)Z", true, null) != 0;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FormatType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PropertyFlags {
    }
}

