/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class VersionedPackage
implements Parcelable {
    private final String mPackageName;
    private final long mVersionCode;
    public static final Parcelable.Creator<VersionedPackage> CREATOR = new Parcelable.Creator<VersionedPackage>(){

        @Override
        public VersionedPackage createFromParcel(Parcel source) {
            return new VersionedPackage(source);
        }

        public VersionedPackage[] newArray(int size) {
            return new VersionedPackage[size];
        }
    };

    public VersionedPackage(String packageName, int versionCode) {
        this.mPackageName = packageName;
        this.mVersionCode = versionCode;
    }

    public VersionedPackage(String packageName, long versionCode) {
        this.mPackageName = packageName;
        this.mVersionCode = versionCode;
    }

    private VersionedPackage(Parcel parcel) {
        this.mPackageName = parcel.readString8();
        this.mVersionCode = parcel.readLong();
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    @Deprecated
    public int getVersionCode() {
        return (int)(this.mVersionCode & Integer.MAX_VALUE);
    }

    public long getLongVersionCode() {
        return this.mVersionCode;
    }

    public String toString() {
        return "VersionedPackage[" + this.mPackageName + "/" + this.mVersionCode + "]";
    }

    public boolean equals(Object o) {
        return o instanceof VersionedPackage && ((VersionedPackage)o).mPackageName.equals(this.mPackageName) && ((VersionedPackage)o).mVersionCode == this.mVersionCode;
    }

    public int hashCode() {
        return 31 * this.mPackageName.hashCode() + Long.hashCode(this.mVersionCode);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeString8(this.mPackageName);
        parcel.writeLong(this.mVersionCode);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VersionCode {
    }
}

