/*
 * Decompiled with CFR 0.152.
 */
package android.content.integrity;

import android.content.integrity.AppInstallMetadata;
import android.content.integrity.IntegrityFormula;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Map;

public class InstallerAllowedByManifestFormula
extends IntegrityFormula
implements Parcelable {
    public static final String INSTALLER_CERTIFICATE_NOT_EVALUATED = "";
    public static final Parcelable.Creator<InstallerAllowedByManifestFormula> CREATOR = new Parcelable.Creator<InstallerAllowedByManifestFormula>(){

        @Override
        public InstallerAllowedByManifestFormula createFromParcel(Parcel in) {
            return new InstallerAllowedByManifestFormula(in);
        }

        public InstallerAllowedByManifestFormula[] newArray(int size) {
            return new InstallerAllowedByManifestFormula[size];
        }
    };

    public InstallerAllowedByManifestFormula() {
    }

    private InstallerAllowedByManifestFormula(Parcel in) {
    }

    @Override
    public int getTag() {
        return 4;
    }

    @Override
    public boolean matches(AppInstallMetadata appInstallMetadata) {
        Map<String, String> allowedInstallersAndCertificates = appInstallMetadata.getAllowedInstallersAndCertificates();
        return allowedInstallersAndCertificates.isEmpty() || InstallerAllowedByManifestFormula.installerInAllowedInstallersFromManifest(appInstallMetadata, allowedInstallersAndCertificates);
    }

    @Override
    public boolean isAppCertificateFormula() {
        return false;
    }

    @Override
    public boolean isAppCertificateLineageFormula() {
        return false;
    }

    @Override
    public boolean isInstallerFormula() {
        return true;
    }

    private static boolean installerInAllowedInstallersFromManifest(AppInstallMetadata appInstallMetadata, Map<String, String> allowedInstallersAndCertificates) {
        String installerPackage = appInstallMetadata.getInstallerName();
        if (!allowedInstallersAndCertificates.containsKey(installerPackage)) {
            return false;
        }
        if (!allowedInstallersAndCertificates.get(installerPackage).equals(INSTALLER_CERTIFICATE_NOT_EVALUATED)) {
            return appInstallMetadata.getInstallerCertificates().contains(allowedInstallersAndCertificates.get(appInstallMetadata.getInstallerName()));
        }
        return true;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
    }
}

