/*
 * Decompiled with CFR 0.152.
 */
package android.content.integrity;

import android.content.integrity.AppInstallMetadata;
import android.content.integrity.IntegrityFormula;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@VisibleForTesting
public class CompoundFormula
extends IntegrityFormula
implements Parcelable {
    public static final int AND = 0;
    public static final int OR = 1;
    public static final int NOT = 2;
    private final int mConnector;
    private final List<IntegrityFormula> mFormulas;
    public static final Parcelable.Creator<CompoundFormula> CREATOR = new Parcelable.Creator<CompoundFormula>(){

        @Override
        public CompoundFormula createFromParcel(Parcel in) {
            return new CompoundFormula(in);
        }

        public CompoundFormula[] newArray(int size) {
            return new CompoundFormula[size];
        }
    };

    public CompoundFormula(int connector, List<IntegrityFormula> formulas) {
        Preconditions.checkArgument(CompoundFormula.isValidConnector(connector), "Unknown connector: %d", connector);
        CompoundFormula.validateFormulas(connector, formulas);
        this.mConnector = connector;
        this.mFormulas = Collections.unmodifiableList(formulas);
    }

    CompoundFormula(Parcel in) {
        this.mConnector = in.readInt();
        int length = in.readInt();
        Preconditions.checkArgument(length >= 0, "Must have non-negative length. Got %d", length);
        this.mFormulas = new ArrayList<IntegrityFormula>(length);
        for (int i = 0; i < length; ++i) {
            this.mFormulas.add(IntegrityFormula.readFromParcel(in));
        }
        CompoundFormula.validateFormulas(this.mConnector, this.mFormulas);
    }

    public int getConnector() {
        return this.mConnector;
    }

    public List<IntegrityFormula> getFormulas() {
        return this.mFormulas;
    }

    @Override
    public int getTag() {
        return 0;
    }

    @Override
    public boolean matches(AppInstallMetadata appInstallMetadata) {
        switch (this.getConnector()) {
            case 2: {
                return !this.getFormulas().get(0).matches(appInstallMetadata);
            }
            case 0: {
                return this.getFormulas().stream().allMatch(formula -> formula.matches(appInstallMetadata));
            }
            case 1: {
                return this.getFormulas().stream().anyMatch(formula -> formula.matches(appInstallMetadata));
            }
        }
        throw new IllegalArgumentException("Unknown connector " + this.getConnector());
    }

    @Override
    public boolean isAppCertificateFormula() {
        return this.getFormulas().stream().anyMatch(formula -> formula.isAppCertificateFormula());
    }

    @Override
    public boolean isAppCertificateLineageFormula() {
        return this.getFormulas().stream().anyMatch(formula -> formula.isAppCertificateLineageFormula());
    }

    @Override
    public boolean isInstallerFormula() {
        return this.getFormulas().stream().anyMatch(formula -> formula.isInstallerFormula());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.mFormulas.size() == 1) {
            sb.append(String.format("%s ", CompoundFormula.connectorToString(this.mConnector)));
            sb.append(this.mFormulas.get(0).toString());
        } else {
            for (int i = 0; i < this.mFormulas.size(); ++i) {
                if (i > 0) {
                    sb.append(String.format(" %s ", CompoundFormula.connectorToString(this.mConnector)));
                }
                sb.append(this.mFormulas.get(i).toString());
            }
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompoundFormula that = (CompoundFormula)o;
        return this.mConnector == that.mConnector && this.mFormulas.equals(that.mFormulas);
    }

    public int hashCode() {
        return Objects.hash(this.mConnector, this.mFormulas);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mConnector);
        dest.writeInt(this.mFormulas.size());
        for (IntegrityFormula formula : this.mFormulas) {
            IntegrityFormula.writeToParcel(formula, dest, flags);
        }
    }

    private static void validateFormulas(int connector, List<IntegrityFormula> formulas) {
        switch (connector) {
            case 0: 
            case 1: {
                Preconditions.checkArgument(formulas.size() >= 2, "Connector %s must have at least 2 formulas", CompoundFormula.connectorToString(connector));
                break;
            }
            case 2: {
                Preconditions.checkArgument(formulas.size() == 1, "Connector %s must have 1 formula only", CompoundFormula.connectorToString(connector));
            }
        }
    }

    private static String connectorToString(int connector) {
        switch (connector) {
            case 0: {
                return "AND";
            }
            case 1: {
                return "OR";
            }
            case 2: {
                return "NOT";
            }
        }
        throw new IllegalArgumentException("Unknown connector " + connector);
    }

    private static boolean isValidConnector(int connector) {
        return connector == 0 || connector == 1 || connector == 2;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Connector {
    }
}

