/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.SyncAdapterType;
import android.content.pm.RegisteredServicesCache;
import android.content.pm.XmlSerializerAndParser;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.util.TypedXmlPullParser;
import android.util.TypedXmlSerializer;
import com.android.internal.R;
import com.android.internal.annotations.GuardedBy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.xmlpull.v1.XmlPullParserException;

public class SyncAdaptersCache
extends RegisteredServicesCache<SyncAdapterType> {
    private static final String TAG = "Account";
    private static final String SERVICE_INTERFACE = "android.content.SyncAdapter";
    private static final String SERVICE_META_DATA = "android.content.SyncAdapter";
    private static final String ATTRIBUTES_NAME = "sync-adapter";
    private static final MySerializer sSerializer = new MySerializer();
    @GuardedBy(value={"mServicesLock"})
    private SparseArray<ArrayMap<String, String[]>> mAuthorityToSyncAdapters = new SparseArray();

    @UnsupportedAppUsage
    public SyncAdaptersCache(Context context) {
        super(context, "android.content.SyncAdapter", "android.content.SyncAdapter", ATTRIBUTES_NAME, sSerializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SyncAdapterType parseServiceAttributes(Resources res, String packageName, AttributeSet attrs) {
        TypedArray sa = res.obtainAttributes(attrs, R.styleable.SyncAdapter);
        try {
            String authority = sa.getString(2);
            String accountType = sa.getString(1);
            if (TextUtils.isEmpty(authority) || TextUtils.isEmpty(accountType)) {
                SyncAdapterType syncAdapterType = null;
                return syncAdapterType;
            }
            boolean userVisible = sa.getBoolean(3, true);
            boolean supportsUploading = sa.getBoolean(4, true);
            boolean isAlwaysSyncable = sa.getBoolean(6, false);
            boolean allowParallelSyncs = sa.getBoolean(5, false);
            String settingsActivity = sa.getString(0);
            SyncAdapterType syncAdapterType = new SyncAdapterType(authority, accountType, userVisible, supportsUploading, isAlwaysSyncable, allowParallelSyncs, settingsActivity, packageName);
            return syncAdapterType;
        }
        finally {
            sa.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onServicesChangedLocked(int userId) {
        Object object = this.mServicesLock;
        synchronized (object) {
            ArrayMap<String, String[]> adapterMap = this.mAuthorityToSyncAdapters.get(userId);
            if (adapterMap != null) {
                adapterMap.clear();
            }
        }
        super.onServicesChangedLocked(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSyncAdapterPackagesForAuthority(String authority, int userId) {
        Object object = this.mServicesLock;
        synchronized (object) {
            ArrayMap<String, Object> adapterMap = this.mAuthorityToSyncAdapters.get(userId);
            if (adapterMap == null) {
                adapterMap = new ArrayMap();
                this.mAuthorityToSyncAdapters.put(userId, adapterMap);
            }
            if (adapterMap.containsKey(authority)) {
                return (String[])adapterMap.get(authority);
            }
            Collection serviceInfos = this.getAllServices(userId);
            ArrayList<String> packages = new ArrayList<String>();
            for (RegisteredServicesCache.ServiceInfo serviceInfo : serviceInfos) {
                if (!authority.equals(((SyncAdapterType)serviceInfo.type).authority) || serviceInfo.componentName == null) continue;
                packages.add(serviceInfo.componentName.getPackageName());
            }
            String[] syncAdapterPackages = new String[packages.size()];
            packages.toArray(syncAdapterPackages);
            adapterMap.put(authority, syncAdapterPackages);
            return syncAdapterPackages;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onUserRemoved(int userId) {
        Object object = this.mServicesLock;
        synchronized (object) {
            this.mAuthorityToSyncAdapters.remove(userId);
        }
        super.onUserRemoved(userId);
    }

    static class MySerializer
    implements XmlSerializerAndParser<SyncAdapterType> {
        MySerializer() {
        }

        @Override
        public void writeAsXml(SyncAdapterType item, TypedXmlSerializer out) throws IOException {
            out.attribute(null, "authority", item.authority);
            out.attribute(null, "accountType", item.accountType);
        }

        @Override
        public SyncAdapterType createFromXml(TypedXmlPullParser parser) throws IOException, XmlPullParserException {
            String authority = parser.getAttributeValue(null, "authority");
            String accountType = parser.getAttributeValue(null, "accountType");
            return SyncAdapterType.newKey(authority, accountType);
        }
    }
}

