/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresPermission;
import android.bluetooth.BluetoothDevice;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.ParcelUuid;
import android.os.RemoteException;

public interface IBluetoothSocketManager
extends IInterface {
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public ParcelFileDescriptor connectSocket(BluetoothDevice var1, int var2, ParcelUuid var3, int var4, int var5) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public ParcelFileDescriptor createSocketChannel(int var1, String var2, ParcelUuid var3, int var4, int var5) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void requestMaximumTxDataLength(BluetoothDevice var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBluetoothSocketManager {
        public static final String DESCRIPTOR = "android.bluetooth.IBluetoothSocketManager";
        static final int TRANSACTION_connectSocket = 1;
        static final int TRANSACTION_createSocketChannel = 2;
        static final int TRANSACTION_requestMaximumTxDataLength = 3;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IBluetoothSocketManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IBluetoothSocketManager) {
                return (IBluetoothSocketManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    ParcelUuid _arg2 = data.readTypedObject(ParcelUuid.CREATOR);
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    ParcelFileDescriptor _result = this.connectSocket(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    ParcelUuid _arg2 = data.readTypedObject(ParcelUuid.CREATOR);
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    ParcelFileDescriptor _result = this.createSocketChannel(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 3: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    data.enforceNoDataAvail();
                    this.requestMaximumTxDataLength(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements IBluetoothSocketManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParcelFileDescriptor connectSocket(BluetoothDevice device, int type, ParcelUuid uuid, int port, int flag) throws RemoteException {
                ParcelFileDescriptor _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(type);
                    _data.writeTypedObject(uuid, 0);
                    _data.writeInt(port);
                    _data.writeInt(flag);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParcelFileDescriptor.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParcelFileDescriptor createSocketChannel(int type, String serviceName, ParcelUuid uuid, int port, int flag) throws RemoteException {
                ParcelFileDescriptor _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(type);
                    _data.writeString(serviceName);
                    _data.writeTypedObject(uuid, 0);
                    _data.writeInt(port);
                    _data.writeInt(flag);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParcelFileDescriptor.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestMaximumTxDataLength(BluetoothDevice device) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IBluetoothSocketManager {
        @Override
        public ParcelFileDescriptor connectSocket(BluetoothDevice device, int type, ParcelUuid uuid, int port, int flag) throws RemoteException {
            return null;
        }

        @Override
        public ParcelFileDescriptor createSocketChannel(int type, String serviceName, ParcelUuid uuid, int port, int flag) throws RemoteException {
            return null;
        }

        @Override
        public void requestMaximumTxDataLength(BluetoothDevice device) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

