/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresPermission;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadsetClientCall;
import android.content.AttributionSource;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.android.bluetooth.x.com.android.modules.utils.SynchronousResultReceiver;

public interface IBluetoothHeadsetClient
extends IInterface {
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void connect(BluetoothDevice var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void disconnect(BluetoothDevice var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void getConnectedDevices(AttributionSource var1, SynchronousResultReceiver var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void getDevicesMatchingConnectionStates(int[] var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void getConnectionState(BluetoothDevice var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void setConnectionPolicy(BluetoothDevice var1, int var2, AttributionSource var3, SynchronousResultReceiver var4) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void getConnectionPolicy(BluetoothDevice var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void startVoiceRecognition(BluetoothDevice var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void stopVoiceRecognition(BluetoothDevice var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void getCurrentCalls(BluetoothDevice var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void getCurrentAgEvents(BluetoothDevice var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void acceptCall(BluetoothDevice var1, int var2, AttributionSource var3, SynchronousResultReceiver var4) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void holdCall(BluetoothDevice var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void rejectCall(BluetoothDevice var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void terminateCall(BluetoothDevice var1, BluetoothHeadsetClientCall var2, AttributionSource var3, SynchronousResultReceiver var4) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void enterPrivateMode(BluetoothDevice var1, int var2, AttributionSource var3, SynchronousResultReceiver var4) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void explicitCallTransfer(BluetoothDevice var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void dial(BluetoothDevice var1, String var2, AttributionSource var3, SynchronousResultReceiver var4) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void sendDTMF(BluetoothDevice var1, byte var2, AttributionSource var3, SynchronousResultReceiver var4) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void getLastVoiceTagNumber(BluetoothDevice var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void getAudioState(BluetoothDevice var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void connectAudio(BluetoothDevice var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void disconnectAudio(BluetoothDevice var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void setAudioRouteAllowed(BluetoothDevice var1, boolean var2, AttributionSource var3, SynchronousResultReceiver var4) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void getAudioRouteAllowed(BluetoothDevice var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void sendVendorAtCommand(BluetoothDevice var1, int var2, String var3, AttributionSource var4, SynchronousResultReceiver var5) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void getCurrentAgFeatures(BluetoothDevice var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBluetoothHeadsetClient {
        public static final String DESCRIPTOR = "android.bluetooth.IBluetoothHeadsetClient";
        static final int TRANSACTION_connect = 1;
        static final int TRANSACTION_disconnect = 2;
        static final int TRANSACTION_getConnectedDevices = 3;
        static final int TRANSACTION_getDevicesMatchingConnectionStates = 4;
        static final int TRANSACTION_getConnectionState = 5;
        static final int TRANSACTION_setConnectionPolicy = 6;
        static final int TRANSACTION_getConnectionPolicy = 7;
        static final int TRANSACTION_startVoiceRecognition = 8;
        static final int TRANSACTION_stopVoiceRecognition = 9;
        static final int TRANSACTION_getCurrentCalls = 10;
        static final int TRANSACTION_getCurrentAgEvents = 11;
        static final int TRANSACTION_acceptCall = 12;
        static final int TRANSACTION_holdCall = 13;
        static final int TRANSACTION_rejectCall = 14;
        static final int TRANSACTION_terminateCall = 15;
        static final int TRANSACTION_enterPrivateMode = 16;
        static final int TRANSACTION_explicitCallTransfer = 17;
        static final int TRANSACTION_dial = 18;
        static final int TRANSACTION_sendDTMF = 19;
        static final int TRANSACTION_getLastVoiceTagNumber = 20;
        static final int TRANSACTION_getAudioState = 21;
        static final int TRANSACTION_connectAudio = 22;
        static final int TRANSACTION_disconnectAudio = 23;
        static final int TRANSACTION_setAudioRouteAllowed = 24;
        static final int TRANSACTION_getAudioRouteAllowed = 25;
        static final int TRANSACTION_sendVendorAtCommand = 26;
        static final int TRANSACTION_getCurrentAgFeatures = 27;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IBluetoothHeadsetClient asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IBluetoothHeadsetClient) {
                return (IBluetoothHeadsetClient)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.connect(_arg0, _arg1, _arg2);
                    break;
                }
                case 2: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.disconnect(_arg0, _arg1, _arg2);
                    break;
                }
                case 3: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg1 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.getConnectedDevices(_arg0, _arg1);
                    break;
                }
                case 4: {
                    int[] _arg0 = data.createIntArray();
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.getDevicesMatchingConnectionStates(_arg0, _arg1, _arg2);
                    break;
                }
                case 5: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.getConnectionState(_arg0, _arg1, _arg2);
                    break;
                }
                case 6: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg3 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.setConnectionPolicy(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 7: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.getConnectionPolicy(_arg0, _arg1, _arg2);
                    break;
                }
                case 8: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.startVoiceRecognition(_arg0, _arg1, _arg2);
                    break;
                }
                case 9: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.stopVoiceRecognition(_arg0, _arg1, _arg2);
                    break;
                }
                case 10: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.getCurrentCalls(_arg0, _arg1, _arg2);
                    break;
                }
                case 11: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.getCurrentAgEvents(_arg0, _arg1, _arg2);
                    break;
                }
                case 12: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg3 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.acceptCall(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 13: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.holdCall(_arg0, _arg1, _arg2);
                    break;
                }
                case 14: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.rejectCall(_arg0, _arg1, _arg2);
                    break;
                }
                case 15: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    BluetoothHeadsetClientCall _arg1 = data.readTypedObject(BluetoothHeadsetClientCall.CREATOR);
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg3 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.terminateCall(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 16: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg3 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.enterPrivateMode(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 17: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.explicitCallTransfer(_arg0, _arg1, _arg2);
                    break;
                }
                case 18: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    String _arg1 = data.readString();
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg3 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.dial(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 19: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    byte _arg1 = data.readByte();
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg3 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.sendDTMF(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 20: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.getLastVoiceTagNumber(_arg0, _arg1, _arg2);
                    break;
                }
                case 21: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.getAudioState(_arg0, _arg1, _arg2);
                    break;
                }
                case 22: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.connectAudio(_arg0, _arg1, _arg2);
                    break;
                }
                case 23: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.disconnectAudio(_arg0, _arg1, _arg2);
                    break;
                }
                case 24: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    boolean _arg1 = data.readBoolean();
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg3 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.setAudioRouteAllowed(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 25: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.getAudioRouteAllowed(_arg0, _arg1, _arg2);
                    break;
                }
                case 26: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    AttributionSource _arg3 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg4 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.sendVendorAtCommand(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 27: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.getCurrentAgFeatures(_arg0, _arg1, _arg2);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements IBluetoothHeadsetClient {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void connect(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disconnect(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getConnectedDevices(AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getDevicesMatchingConnectionStates(int[] states, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(states);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getConnectionState(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setConnectionPolicy(BluetoothDevice device, int connectionPolicy, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(connectionPolicy);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getConnectionPolicy(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startVoiceRecognition(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopVoiceRecognition(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getCurrentCalls(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getCurrentAgEvents(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void acceptCall(BluetoothDevice device, int flag, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(flag);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void holdCall(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(13, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void rejectCall(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(14, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void terminateCall(BluetoothDevice device, BluetoothHeadsetClientCall call, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(call, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(15, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enterPrivateMode(BluetoothDevice device, int index, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(index);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(16, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void explicitCallTransfer(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(17, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dial(BluetoothDevice device, String number, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeString(number);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(18, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendDTMF(BluetoothDevice device, byte code, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeByte(code);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(19, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getLastVoiceTagNumber(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(20, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getAudioState(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(21, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void connectAudio(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(22, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disconnectAudio(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(23, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAudioRouteAllowed(BluetoothDevice device, boolean allowed, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeBoolean(allowed);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(24, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getAudioRouteAllowed(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(25, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendVendorAtCommand(BluetoothDevice device, int vendorId, String atCommand, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(vendorId);
                    _data.writeString(atCommand);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(26, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getCurrentAgFeatures(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(27, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IBluetoothHeadsetClient {
        @Override
        public void connect(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void disconnect(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void getConnectedDevices(AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void getDevicesMatchingConnectionStates(int[] states, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void getConnectionState(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void setConnectionPolicy(BluetoothDevice device, int connectionPolicy, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void getConnectionPolicy(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void startVoiceRecognition(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void stopVoiceRecognition(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void getCurrentCalls(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void getCurrentAgEvents(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void acceptCall(BluetoothDevice device, int flag, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void holdCall(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void rejectCall(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void terminateCall(BluetoothDevice device, BluetoothHeadsetClientCall call, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void enterPrivateMode(BluetoothDevice device, int index, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void explicitCallTransfer(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void dial(BluetoothDevice device, String number, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void sendDTMF(BluetoothDevice device, byte code, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void getLastVoiceTagNumber(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void getAudioState(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void connectAudio(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void disconnectAudio(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void setAudioRouteAllowed(BluetoothDevice device, boolean allowed, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void getAudioRouteAllowed(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void sendVendorAtCommand(BluetoothDevice device, int vendorId, String atCommand, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void getCurrentAgFeatures(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

