/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.bluetooth.Attributable;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.BluetoothProfileConnector;
import android.bluetooth.IBluetoothPbap;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.AttributionSource;
import android.content.Context;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@SystemApi
public class BluetoothPbap
implements BluetoothProfile {
    private static final String TAG = "BluetoothPbap";
    private static final boolean DBG = false;
    @SystemApi
    @SuppressLint(value={"ActionValue"})
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.pbap.profile.action.CONNECTION_STATE_CHANGED";
    private final AttributionSource mAttributionSource;
    public static final int RESULT_FAILURE = 0;
    public static final int RESULT_SUCCESS = 1;
    public static final int RESULT_CANCELED = 2;
    private BluetoothAdapter mAdapter;
    private final BluetoothProfileConnector<IBluetoothPbap> mProfileConnector = new BluetoothProfileConnector(this, 6, "BluetoothPbap", IBluetoothPbap.class.getName()){

        public IBluetoothPbap getServiceInterface(IBinder service) {
            return IBluetoothPbap.Stub.asInterface(service);
        }
    };

    public BluetoothPbap(Context context, BluetoothProfile.ServiceListener listener, BluetoothAdapter adapter) {
        this.mAdapter = adapter;
        this.mAttributionSource = adapter.getAttributionSource();
        this.mProfileConnector.connect(context, listener);
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public synchronized void close() {
        this.mProfileConnector.disconnect();
    }

    private IBluetoothPbap getService() {
        return this.mProfileConnector.getService();
    }

    @Override
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public List<BluetoothDevice> getConnectedDevices() {
        BluetoothPbap.log("getConnectedDevices()");
        IBluetoothPbap service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            return new ArrayList<BluetoothDevice>();
        }
        try {
            return Attributable.setAttributionSource(service.getConnectedDevices(this.mAttributionSource), this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, e.toString());
            return new ArrayList<BluetoothDevice>();
        }
    }

    @Override
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int getConnectionState(BluetoothDevice device) {
        BluetoothPbap.log("getConnectionState: device=" + device);
        try {
            IBluetoothPbap service = this.getService();
            if (service != null && this.isEnabled() && this.isValidDevice(device)) {
                return service.getConnectionState(device, this.mAttributionSource);
            }
            if (service == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            return 0;
        }
        catch (RemoteException e) {
            Log.e(TAG, e.toString());
            return 0;
        }
    }

    @Override
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] states) {
        BluetoothPbap.log("getDevicesMatchingConnectionStates: states=" + Arrays.toString(states));
        IBluetoothPbap service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            return new ArrayList<BluetoothDevice>();
        }
        try {
            return Attributable.setAttributionSource(service.getDevicesMatchingConnectionStates(states, this.mAttributionSource), this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, e.toString());
            return new ArrayList<BluetoothDevice>();
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setConnectionPolicy(BluetoothDevice device, int connectionPolicy) {
        try {
            IBluetoothPbap service = this.getService();
            if (service != null && this.isEnabled() && this.isValidDevice(device)) {
                if (connectionPolicy != 0 && connectionPolicy != 100) {
                    return false;
                }
                return service.setConnectionPolicy(device, connectionPolicy, this.mAttributionSource);
            }
            if (service == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            return false;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            return false;
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean disconnect(BluetoothDevice device) {
        BluetoothPbap.log("disconnect()");
        IBluetoothPbap service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            return false;
        }
        try {
            service.disconnect(device, this.mAttributionSource);
            return true;
        }
        catch (RemoteException e) {
            Log.e(TAG, e.toString());
            return false;
        }
    }

    private boolean isEnabled() {
        return this.mAdapter.getState() == 12;
    }

    private boolean isValidDevice(BluetoothDevice device) {
        if (device == null) {
            return false;
        }
        return BluetoothAdapter.checkBluetoothAddress(device.getAddress());
    }

    private static void log(String msg) {
    }
}

