/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.SystemApi;
import android.bluetooth.BluetoothUtils;
import android.os.Parcel;
import android.os.Parcelable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@SystemApi
public class BluetoothLeAudioCodecConfigMetadata
implements Parcelable {
    private static final int AUDIO_CHANNEL_LOCATION_TYPE = 3;
    private final long mAudioLocation;
    private final byte[] mRawMetadata;
    @SystemApi
    public static final Parcelable.Creator<BluetoothLeAudioCodecConfigMetadata> CREATOR = new Parcelable.Creator<BluetoothLeAudioCodecConfigMetadata>(){

        @Override
        public BluetoothLeAudioCodecConfigMetadata createFromParcel(Parcel in) {
            byte[] rawMetadata;
            long audioLocation = in.readLong();
            int rawMetadataLen = in.readInt();
            if (rawMetadataLen != -1) {
                rawMetadata = new byte[rawMetadataLen];
                in.readByteArray(rawMetadata);
            } else {
                rawMetadata = new byte[]{};
            }
            return new BluetoothLeAudioCodecConfigMetadata(audioLocation, rawMetadata);
        }

        public BluetoothLeAudioCodecConfigMetadata[] newArray(int size) {
            return new BluetoothLeAudioCodecConfigMetadata[size];
        }
    };

    private BluetoothLeAudioCodecConfigMetadata(long audioLocation, byte[] rawMetadata) {
        this.mAudioLocation = audioLocation;
        this.mRawMetadata = rawMetadata;
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof BluetoothLeAudioCodecConfigMetadata) {
            BluetoothLeAudioCodecConfigMetadata oth = (BluetoothLeAudioCodecConfigMetadata)o;
            return this.mAudioLocation == oth.getAudioLocation() && Arrays.equals(this.mRawMetadata, oth.getRawMetadata());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mAudioLocation, this.mRawMetadata);
    }

    @SystemApi
    public long getAudioLocation() {
        return this.mAudioLocation;
    }

    @SystemApi
    public byte[] getRawMetadata() {
        return this.mRawMetadata;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeLong(this.mAudioLocation);
        if (this.mRawMetadata != null) {
            out.writeInt(this.mRawMetadata.length);
            out.writeByteArray(this.mRawMetadata);
        } else {
            out.writeInt(-1);
        }
    }

    @SystemApi
    public static BluetoothLeAudioCodecConfigMetadata fromRawBytes(byte[] rawBytes) {
        if (rawBytes == null) {
            throw new IllegalArgumentException("Raw bytes cannot be null");
        }
        List<BluetoothUtils.TypeValueEntry> entries = BluetoothUtils.parseLengthTypeValueBytes(rawBytes);
        if (rawBytes.length > 0 && rawBytes[0] > 0 && entries.isEmpty()) {
            throw new IllegalArgumentException("No LTV entries are found from rawBytes of size " + rawBytes.length);
        }
        long audioLocation = 0L;
        for (BluetoothUtils.TypeValueEntry entry : entries) {
            if (entry.getType() != 3) continue;
            byte[] bytes = entry.getValue();
            audioLocation = (long)((bytes[0] & 0xFF) << 0 | (bytes[1] & 0xFF) << 8 | (bytes[2] & 0xFF) << 16) | (long)(bytes[3] & 0xFF) << 24;
        }
        return new BluetoothLeAudioCodecConfigMetadata(audioLocation, rawBytes);
    }

    @SystemApi
    public static class Builder {
        private long mAudioLocation = 0L;
        private byte[] mRawMetadata = null;

        @SystemApi
        public Builder() {
        }

        @SystemApi
        public Builder(BluetoothLeAudioCodecConfigMetadata original) {
            this.mAudioLocation = original.getAudioLocation();
            this.mRawMetadata = original.getRawMetadata();
        }

        @SystemApi
        public Builder setAudioLocation(long audioLocation) {
            this.mAudioLocation = audioLocation;
            return this;
        }

        @SystemApi
        public BluetoothLeAudioCodecConfigMetadata build() {
            byte[] rawBytes;
            ArrayList<BluetoothUtils.TypeValueEntry> entries = new ArrayList();
            if (this.mRawMetadata != null) {
                entries = BluetoothUtils.parseLengthTypeValueBytes(this.mRawMetadata);
                if (this.mRawMetadata.length > 0 && this.mRawMetadata[0] > 0 && entries.isEmpty()) {
                    throw new IllegalArgumentException("No LTV entries are found from rawBytes of size " + this.mRawMetadata.length + " please check the original object passed to Builder's copy constructor");
                }
            }
            if (this.mAudioLocation != 0L) {
                entries.removeIf(entry -> entry.getType() == 3);
                entries.add(new BluetoothUtils.TypeValueEntry(3, ByteBuffer.allocate(8).putLong(this.mAudioLocation).array()));
            }
            if ((rawBytes = BluetoothUtils.serializeTypeValue(entries)) == null) {
                throw new IllegalArgumentException("Failed to serialize entries to bytes");
            }
            return new BluetoothLeAudioCodecConfigMetadata(this.mAudioLocation, rawBytes);
        }
    }
}

