/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class BluetoothLeAudioCodecConfig
implements Parcelable {
    public static final int SOURCE_CODEC_TYPE_LC3 = 0;
    public static final int SOURCE_CODEC_TYPE_INVALID = 1000000;
    public static final int CODEC_PRIORITY_DISABLED = -1;
    public static final int CODEC_PRIORITY_DEFAULT = 0;
    public static final int CODEC_PRIORITY_HIGHEST = 1000000;
    public static final int SAMPLE_RATE_NONE = 0;
    public static final int SAMPLE_RATE_8000 = 1;
    public static final int SAMPLE_RATE_16000 = 4;
    public static final int SAMPLE_RATE_24000 = 16;
    public static final int SAMPLE_RATE_32000 = 32;
    public static final int SAMPLE_RATE_44100 = 64;
    public static final int SAMPLE_RATE_48000 = 128;
    public static final int BITS_PER_SAMPLE_NONE = 0;
    public static final int BITS_PER_SAMPLE_16 = 1;
    public static final int BITS_PER_SAMPLE_24 = 2;
    public static final int BITS_PER_SAMPLE_32 = 8;
    public static final int CHANNEL_COUNT_NONE = 0;
    public static final int CHANNEL_COUNT_1 = 1;
    public static final int CHANNEL_COUNT_2 = 2;
    public static final int FRAME_DURATION_NONE = 0;
    public static final int FRAME_DURATION_7500 = 1;
    public static final int FRAME_DURATION_10000 = 2;
    private final int mCodecType;
    private final int mCodecPriority;
    private final int mSampleRate;
    private final int mBitsPerSample;
    private final int mChannelCount;
    private final int mFrameDuration;
    private final int mOctetsPerFrame;
    private final int mMinOctetsPerFrame;
    private final int mMaxOctetsPerFrame;
    public static final Parcelable.Creator<BluetoothLeAudioCodecConfig> CREATOR = new Parcelable.Creator<BluetoothLeAudioCodecConfig>(){

        @Override
        public BluetoothLeAudioCodecConfig createFromParcel(Parcel in) {
            int codecType = in.readInt();
            int codecPriority = in.readInt();
            int sampleRate = in.readInt();
            int bitsPerSample = in.readInt();
            int channelCount = in.readInt();
            int frameDuration = in.readInt();
            int octetsPerFrame = in.readInt();
            int minOctetsPerFrame = in.readInt();
            int maxOctetsPerFrame = in.readInt();
            return new BluetoothLeAudioCodecConfig(codecType, codecPriority, sampleRate, bitsPerSample, channelCount, frameDuration, octetsPerFrame, minOctetsPerFrame, maxOctetsPerFrame);
        }

        public BluetoothLeAudioCodecConfig[] newArray(int size) {
            return new BluetoothLeAudioCodecConfig[size];
        }
    };

    private BluetoothLeAudioCodecConfig(int codecType, int codecPriority, int sampleRate, int bitsPerSample, int channelCount, int frameDuration, int octetsPerFrame, int minOctetsPerFrame, int maxOctetsPerFrame) {
        this.mCodecType = codecType;
        this.mCodecPriority = codecPriority;
        this.mSampleRate = sampleRate;
        this.mBitsPerSample = bitsPerSample;
        this.mChannelCount = channelCount;
        this.mFrameDuration = frameDuration;
        this.mOctetsPerFrame = octetsPerFrame;
        this.mMinOctetsPerFrame = minOctetsPerFrame;
        this.mMaxOctetsPerFrame = maxOctetsPerFrame;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mCodecType);
        out.writeInt(this.mCodecPriority);
        out.writeInt(this.mSampleRate);
        out.writeInt(this.mBitsPerSample);
        out.writeInt(this.mChannelCount);
        out.writeInt(this.mFrameDuration);
        out.writeInt(this.mOctetsPerFrame);
        out.writeInt(this.mMinOctetsPerFrame);
        out.writeInt(this.mMaxOctetsPerFrame);
    }

    public String toString() {
        return "{codecName:" + this.getCodecName() + ",mCodecType:" + this.mCodecType + ",mCodecPriority:" + this.mCodecPriority + ",mSampleRate:" + this.mSampleRate + ",mBitsPerSample:" + this.mBitsPerSample + ",mChannelCount:" + this.mChannelCount + ",mFrameDuration:" + this.mFrameDuration + ",mOctetsPerFrame:" + this.mOctetsPerFrame + ",mMinOctetsPerFrame:" + this.mMinOctetsPerFrame + ",mMaxOctetsPerFrame:" + this.mMaxOctetsPerFrame + "}";
    }

    public int getCodecType() {
        return this.mCodecType;
    }

    public String getCodecName() {
        switch (this.mCodecType) {
            case 0: {
                return "LC3";
            }
            case 1000000: {
                return "INVALID CODEC";
            }
        }
        return "UNKNOWN CODEC(" + this.mCodecType + ")";
    }

    public int getCodecPriority() {
        return this.mCodecPriority;
    }

    public int getSampleRate() {
        return this.mSampleRate;
    }

    public int getBitsPerSample() {
        return this.mBitsPerSample;
    }

    public int getChannelCount() {
        return this.mChannelCount;
    }

    public int getFrameDuration() {
        return this.mFrameDuration;
    }

    public int getOctetsPerFrame() {
        return this.mOctetsPerFrame;
    }

    public int getMinOctetsPerFrame() {
        return this.mMinOctetsPerFrame;
    }

    public int getMaxOctetsPerFrame() {
        return this.mMaxOctetsPerFrame;
    }

    public boolean equals(Object o) {
        if (o instanceof BluetoothLeAudioCodecConfig) {
            BluetoothLeAudioCodecConfig other = (BluetoothLeAudioCodecConfig)o;
            return other.getCodecType() == this.mCodecType && other.getCodecPriority() == this.mCodecPriority && other.getSampleRate() == this.mSampleRate && other.getBitsPerSample() == this.mBitsPerSample && other.getChannelCount() == this.mChannelCount && other.getFrameDuration() == this.mFrameDuration && other.getOctetsPerFrame() == this.mOctetsPerFrame && other.getMinOctetsPerFrame() == this.mMinOctetsPerFrame && other.getMaxOctetsPerFrame() == this.mMaxOctetsPerFrame;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mCodecType, this.mCodecPriority, this.mSampleRate, this.mBitsPerSample, this.mChannelCount, this.mFrameDuration, this.mOctetsPerFrame, this.mMinOctetsPerFrame, this.mMaxOctetsPerFrame);
    }

    public static class Builder {
        private int mCodecType = 1000000;
        private int mCodecPriority = 0;
        private int mSampleRate = 0;
        private int mBitsPerSample = 0;
        private int mChannelCount = 0;
        private int mFrameDuration = 0;
        private int mOctetsPerFrame = 0;
        private int mMinOctetsPerFrame = 0;
        private int mMaxOctetsPerFrame = 0;

        public Builder() {
        }

        public Builder(BluetoothLeAudioCodecConfig config) {
            this.mCodecType = config.getCodecType();
            this.mCodecPriority = config.getCodecPriority();
            this.mSampleRate = config.getSampleRate();
            this.mBitsPerSample = config.getBitsPerSample();
            this.mChannelCount = config.getChannelCount();
            this.mFrameDuration = config.getFrameDuration();
            this.mOctetsPerFrame = config.getOctetsPerFrame();
            this.mMinOctetsPerFrame = config.getMinOctetsPerFrame();
            this.mMaxOctetsPerFrame = config.getMaxOctetsPerFrame();
        }

        public Builder setCodecType(int codecType) {
            this.mCodecType = codecType;
            return this;
        }

        public Builder setCodecPriority(int codecPriority) {
            this.mCodecPriority = codecPriority;
            return this;
        }

        public Builder setSampleRate(int sampleRate) {
            this.mSampleRate = sampleRate;
            return this;
        }

        public Builder setBitsPerSample(int bitsPerSample) {
            this.mBitsPerSample = bitsPerSample;
            return this;
        }

        public Builder setChannelCount(int channelCount) {
            this.mChannelCount = channelCount;
            return this;
        }

        public Builder setFrameDuration(int frameDuration) {
            this.mFrameDuration = frameDuration;
            return this;
        }

        public Builder setOctetsPerFrame(int octetsPerFrame) {
            this.mOctetsPerFrame = octetsPerFrame;
            return this;
        }

        public Builder setMinOctetsPerFrame(int minOctetsPerFrame) {
            this.mMinOctetsPerFrame = minOctetsPerFrame;
            return this;
        }

        public Builder setMaxOctetsPerFrame(int maxOctetsPerFrame) {
            this.mMaxOctetsPerFrame = maxOctetsPerFrame;
            return this;
        }

        public BluetoothLeAudioCodecConfig build() {
            return new BluetoothLeAudioCodecConfig(this.mCodecType, this.mCodecPriority, this.mSampleRate, this.mBitsPerSample, this.mChannelCount, this.mFrameDuration, this.mOctetsPerFrame, this.mMinOctetsPerFrame, this.mMaxOctetsPerFrame);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FrameDuration {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ChannelCount {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BitsPerSample {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SampleRate {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CodecPriority {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SourceCodecType {
    }
}

