/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.bluetooth.Attributable;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothLeAudioCodecConfig;
import android.bluetooth.BluetoothLeAudioCodecStatus;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.BluetoothProfileConnector;
import android.bluetooth.BluetoothUtils;
import android.bluetooth.IBluetoothLeAudio;
import android.bluetooth.IBluetoothLeAudioCallback;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.content.AttributionSource;
import android.content.Context;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.CloseGuard;
import android.util.Log;
import com.android.bluetooth.x.com.android.modules.utils.SynchronousResultReceiver;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;

public class BluetoothLeAudio
implements BluetoothProfile,
AutoCloseable {
    private static final String TAG = "BluetoothLeAudio";
    private static final boolean DBG = false;
    private static final boolean VDBG = false;
    private final Map<Callback, Executor> mCallbackExecutorMap = new HashMap<Callback, Executor>();
    private CloseGuard mCloseGuard;
    @SuppressLint(value={"AndroidFrameworkBluetoothPermission"})
    private final IBluetoothLeAudioCallback mCallback = new IBluetoothLeAudioCallback.Stub(){

        @Override
        public void onCodecConfigChanged(int groupId, BluetoothLeAudioCodecStatus status) {
            for (Map.Entry<Callback, Executor> callbackExecutorEntry : BluetoothLeAudio.this.mCallbackExecutorMap.entrySet()) {
                Callback callback = callbackExecutorEntry.getKey();
                Executor executor = callbackExecutorEntry.getValue();
                executor.execute(() -> callback.onCodecConfigChanged(groupId, status));
            }
        }

        @Override
        public void onGroupNodeAdded(BluetoothDevice device, int groupId) {
            Attributable.setAttributionSource(device, BluetoothLeAudio.this.mAttributionSource);
            for (Map.Entry<Callback, Executor> callbackExecutorEntry : BluetoothLeAudio.this.mCallbackExecutorMap.entrySet()) {
                Callback callback = callbackExecutorEntry.getKey();
                Executor executor = callbackExecutorEntry.getValue();
                executor.execute(() -> callback.onGroupNodeAdded(device, groupId));
            }
        }

        @Override
        public void onGroupNodeRemoved(BluetoothDevice device, int groupId) {
            Attributable.setAttributionSource(device, BluetoothLeAudio.this.mAttributionSource);
            for (Map.Entry<Callback, Executor> callbackExecutorEntry : BluetoothLeAudio.this.mCallbackExecutorMap.entrySet()) {
                Callback callback = callbackExecutorEntry.getKey();
                Executor executor = callbackExecutorEntry.getValue();
                executor.execute(() -> callback.onGroupNodeRemoved(device, groupId));
            }
        }

        @Override
        public void onGroupStatusChanged(int groupId, int groupStatus) {
            for (Map.Entry<Callback, Executor> callbackExecutorEntry : BluetoothLeAudio.this.mCallbackExecutorMap.entrySet()) {
                Callback callback = callbackExecutorEntry.getKey();
                Executor executor = callbackExecutorEntry.getValue();
                executor.execute(() -> callback.onGroupStatusChanged(groupId, groupStatus));
            }
        }
    };
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_LE_AUDIO_CONNECTION_STATE_CHANGED = "android.bluetooth.action.LE_AUDIO_CONNECTION_STATE_CHANGED";
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public static final String ACTION_LE_AUDIO_ACTIVE_DEVICE_CHANGED = "android.bluetooth.action.LE_AUDIO_ACTIVE_DEVICE_CHANGED";
    public static final int CONTEXT_TYPE_UNSPECIFIED = 1;
    public static final int CONTEXT_TYPE_COMMUNICATION = 2;
    public static final int CONTEXT_TYPE_MEDIA = 4;
    public static final int CONTEXT_TYPE_INSTRUCTIONAL = 8;
    public static final int CONTEXT_TYPE_ATTENTION_SEEKING = 16;
    public static final int CONTEXT_TYPE_IMMEDIATE_ALERT = 32;
    public static final int CONTEXT_TYPE_MAN_MACHINE = 64;
    public static final int CONTEXT_TYPE_EMERGENCY_ALERT = 128;
    public static final int CONTEXT_TYPE_RINGTONE = 256;
    public static final int CONTEXT_TYPE_TV = 512;
    public static final int CONTEXT_TYPE_LIVE = 1024;
    public static final int CONTEXT_TYPE_GAME = 2048;
    public static final int GROUP_ID_INVALID = -1;
    @SystemApi
    public static final int AUDIO_LOCATION_INVALID = 0;
    @SystemApi
    public static final int AUDIO_LOCATION_FRONT_LEFT = 1;
    @SystemApi
    public static final int AUDIO_LOCATION_FRONT_RIGHT = 2;
    @SystemApi
    public static final int AUDIO_LOCATION_FRONT_CENTER = 4;
    @SystemApi
    public static final int AUDIO_LOCATION_LOW_FREQ_EFFECTS_ONE = 8;
    @SystemApi
    public static final int AUDIO_LOCATION_BACK_LEFT = 16;
    @SystemApi
    public static final int AUDIO_LOCATION_BACK_RIGHT = 32;
    @SystemApi
    public static final int AUDIO_LOCATION_FRONT_LEFT_OF_CENTER = 64;
    @SystemApi
    public static final int AUDIO_LOCATION_FRONT_RIGHT_OF_CENTER = 128;
    @SystemApi
    public static final int AUDIO_LOCATION_BACK_CENTER = 256;
    @SystemApi
    public static final int AUDIO_LOCATION_LOW_FREQ_EFFECTS_TWO = 512;
    @SystemApi
    public static final int AUDIO_LOCATION_SIDE_LEFT = 1024;
    @SystemApi
    public static final int AUDIO_LOCATION_SIDE_RIGHT = 2048;
    @SystemApi
    public static final int AUDIO_LOCATION_TOP_FRONT_LEFT = 4096;
    @SystemApi
    public static final int AUDIO_LOCATION_TOP_FRONT_RIGHT = 8192;
    @SystemApi
    public static final int AUDIO_LOCATION_TOP_FRONT_CENTER = 16384;
    @SystemApi
    public static final int AUDIO_LOCATION_TOP_CENTER = 32768;
    @SystemApi
    public static final int AUDIO_LOCATION_TOP_BACK_LEFT = 65536;
    @SystemApi
    public static final int AUDIO_LOCATION_TOP_BACK_RIGHT = 131072;
    @SystemApi
    public static final int AUDIO_LOCATION_TOP_SIDE_LEFT = 262144;
    @SystemApi
    public static final int AUDIO_LOCATION_TOP_SIDE_RIGHT = 524288;
    @SystemApi
    public static final int AUDIO_LOCATION_TOP_BACK_CENTER = 0x100000;
    @SystemApi
    public static final int AUDIO_LOCATION_BOTTOM_FRONT_CENTER = 0x200000;
    @SystemApi
    public static final int AUDIO_LOCATION_BOTTOM_FRONT_LEFT = 0x400000;
    @SystemApi
    public static final int AUDIO_LOCATION_BOTTOM_FRONT_RIGHT = 0x800000;
    @SystemApi
    public static final int AUDIO_LOCATION_FRONT_LEFT_WIDE = 0x1000000;
    @SystemApi
    public static final int AUDIO_LOCATION_FRONT_RIGHT_WIDE = 0x2000000;
    @SystemApi
    public static final int AUDIO_LOCATION_LEFT_SURROUND = 0x4000000;
    @SystemApi
    public static final int AUDIO_LOCATION_RIGHT_SURROUND = 0x8000000;
    @SystemApi
    public static final String EXTRA_LE_AUDIO_GROUP_ID = "android.bluetooth.extra.LE_AUDIO_GROUP_ID";
    public static final String EXTRA_LE_AUDIO_DIRECTION = "android.bluetooth.extra.LE_AUDIO_DIRECTION";
    public static final String EXTRA_LE_AUDIO_SOURCE_LOCATION = "android.bluetooth.extra.LE_AUDIO_SOURCE_LOCATION";
    public static final String EXTRA_LE_AUDIO_SINK_LOCATION = "android.bluetooth.extra.LE_AUDIO_SINK_LOCATION";
    public static final String EXTRA_LE_AUDIO_AVAILABLE_CONTEXTS = "android.bluetooth.extra.LE_AUDIO_AVAILABLE_CONTEXTS";
    private final BluetoothAdapter mAdapter;
    private final AttributionSource mAttributionSource;
    public static final int GROUP_STATUS_ACTIVE = 1;
    public static final int GROUP_STATUS_INACTIVE = 0;
    private final BluetoothProfileConnector<IBluetoothLeAudio> mProfileConnector = new BluetoothProfileConnector(this, 22, "BluetoothLeAudio", IBluetoothLeAudio.class.getName()){

        public IBluetoothLeAudio getServiceInterface(IBinder service) {
            return IBluetoothLeAudio.Stub.asInterface(service);
        }
    };
    @SuppressLint(value={"AndroidFrameworkBluetoothPermission"})
    private final IBluetoothStateChangeCallback mBluetoothStateChangeCallback = new IBluetoothStateChangeCallback.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onBluetoothStateChange(boolean up) {
            if (up) {
                Map<Callback, Executor> map = BluetoothLeAudio.this.mCallbackExecutorMap;
                synchronized (map) {
                    if (!BluetoothLeAudio.this.mCallbackExecutorMap.isEmpty()) {
                        try {
                            IBluetoothLeAudio service = BluetoothLeAudio.this.getService();
                            if (service != null) {
                                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                                service.registerCallback(BluetoothLeAudio.this.mCallback, BluetoothLeAudio.this.mAttributionSource, recv);
                                recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
                            }
                        }
                        catch (TimeoutException e) {
                            Log.e(BluetoothLeAudio.TAG, "Failed to register callback", e);
                        }
                        catch (RemoteException e) {
                            throw e.rethrowFromSystemServer();
                        }
                    }
                }
            }
        }
    };

    BluetoothLeAudio(Context context, BluetoothProfile.ServiceListener listener, BluetoothAdapter adapter) {
        this.mAdapter = adapter;
        this.mAttributionSource = adapter.getAttributionSource();
        this.mProfileConnector.connect(context, listener);
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.registerStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        this.mCloseGuard = new CloseGuard();
        this.mCloseGuard.open("close");
    }

    @Override
    public void close() {
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.unregisterStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException e) {
                Log.e(TAG, "", e);
            }
        }
        this.mProfileConnector.disconnect();
    }

    private IBluetoothLeAudio getService() {
        return this.mProfileConnector.getService();
    }

    protected void finalize() {
        if (this.mCloseGuard != null) {
            this.mCloseGuard.warnIfOpen();
        }
        this.close();
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean connect(BluetoothDevice device) {
        IBluetoothLeAudio service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        } else if (this.mAdapter.isEnabled() && this.isValidDevice(device)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.connect(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean disconnect(BluetoothDevice device) {
        IBluetoothLeAudio service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        } else if (this.mAdapter.isEnabled() && this.isValidDevice(device)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.disconnect(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothDevice getConnectedGroupLeadDevice(int groupId) {
        IBluetoothLeAudio service = this.getService();
        BluetoothDevice defaultValue = null;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        } else if (this.mAdapter.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getConnectedGroupLeadDevice(groupId, this.mAttributionSource, recv);
                return Attributable.setAttributionSource(recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(defaultValue), this.mAttributionSource);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return defaultValue;
    }

    @Override
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public List<BluetoothDevice> getConnectedDevices() {
        IBluetoothLeAudio service = this.getService();
        ArrayList<BluetoothDevice> defaultValue = new ArrayList<BluetoothDevice>();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        } else if (this.mAdapter.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getConnectedDevices(this.mAttributionSource, recv);
                return Attributable.setAttributionSource((List)recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(defaultValue), this.mAttributionSource);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return defaultValue;
    }

    @Override
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] states) {
        IBluetoothLeAudio service = this.getService();
        ArrayList<BluetoothDevice> defaultValue = new ArrayList<BluetoothDevice>();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        } else if (this.mAdapter.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getDevicesMatchingConnectionStates(states, this.mAttributionSource, recv);
                return Attributable.setAttributionSource((List)recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(defaultValue), this.mAttributionSource);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return defaultValue;
    }

    @Override
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getConnectionState(BluetoothDevice device) {
        IBluetoothLeAudio service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        } else if (this.mAdapter.isEnabled() && this.isValidDevice(device)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getConnectionState(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(0);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void registerCallback(Executor executor, Callback callback) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(callback, "callback cannot be null");
        Map<Callback, Executor> map = this.mCallbackExecutorMap;
        synchronized (map) {
            if (this.mCallbackExecutorMap.isEmpty()) {
                if (!this.mAdapter.isEnabled()) {
                    this.mCallbackExecutorMap.put(callback, executor);
                    return;
                }
                try {
                    IBluetoothLeAudio service = this.getService();
                    if (service != null) {
                        SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                        service.registerCallback(this.mCallback, this.mAttributionSource, recv);
                        recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
                    }
                }
                catch (TimeoutException e) {
                    Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            if (this.mCallbackExecutorMap.containsKey(callback)) {
                throw new IllegalArgumentException("This callback has already been registered");
            }
            this.mCallbackExecutorMap.put(callback, executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void unregisterCallback(Callback callback) {
        Objects.requireNonNull(callback, "callback cannot be null");
        Map<Callback, Executor> map = this.mCallbackExecutorMap;
        synchronized (map) {
            if (this.mCallbackExecutorMap.remove(callback) == null) {
                throw new IllegalArgumentException("This callback has not been registered");
            }
        }
        if (this.mCallbackExecutorMap.isEmpty()) {
            try {
                IBluetoothLeAudio service = this.getService();
                if (service != null) {
                    SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                    service.unregisterCallback(this.mCallback, this.mAttributionSource, recv);
                    recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
                }
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean setActiveDevice(BluetoothDevice device) {
        IBluetoothLeAudio service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        } else if (this.mAdapter.isEnabled() && (device == null || this.isValidDevice(device))) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.setActiveDevice(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public List<BluetoothDevice> getActiveDevices() {
        IBluetoothLeAudio service = this.getService();
        ArrayList<BluetoothDevice> defaultValue = new ArrayList<BluetoothDevice>();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        } else if (this.mAdapter.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getActiveDevices(this.mAttributionSource, recv);
                return Attributable.setAttributionSource((List)recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(defaultValue), this.mAttributionSource);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return defaultValue;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getGroupId(BluetoothDevice device) {
        IBluetoothLeAudio service = this.getService();
        int defaultValue = -1;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        } else if (this.mAdapter.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getGroupId(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(-1);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return -1;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void setVolume(int volume) {
        IBluetoothLeAudio service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        } else if (this.mAdapter.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.setVolume(volume, this.mAttributionSource, recv);
                recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean groupAddNode(int group_id, BluetoothDevice device) {
        IBluetoothLeAudio service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        } else if (this.mAdapter.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.groupAddNode(group_id, device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean groupRemoveNode(int group_id, BluetoothDevice device) {
        IBluetoothLeAudio service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        } else if (this.mAdapter.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.groupRemoveNode(group_id, device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int getAudioLocation(BluetoothDevice device) {
        IBluetoothLeAudio service = this.getService();
        boolean defaultLocation = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        } else if (this.mAdapter.isEnabled() && this.isValidDevice(device)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getAudioLocation(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(0);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return 0;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setConnectionPolicy(BluetoothDevice device, int connectionPolicy) {
        IBluetoothLeAudio service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        } else if (this.mAdapter.isEnabled() && this.isValidDevice(device) && (connectionPolicy == 0 || connectionPolicy == 100)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.setConnectionPolicy(device, connectionPolicy, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int getConnectionPolicy(BluetoothDevice device) {
        IBluetoothLeAudio service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        } else if (this.mAdapter.isEnabled() && this.isValidDevice(device)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getConnectionPolicy(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(0);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return 0;
    }

    public static String stateToString(int state) {
        switch (state) {
            case 0: {
                return "disconnected";
            }
            case 1: {
                return "connecting";
            }
            case 2: {
                return "connected";
            }
            case 3: {
                return "disconnecting";
            }
        }
        return "<unknown state " + state + ">";
    }

    private boolean isValidDevice(BluetoothDevice device) {
        if (device == null) {
            return false;
        }
        return BluetoothAdapter.checkBluetoothAddress(device.getAddress());
    }

    private static void log(String msg) {
        Log.d(TAG, msg);
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public BluetoothLeAudioCodecStatus getCodecStatus(int groupId) {
        IBluetoothLeAudio service = this.getService();
        BluetoothLeAudioCodecStatus defaultValue = null;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        } else if (this.mAdapter.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getCodecStatus(groupId, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(defaultValue);
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
                e.rethrowFromSystemServer();
            }
        }
        return defaultValue;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void setCodecConfigPreference(int groupId, BluetoothLeAudioCodecConfig inputCodecConfig, BluetoothLeAudioCodecConfig outputCodecConfig) {
        Objects.requireNonNull(inputCodecConfig, " inputCodecConfig shall not be null");
        Objects.requireNonNull(outputCodecConfig, " outputCodecConfig shall not be null");
        IBluetoothLeAudio service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            throw new IllegalStateException("Service is unavailable");
        }
        if (this.mAdapter.isEnabled()) {
            try {
                service.setCodecConfigPreference(groupId, inputCodecConfig, outputCodecConfig, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
                e.rethrowFromSystemServer();
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AudioLocation {
    }

    @SystemApi
    public static interface Callback {
        @SystemApi
        public void onCodecConfigChanged(int var1, BluetoothLeAudioCodecStatus var2);

        @SystemApi
        public void onGroupNodeAdded(BluetoothDevice var1, int var2);

        @SystemApi
        public void onGroupNodeRemoved(BluetoothDevice var1, int var2);

        @SystemApi
        public void onGroupStatusChanged(int var1, int var2);

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface GroupStatus {
        }
    }
}

