/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.bluetooth.Attributable;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothSocket;
import android.bluetooth.BluetoothUtils;
import android.bluetooth.IBluetooth;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothManagerCallback;
import android.bluetooth.OobData;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.AttributionSource;
import android.content.Context;
import android.os.Handler;
import android.os.IpcDataCache;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import com.android.bluetooth.x.com.android.modules.utils.SynchronousResultReceiver;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeoutException;

public class BluetoothDevice
implements Parcelable,
Attributable {
    private static final String TAG = "BluetoothDevice";
    private static final boolean DBG = false;
    private static final int CONNECTION_STATE_DISCONNECTED = 0;
    private static final int CONNECTION_STATE_CONNECTED = 1;
    private static final int CONNECTION_STATE_ENCRYPTED_BREDR = 2;
    private static final int CONNECTION_STATE_ENCRYPTED_LE = 4;
    public static final int ERROR = Integer.MIN_VALUE;
    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public static final String ACTION_FOUND = "android.bluetooth.device.action.FOUND";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_CLASS_CHANGED = "android.bluetooth.device.action.CLASS_CHANGED";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_ACL_CONNECTED = "android.bluetooth.device.action.ACL_CONNECTED";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_ACL_DISCONNECT_REQUESTED = "android.bluetooth.device.action.ACL_DISCONNECT_REQUESTED";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_ACL_DISCONNECTED = "android.bluetooth.device.action.ACL_DISCONNECTED";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_NAME_CHANGED = "android.bluetooth.device.action.NAME_CHANGED";
    @SuppressLint(value={"ActionValue"})
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_ALIAS_CHANGED = "android.bluetooth.device.action.ALIAS_CHANGED";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_BOND_STATE_CHANGED = "android.bluetooth.device.action.BOND_STATE_CHANGED";
    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"ActionValue"})
    public static final String ACTION_BATTERY_LEVEL_CHANGED = "android.bluetooth.device.action.BATTERY_LEVEL_CHANGED";
    @SystemApi
    @SuppressLint(value={"ActionValue"})
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public static final String ACTION_SWITCH_BUFFER_SIZE = "android.bluetooth.device.action.SWITCH_BUFFER_SIZE";
    @SystemApi
    @SuppressLint(value={"ActionValue"})
    public static final String EXTRA_BATTERY_LEVEL = "android.bluetooth.device.extra.BATTERY_LEVEL";
    @SystemApi
    public static final int BATTERY_LEVEL_UNKNOWN = -1;
    @SystemApi
    public static final int BATTERY_LEVEL_BLUETOOTH_OFF = -100;
    public static final String EXTRA_DEVICE = "android.bluetooth.device.extra.DEVICE";
    public static final String EXTRA_NAME = "android.bluetooth.device.extra.NAME";
    public static final String EXTRA_RSSI = "android.bluetooth.device.extra.RSSI";
    public static final String EXTRA_IS_COORDINATED_SET_MEMBER = "android.bluetooth.extra.IS_COORDINATED_SET_MEMBER";
    public static final String EXTRA_CLASS = "android.bluetooth.device.extra.CLASS";
    public static final String EXTRA_BOND_STATE = "android.bluetooth.device.extra.BOND_STATE";
    public static final String EXTRA_PREVIOUS_BOND_STATE = "android.bluetooth.device.extra.PREVIOUS_BOND_STATE";
    @SystemApi
    @SuppressLint(value={"ActionValue"})
    public static final String EXTRA_LOW_LATENCY_BUFFER_SIZE = "android.bluetooth.device.extra.LOW_LATENCY_BUFFER_SIZE";
    public static final int BOND_NONE = 10;
    public static final int BOND_BONDING = 11;
    public static final int BOND_BONDED = 12;
    @SystemApi
    @SuppressLint(value={"ActionValue"})
    public static final String EXTRA_UNBOND_REASON = "android.bluetooth.device.extra.REASON";
    @UnsupportedAppUsage
    public static final String EXTRA_REASON = "android.bluetooth.device.extra.REASON";
    public static final String EXTRA_PAIRING_VARIANT = "android.bluetooth.device.extra.PAIRING_VARIANT";
    public static final String EXTRA_PAIRING_KEY = "android.bluetooth.device.extra.PAIRING_KEY";
    @SystemApi
    @SuppressLint(value={"ActionValue"})
    public static final String EXTRA_PAIRING_INITIATOR = "android.bluetooth.device.extra.PAIRING_INITIATOR";
    @SystemApi
    public static final int EXTRA_PAIRING_INITIATOR_FOREGROUND = 1;
    @SystemApi
    public static final int EXTRA_PAIRING_INITIATOR_BACKGROUND = 2;
    public static final int DEVICE_TYPE_UNKNOWN = 0;
    public static final int DEVICE_TYPE_CLASSIC = 1;
    public static final int DEVICE_TYPE_LE = 2;
    public static final int DEVICE_TYPE_DUAL = 3;
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final String ACTION_SDP_RECORD = "android.bluetooth.device.action.SDP_RECORD";
    @SystemApi
    public static final int METADATA_MAX_LENGTH = 2048;
    @SystemApi
    public static final int METADATA_MANUFACTURER_NAME = 0;
    @SystemApi
    public static final int METADATA_MODEL_NAME = 1;
    @SystemApi
    public static final int METADATA_SOFTWARE_VERSION = 2;
    @SystemApi
    public static final int METADATA_HARDWARE_VERSION = 3;
    @SystemApi
    public static final int METADATA_COMPANION_APP = 4;
    @SystemApi
    public static final int METADATA_MAIN_ICON = 5;
    @SystemApi
    public static final int METADATA_IS_UNTETHERED_HEADSET = 6;
    @SystemApi
    public static final int METADATA_UNTETHERED_LEFT_ICON = 7;
    @SystemApi
    public static final int METADATA_UNTETHERED_RIGHT_ICON = 8;
    @SystemApi
    public static final int METADATA_UNTETHERED_CASE_ICON = 9;
    @SystemApi
    public static final int METADATA_UNTETHERED_LEFT_BATTERY = 10;
    @SystemApi
    public static final int METADATA_UNTETHERED_RIGHT_BATTERY = 11;
    @SystemApi
    public static final int METADATA_UNTETHERED_CASE_BATTERY = 12;
    @SystemApi
    public static final int METADATA_UNTETHERED_LEFT_CHARGING = 13;
    @SystemApi
    public static final int METADATA_UNTETHERED_RIGHT_CHARGING = 14;
    @SystemApi
    public static final int METADATA_UNTETHERED_CASE_CHARGING = 15;
    @SystemApi
    public static final int METADATA_ENHANCED_SETTINGS_UI_URI = 16;
    @SystemApi
    public static final int METADATA_DEVICE_TYPE = 17;
    @SystemApi
    public static final int METADATA_MAIN_BATTERY = 18;
    @SystemApi
    public static final int METADATA_MAIN_CHARGING = 19;
    @SystemApi
    public static final int METADATA_MAIN_LOW_BATTERY_THRESHOLD = 20;
    @SystemApi
    public static final int METADATA_UNTETHERED_LEFT_LOW_BATTERY_THRESHOLD = 21;
    @SystemApi
    public static final int METADATA_UNTETHERED_RIGHT_LOW_BATTERY_THRESHOLD = 22;
    @SystemApi
    public static final int METADATA_UNTETHERED_CASE_LOW_BATTERY_THRESHOLD = 23;
    public static final int METADATA_SPATIAL_AUDIO = 24;
    public static final int METADATA_FAST_PAIR_CUSTOMIZED_FIELDS = 25;
    @SystemApi
    public static final String DEVICE_TYPE_DEFAULT = "Default";
    @SystemApi
    public static final String DEVICE_TYPE_WATCH = "Watch";
    @SystemApi
    public static final String DEVICE_TYPE_UNTETHERED_HEADSET = "Untethered Headset";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_UUID = "android.bluetooth.device.action.UUID";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_MAS_INSTANCE = "android.bluetooth.device.action.MAS_INSTANCE";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_NAME_FAILED = "android.bluetooth.device.action.NAME_FAILED";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_PAIRING_REQUEST = "android.bluetooth.device.action.PAIRING_REQUEST";
    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"ActionValue"})
    public static final String ACTION_PAIRING_CANCEL = "android.bluetooth.device.action.PAIRING_CANCEL";
    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"ActionValue"})
    public static final String ACTION_CONNECTION_ACCESS_REQUEST = "android.bluetooth.device.action.CONNECTION_ACCESS_REQUEST";
    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"ActionValue"})
    public static final String ACTION_CONNECTION_ACCESS_REPLY = "android.bluetooth.device.action.CONNECTION_ACCESS_REPLY";
    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"ActionValue"})
    public static final String ACTION_CONNECTION_ACCESS_CANCEL = "android.bluetooth.device.action.CONNECTION_ACCESS_CANCEL";
    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_SILENCE_MODE_CHANGED = "android.bluetooth.device.action.SILENCE_MODE_CHANGED";
    @SystemApi
    @SuppressLint(value={"ActionValue"})
    public static final String EXTRA_ACCESS_REQUEST_TYPE = "android.bluetooth.device.extra.ACCESS_REQUEST_TYPE";
    @SystemApi
    public static final int REQUEST_TYPE_PROFILE_CONNECTION = 1;
    @SystemApi
    public static final int REQUEST_TYPE_PHONEBOOK_ACCESS = 2;
    @SystemApi
    public static final int REQUEST_TYPE_MESSAGE_ACCESS = 3;
    @SystemApi
    public static final int REQUEST_TYPE_SIM_ACCESS = 4;
    public static final String EXTRA_PACKAGE_NAME = "android.bluetooth.device.extra.PACKAGE_NAME";
    public static final String EXTRA_CLASS_NAME = "android.bluetooth.device.extra.CLASS_NAME";
    @SystemApi
    @SuppressLint(value={"ActionValue"})
    public static final String EXTRA_CONNECTION_ACCESS_RESULT = "android.bluetooth.device.extra.CONNECTION_ACCESS_RESULT";
    @SystemApi
    public static final int CONNECTION_ACCESS_YES = 1;
    @SystemApi
    public static final int CONNECTION_ACCESS_NO = 2;
    @SystemApi
    @SuppressLint(value={"ActionValue"})
    public static final String EXTRA_ALWAYS_ALLOWED = "android.bluetooth.device.extra.ALWAYS_ALLOWED";
    public static final int BOND_SUCCESS = 0;
    @SystemApi
    public static final int UNBOND_REASON_AUTH_FAILED = 1;
    @SystemApi
    public static final int UNBOND_REASON_AUTH_REJECTED = 2;
    @SystemApi
    public static final int UNBOND_REASON_AUTH_CANCELED = 3;
    @SystemApi
    public static final int UNBOND_REASON_REMOTE_DEVICE_DOWN = 4;
    @SystemApi
    public static final int UNBOND_REASON_DISCOVERY_IN_PROGRESS = 5;
    @SystemApi
    public static final int UNBOND_REASON_AUTH_TIMEOUT = 6;
    @SystemApi
    public static final int UNBOND_REASON_REPEATED_ATTEMPTS = 7;
    @SystemApi
    public static final int UNBOND_REASON_REMOTE_AUTH_CANCELED = 8;
    @SystemApi
    public static final int UNBOND_REASON_REMOVED = 9;
    public static final int PAIRING_VARIANT_PIN = 0;
    @SystemApi
    public static final int PAIRING_VARIANT_PASSKEY = 1;
    public static final int PAIRING_VARIANT_PASSKEY_CONFIRMATION = 2;
    @SystemApi
    public static final int PAIRING_VARIANT_CONSENT = 3;
    @SystemApi
    public static final int PAIRING_VARIANT_DISPLAY_PASSKEY = 4;
    @SystemApi
    public static final int PAIRING_VARIANT_DISPLAY_PIN = 5;
    @SystemApi
    public static final int PAIRING_VARIANT_OOB_CONSENT = 6;
    @SystemApi
    public static final int PAIRING_VARIANT_PIN_16_DIGITS = 7;
    public static final String EXTRA_UUID = "android.bluetooth.device.extra.UUID";
    public static final String EXTRA_SDP_RECORD = "android.bluetooth.device.extra.SDP_RECORD";
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final String EXTRA_SDP_SEARCH_STATUS = "android.bluetooth.device.extra.SDP_SEARCH_STATUS";
    @SystemApi
    public static final int ACCESS_UNKNOWN = 0;
    @SystemApi
    public static final int ACCESS_ALLOWED = 1;
    @SystemApi
    public static final int ACCESS_REJECTED = 2;
    public static final int TRANSPORT_AUTO = 0;
    public static final int TRANSPORT_BREDR = 1;
    public static final int TRANSPORT_LE = 2;
    public static final int PHY_LE_1M = 1;
    public static final int PHY_LE_2M = 2;
    public static final int PHY_LE_CODED = 3;
    public static final int PHY_LE_1M_MASK = 1;
    public static final int PHY_LE_2M_MASK = 2;
    public static final int PHY_LE_CODED_MASK = 4;
    public static final int PHY_OPTION_NO_PREFERRED = 0;
    public static final int PHY_OPTION_S2 = 1;
    public static final int PHY_OPTION_S8 = 2;
    public static final String EXTRA_MAS_INSTANCE = "android.bluetooth.device.extra.MAS_INSTANCE";
    @SuppressLint(value={"ActionValue"})
    public static final String EXTRA_TRANSPORT = "android.bluetooth.device.extra.TRANSPORT";
    public static final int ADDRESS_TYPE_PUBLIC = 0;
    public static final int ADDRESS_TYPE_RANDOM = 1;
    public static final int ADDRESS_TYPE_UNKNOWN = 65535;
    private static final String NULL_MAC_ADDRESS = "00:00:00:00:00:00";
    private static volatile IBluetooth sService;
    private final String mAddress;
    private final int mAddressType;
    private AttributionSource mAttributionSource;
    static IBluetoothManagerCallback sStateChangeCallback;
    public static final Parcelable.Creator<BluetoothDevice> CREATOR;
    private final IpcDataCache.QueryHandler<Pair<IBluetooth, BluetoothDevice>, Integer> mBluetoothBondQuery = new IpcDataCache.QueryHandler<Pair<IBluetooth, BluetoothDevice>, Integer>(){

        @Override
        @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
        public Integer apply(Pair<IBluetooth, BluetoothDevice> pairQuery) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                ((IBluetooth)pairQuery.first).getBondState((BluetoothDevice)pairQuery.second, BluetoothDevice.this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(10);
            }
            catch (RemoteException | TimeoutException e) {
                throw new RuntimeException(e);
            }
        }
    };
    private static final String GET_BOND_STATE_API = "BluetoothDevice_getBondState";
    private final BluetoothCache<Pair<IBluetooth, BluetoothDevice>, Integer> mBluetoothBondCache = new BluetoothCache("BluetoothDevice_getBondState", this.mBluetoothBondQuery);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IBluetooth getService() {
        Class<BluetoothDevice> clazz = BluetoothDevice.class;
        synchronized (BluetoothDevice.class) {
            if (sService == null) {
                BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
                sService = adapter.getBluetoothService(sStateChangeCallback);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sService;
        }
    }

    BluetoothDevice(String address, int addressType) {
        BluetoothDevice.getService();
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            throw new IllegalArgumentException(address + " is not a valid Bluetooth address");
        }
        if (addressType != 0 && addressType != 1) {
            throw new IllegalArgumentException(addressType + " is not a Bluetooth address type");
        }
        this.mAddress = address;
        this.mAddressType = addressType;
        this.mAttributionSource = AttributionSource.myAttributionSource();
    }

    @UnsupportedAppUsage
    BluetoothDevice(String address) {
        this(address, 0);
    }

    @Override
    public void setAttributionSource(AttributionSource attributionSource) {
        this.mAttributionSource = attributionSource;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public void prepareToEnterProcess(AttributionSource attributionSource) {
        this.setAttributionSource(attributionSource);
    }

    public boolean equals(Object o) {
        if (o instanceof BluetoothDevice) {
            return this.mAddress.equals(((BluetoothDevice)o).getAddress());
        }
        return false;
    }

    public int hashCode() {
        return this.mAddress.hashCode();
    }

    public String toString() {
        return this.mAddress;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.mAddress);
    }

    public String getAddress() {
        return this.mAddress;
    }

    public int getAddressType() {
        return this.mAddressType;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public String getAnonymizedAddress() {
        return "XX:XX:XX" + this.getAddress().substring(8);
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public String getIdentityAddress() {
        IBluetooth service = sService;
        String defaultValue = null;
        if (service == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "BT not enabled. Cannot get identity address");
        } else {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getIdentityAddress(this.mAddress, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return defaultValue;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public String getName() {
        IBluetooth service = sService;
        String defaultValue = null;
        if (service == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "BT not enabled. Cannot get Remote Device name");
        } else {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getRemoteName(this, this.mAttributionSource, recv);
                String name = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(defaultValue);
                if (name != null) {
                    return name.replace('\t', ' ').replace('\n', ' ').replace('\r', ' ');
                }
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return defaultValue;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getType() {
        IBluetooth service = sService;
        boolean defaultValue = false;
        if (service == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "BT not enabled. Cannot get Remote Device type");
        } else {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getRemoteType(this, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(0);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return 0;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public String getAlias() {
        IBluetooth service = sService;
        String defaultValue = null;
        if (service == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "BT not enabled. Cannot get Remote Device Alias");
        } else {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getRemoteAliasWithAttribution(this, this.mAttributionSource, recv);
                String alias = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(defaultValue);
                if (alias == null) {
                    return this.getName();
                }
                return alias.replace('\t', ' ').replace('\n', ' ').replace('\r', ' ');
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return defaultValue;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int setAlias(String alias) {
        if (alias != null && alias.isEmpty()) {
            throw new IllegalArgumentException("alias cannot be the empty string");
        }
        IBluetooth service = sService;
        boolean defaultValue = true;
        if (service == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "BT not enabled. Cannot set Remote Device name");
        } else {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.setRemoteAlias(this, alias, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(1);
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
            catch (RemoteException e) {
                Log.e(TAG, "", e);
                throw e.rethrowFromSystemServer();
            }
        }
        return 1;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getBatteryLevel() {
        IBluetooth service = sService;
        int defaultValue = -100;
        if (service == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "Bluetooth disabled. Cannot get remote device battery level");
        } else {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getBatteryLevel(this, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(-100);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return -100;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean createBond() {
        return this.createBond(0);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean createBond(int transport) {
        return this.createBondInternal(transport, null, null);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean createBondOutOfBand(int transport, OobData remoteP192Data, OobData remoteP256Data) {
        if (remoteP192Data == null && remoteP256Data == null) {
            throw new IllegalArgumentException("One or both arguments for the OOB data types are required to not be null.  Please use createBond() instead if you do not have OOB data to pass.");
        }
        return this.createBondInternal(transport, remoteP192Data, remoteP256Data);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    private boolean createBondInternal(int transport, OobData remoteP192Data, OobData remoteP256Data) {
        IBluetooth service = sService;
        boolean defaultValue = false;
        if (service == null || !this.isBluetoothEnabled()) {
            Log.w(TAG, "BT not enabled, createBondOutOfBand failed");
        } else if (NULL_MAC_ADDRESS.equals(this.mAddress)) {
            Log.e(TAG, "Unable to create bond, invalid address " + this.mAddress);
        } else {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.createBond(this, transport, remoteP192Data, remoteP256Data, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean isBondingInitiatedLocally() {
        IBluetooth service = sService;
        boolean defaultValue = false;
        if (service == null || !this.isBluetoothEnabled()) {
            Log.w(TAG, "BT not enabled, isBondingInitiatedLocally failed");
        } else {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.isBondingInitiatedLocally(this, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean cancelBondProcess() {
        IBluetooth service = sService;
        boolean defaultValue = false;
        if (service == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "BT not enabled. Cannot cancel Remote Device bond");
        } else {
            Log.i(TAG, "cancelBondProcess() for device " + this.getAddress() + " called by pid: " + Process.myPid() + " tid: " + Process.myTid());
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.cancelBondProcess(this, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean removeBond() {
        IBluetooth service = sService;
        boolean defaultValue = false;
        if (service == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "BT not enabled. Cannot remove Remote Device bond");
        } else {
            Log.i(TAG, "removeBond() for device " + this.getAddress() + " called by pid: " + Process.myPid() + " tid: " + Process.myTid());
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.removeBond(this, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    private static void invalidateCache(String api) {
        IpcDataCache.invalidateCache("bluetooth", api);
    }

    public void disableBluetoothGetBondStateCache() {
        this.mBluetoothBondCache.disableForCurrentProcess();
    }

    public static void invalidateBluetoothGetBondStateCache() {
        BluetoothDevice.invalidateCache(GET_BOND_STATE_API);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
    public int getBondState() {
        IBluetooth service = sService;
        if (service == null) {
            Log.e(TAG, "BT not enabled. Cannot get bond state");
        } else {
            try {
                return (Integer)this.mBluetoothBondCache.query(new Pair<IBluetooth, BluetoothDevice>(service, this));
            }
            catch (RuntimeException e) {
                if (!(e.getCause() instanceof TimeoutException) && !(e.getCause() instanceof RemoteException)) {
                    throw e;
                }
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return 10;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean canBondWithoutDialog() {
        IBluetooth service = sService;
        boolean defaultValue = false;
        if (service == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "BT not enabled. Cannot check if we can skip pairing dialog");
        } else {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.canBondWithoutDialog(this, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED", "android.permission.MODIFY_PHONE_STATE"})
    public int connect() {
        if (!BluetoothAdapter.checkBluetoothAddress(this.getAddress())) {
            throw new IllegalArgumentException("device cannot have an invalid address");
        }
        IBluetooth service = sService;
        boolean defaultValue = true;
        if (service == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "BT not enabled. Cannot connect to remote device.");
        } else {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.connectAllEnabledProfiles(this, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(1);
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
            catch (RemoteException e) {
                Log.e(TAG, "", e);
                throw e.rethrowFromSystemServer();
            }
        }
        return 1;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int disconnect() {
        if (!BluetoothAdapter.checkBluetoothAddress(this.getAddress())) {
            throw new IllegalArgumentException("device cannot have an invalid address");
        }
        IBluetooth service = sService;
        boolean defaultValue = true;
        if (service == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "BT not enabled. Cannot disconnect to remote device.");
        } else {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.disconnectAllEnabledProfiles(this, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(1);
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
            catch (RemoteException e) {
                Log.e(TAG, "", e);
                throw e.rethrowFromSystemServer();
            }
        }
        return 1;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean isConnected() {
        IBluetooth service = sService;
        boolean defaultValue = false;
        if (service == null || !this.isBluetoothEnabled()) {
            Log.w(TAG, "Proxy not attached to service");
        } else {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getConnectionStateWithAttribution(this, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(0) != 0;
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean isEncrypted() {
        IBluetooth service = sService;
        boolean defaultValue = false;
        if (service == null || !this.isBluetoothEnabled()) {
            Log.w(TAG, "Proxy not attached to service");
        } else {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getConnectionStateWithAttribution(this, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(0) > 1;
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothClass getBluetoothClass() {
        IBluetooth service = sService;
        boolean defaultValue = false;
        if (service == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "BT not enabled. Cannot get Bluetooth Class");
        } else {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getRemoteClass(this, this.mAttributionSource, recv);
                int classInt = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(0);
                if (classInt == -16777216) {
                    return null;
                }
                return new BluetoothClass(classInt);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return null;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public ParcelUuid[] getUuids() {
        IBluetooth service = sService;
        ParcelUuid[] defaultValue = null;
        if (service == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "BT not enabled. Cannot get remote device Uuids");
        } else {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getRemoteUuids(this, this.mAttributionSource, recv);
                List parcels = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
                return parcels != null ? parcels.toArray(new ParcelUuid[parcels.size()]) : null;
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return defaultValue;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean fetchUuidsWithSdp() {
        return this.fetchUuidsWithSdp(0);
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean fetchUuidsWithSdp(int transport) {
        IBluetooth service = sService;
        boolean defaultValue = false;
        if (service == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "BT not enabled. Cannot fetchUuidsWithSdp");
        } else {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.fetchRemoteUuidsWithAttribution(this, transport, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean sdpSearch(ParcelUuid uuid) {
        IBluetooth service = sService;
        boolean defaultValue = false;
        if (service == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "BT not enabled. Cannot query remote device sdp records");
        } else {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.sdpSearch(this, uuid, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean setPin(byte[] pin) {
        IBluetooth service = sService;
        boolean defaultValue = false;
        if (service == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "BT not enabled. Cannot set Remote Device pin");
        } else {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.setPin(this, true, pin.length, pin, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean setPin(String pin) {
        byte[] pinBytes = BluetoothDevice.convertPinToBytes(pin);
        if (pinBytes == null) {
            return false;
        }
        return this.setPin(pinBytes);
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setPairingConfirmation(boolean confirm) {
        IBluetooth service = sService;
        boolean defaultValue = false;
        if (service == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "BT not enabled. Cannot set pairing confirmation");
        } else {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.setPairingConfirmation(this, confirm, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    boolean isBluetoothEnabled() {
        boolean ret = false;
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter != null && adapter.isEnabled()) {
            ret = true;
        }
        return ret;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getPhonebookAccessPermission() {
        IBluetooth service = sService;
        boolean defaultValue = false;
        if (service == null || !this.isBluetoothEnabled()) {
            Log.w(TAG, "Proxy not attached to service");
        } else {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getPhonebookAccessPermission(this, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(0);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return 0;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setSilenceMode(boolean silence) {
        IBluetooth service = sService;
        boolean defaultValue = false;
        if (service == null || !this.isBluetoothEnabled()) {
            throw new IllegalStateException("Bluetooth is not turned ON");
        }
        try {
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            service.setSilenceMode(this, silence, this.mAttributionSource, recv);
            return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            return false;
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean isInSilenceMode() {
        IBluetooth service = sService;
        boolean defaultValue = false;
        if (service == null || !this.isBluetoothEnabled()) {
            throw new IllegalStateException("Bluetooth is not turned ON");
        }
        try {
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            service.getSilenceMode(this, this.mAttributionSource, recv);
            return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            return false;
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setPhonebookAccessPermission(int value) {
        IBluetooth service = sService;
        boolean defaultValue = false;
        if (service == null || !this.isBluetoothEnabled()) {
            Log.w(TAG, "Proxy not attached to service");
        } else {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.setPhonebookAccessPermission(this, value, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getMessageAccessPermission() {
        IBluetooth service = sService;
        boolean defaultValue = false;
        if (service == null || !this.isBluetoothEnabled()) {
            Log.w(TAG, "Proxy not attached to service");
        } else {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getMessageAccessPermission(this, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(0);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return 0;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setMessageAccessPermission(int value) {
        if (value != 1 && value != 2 && value != 0) {
            throw new IllegalArgumentException(value + "is not a valid AccessPermission value");
        }
        IBluetooth service = sService;
        boolean defaultValue = false;
        if (service == null || !this.isBluetoothEnabled()) {
            Log.w(TAG, "Proxy not attached to service");
        } else {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.setMessageAccessPermission(this, value, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getSimAccessPermission() {
        IBluetooth service = sService;
        boolean defaultValue = false;
        if (service == null || !this.isBluetoothEnabled()) {
            Log.w(TAG, "Proxy not attached to service");
        } else {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getSimAccessPermission(this, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(0);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return 0;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setSimAccessPermission(int value) {
        IBluetooth service = sService;
        boolean defaultValue = false;
        if (service == null || !this.isBluetoothEnabled()) {
            Log.w(TAG, "Proxy not attached to service");
        } else {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.setSimAccessPermission(this, value, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @UnsupportedAppUsage
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
    public BluetoothSocket createRfcommSocket(int channel) throws IOException {
        if (!this.isBluetoothEnabled()) {
            Log.e(TAG, "Bluetooth is not enabled");
            throw new IOException();
        }
        return new BluetoothSocket(1, -1, true, true, this, channel, null);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
    public BluetoothSocket createL2capSocket(int channel) throws IOException {
        return new BluetoothSocket(3, -1, true, true, this, channel, null);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
    public BluetoothSocket createInsecureL2capSocket(int channel) throws IOException {
        return new BluetoothSocket(3, -1, false, false, this, channel, null);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
    public BluetoothSocket createRfcommSocketToServiceRecord(UUID uuid) throws IOException {
        if (!this.isBluetoothEnabled()) {
            Log.e(TAG, "Bluetooth is not enabled");
            throw new IOException();
        }
        return new BluetoothSocket(1, -1, true, true, this, -1, new ParcelUuid(uuid));
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
    public BluetoothSocket createInsecureRfcommSocketToServiceRecord(UUID uuid) throws IOException {
        if (!this.isBluetoothEnabled()) {
            Log.e(TAG, "Bluetooth is not enabled");
            throw new IOException();
        }
        return new BluetoothSocket(1, -1, false, false, this, -1, new ParcelUuid(uuid));
    }

    @UnsupportedAppUsage(publicAlternatives="Use {@link #createInsecureRfcommSocketToServiceRecord} instead.")
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
    public BluetoothSocket createInsecureRfcommSocket(int port) throws IOException {
        if (!this.isBluetoothEnabled()) {
            Log.e(TAG, "Bluetooth is not enabled");
            throw new IOException();
        }
        return new BluetoothSocket(1, -1, false, false, this, port, null);
    }

    @UnsupportedAppUsage
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
    public BluetoothSocket createScoSocket() throws IOException {
        if (!this.isBluetoothEnabled()) {
            Log.e(TAG, "Bluetooth is not enabled");
            throw new IOException();
        }
        return new BluetoothSocket(2, -1, true, true, this, -1, null);
    }

    @UnsupportedAppUsage
    public static byte[] convertPinToBytes(String pin) {
        byte[] pinBytes;
        if (pin == null) {
            return null;
        }
        try {
            pinBytes = pin.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            Log.e(TAG, "UTF-8 not supported?!?");
            return null;
        }
        if (pinBytes.length <= 0 || pinBytes.length > 16) {
            return null;
        }
        return pinBytes;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothGatt connectGatt(Context context, boolean autoConnect, BluetoothGattCallback callback) {
        return this.connectGatt(context, autoConnect, callback, 0);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothGatt connectGatt(Context context, boolean autoConnect, BluetoothGattCallback callback, int transport) {
        return this.connectGatt(context, autoConnect, callback, transport, 1);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothGatt connectGatt(Context context, boolean autoConnect, BluetoothGattCallback callback, int transport, int phy) {
        return this.connectGatt(context, autoConnect, callback, transport, phy, null);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothGatt connectGatt(Context context, boolean autoConnect, BluetoothGattCallback callback, int transport, int phy, Handler handler) {
        return this.connectGatt(context, autoConnect, callback, transport, false, phy, handler);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothGatt connectGatt(Context context, boolean autoConnect, BluetoothGattCallback callback, int transport, boolean opportunistic, int phy, Handler handler) {
        if (callback == null) {
            throw new NullPointerException("callback is null");
        }
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        IBluetoothManager managerService = adapter.getBluetoothManager();
        try {
            IBluetoothGatt iGatt = managerService.getBluetoothGatt();
            if (iGatt == null) {
                return null;
            }
            BluetoothGatt gatt = new BluetoothGatt(iGatt, this, transport, opportunistic, phy, this.mAttributionSource);
            gatt.connect(autoConnect, callback, handler);
            return gatt;
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return null;
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
    public BluetoothSocket createL2capChannel(int psm) throws IOException {
        if (!this.isBluetoothEnabled()) {
            Log.e(TAG, "createL2capChannel: Bluetooth is not enabled");
            throw new IOException();
        }
        return new BluetoothSocket(4, -1, true, true, this, psm, null);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
    public BluetoothSocket createInsecureL2capChannel(int psm) throws IOException {
        if (!this.isBluetoothEnabled()) {
            Log.e(TAG, "createInsecureL2capChannel: Bluetooth is not enabled");
            throw new IOException();
        }
        return new BluetoothSocket(4, -1, false, false, this, psm, null);
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setMetadata(int key, byte[] value) {
        IBluetooth service = sService;
        boolean defaultValue = false;
        if (service == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "Bluetooth is not enabled. Cannot set metadata");
        } else {
            if (value.length > 2048) {
                throw new IllegalArgumentException("value length is " + value.length + ", should not over " + 2048);
            }
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.setMetadata(this, key, value, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public byte[] getMetadata(int key) {
        IBluetooth service = sService;
        Object defaultValue = null;
        if (service == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "Bluetooth is not enabled. Cannot get metadata");
        } else {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getMetadata(this, key, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(defaultValue);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return defaultValue;
    }

    public static int getMaxMetadataKey() {
        return 25;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setLowLatencyAudioAllowed(boolean allowed) {
        IBluetooth service = sService;
        boolean defaultValue = false;
        if (service == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "Bluetooth is not enabled. Cannot allow low latency");
        } else {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.allowLowLatencyAudio(allowed, this, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    private static void log(String msg) {
        Log.d(TAG, msg);
    }

    static {
        sStateChangeCallback = new IBluetoothManagerCallback.Stub(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBluetoothServiceUp(IBluetooth bluetoothService) throws RemoteException {
                Class<BluetoothDevice> clazz = BluetoothDevice.class;
                synchronized (BluetoothDevice.class) {
                    if (sService == null) {
                        sService = bluetoothService;
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBluetoothServiceDown() throws RemoteException {
                Class<BluetoothDevice> clazz = BluetoothDevice.class;
                synchronized (BluetoothDevice.class) {
                    sService = null;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }

            @Override
            public void onBrEdrDown() {
            }

            public void onOobData(int transport, OobData oobData) {
            }
        };
        CREATOR = new Parcelable.Creator<BluetoothDevice>(){

            @Override
            public BluetoothDevice createFromParcel(Parcel in) {
                return new BluetoothDevice(in.readString());
            }

            public BluetoothDevice[] newArray(int size) {
                return new BluetoothDevice[size];
            }
        };
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ConnectionReturnValues {
    }

    private static class BluetoothCache<Q, R>
    extends IpcDataCache<Q, R> {
        BluetoothCache(String api, IpcDataCache.QueryHandler query) {
            super(8, "bluetooth", api, api, query);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SetAliasReturnValues {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AddressType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Transport {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AccessPermission {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MetadataKey {
    }
}

