/*
 * Decompiled with CFR 0.152.
 */
package android.app.timezonedetector;

import android.app.time.ITimeZoneDetectorListener;
import android.app.time.TimeZoneCapabilitiesAndConfig;
import android.app.time.TimeZoneConfiguration;
import android.app.timezonedetector.ManualTimeZoneSuggestion;
import android.app.timezonedetector.TelephonyTimeZoneSuggestion;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ITimeZoneDetectorService
extends IInterface {
    public static final String DESCRIPTOR = "android.app.timezonedetector.ITimeZoneDetectorService";

    public TimeZoneCapabilitiesAndConfig getCapabilitiesAndConfig() throws RemoteException;

    public void addListener(ITimeZoneDetectorListener var1) throws RemoteException;

    public void removeListener(ITimeZoneDetectorListener var1) throws RemoteException;

    public boolean updateConfiguration(TimeZoneConfiguration var1) throws RemoteException;

    public boolean suggestManualTimeZone(ManualTimeZoneSuggestion var1) throws RemoteException;

    public void suggestTelephonyTimeZone(TelephonyTimeZoneSuggestion var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITimeZoneDetectorService {
        static final int TRANSACTION_getCapabilitiesAndConfig = 1;
        static final int TRANSACTION_addListener = 2;
        static final int TRANSACTION_removeListener = 3;
        static final int TRANSACTION_updateConfiguration = 4;
        static final int TRANSACTION_suggestManualTimeZone = 5;
        static final int TRANSACTION_suggestTelephonyTimeZone = 6;

        public Stub() {
            this.attachInterface(this, ITimeZoneDetectorService.DESCRIPTOR);
        }

        public static ITimeZoneDetectorService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ITimeZoneDetectorService.DESCRIPTOR);
            if (iin != null && iin instanceof ITimeZoneDetectorService) {
                return (ITimeZoneDetectorService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getCapabilitiesAndConfig";
                }
                case 2: {
                    return "addListener";
                }
                case 3: {
                    return "removeListener";
                }
                case 4: {
                    return "updateConfiguration";
                }
                case 5: {
                    return "suggestManualTimeZone";
                }
                case 6: {
                    return "suggestTelephonyTimeZone";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ITimeZoneDetectorService.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    TimeZoneCapabilitiesAndConfig _result = this.getCapabilitiesAndConfig();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 2: {
                    ITimeZoneDetectorListener _arg0 = ITimeZoneDetectorListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.addListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    ITimeZoneDetectorListener _arg0 = ITimeZoneDetectorListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    TimeZoneConfiguration _arg0 = data.readTypedObject(TimeZoneConfiguration.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.updateConfiguration(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 5: {
                    ManualTimeZoneSuggestion _arg0 = data.readTypedObject(ManualTimeZoneSuggestion.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.suggestManualTimeZone(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 6: {
                    TelephonyTimeZoneSuggestion _arg0 = data.readTypedObject(TelephonyTimeZoneSuggestion.CREATOR);
                    data.enforceNoDataAvail();
                    this.suggestTelephonyTimeZone(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 5;
        }

        private static class Proxy
        implements ITimeZoneDetectorService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ITimeZoneDetectorService.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public TimeZoneCapabilitiesAndConfig getCapabilitiesAndConfig() throws RemoteException {
                TimeZoneCapabilitiesAndConfig _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITimeZoneDetectorService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(TimeZoneCapabilitiesAndConfig.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addListener(ITimeZoneDetectorListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITimeZoneDetectorService.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeListener(ITimeZoneDetectorListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITimeZoneDetectorService.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean updateConfiguration(TimeZoneConfiguration configuration) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITimeZoneDetectorService.DESCRIPTOR);
                    _data.writeTypedObject(configuration, 0);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean suggestManualTimeZone(ManualTimeZoneSuggestion timeZoneSuggestion) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITimeZoneDetectorService.DESCRIPTOR);
                    _data.writeTypedObject(timeZoneSuggestion, 0);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void suggestTelephonyTimeZone(TelephonyTimeZoneSuggestion timeZoneSuggestion) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITimeZoneDetectorService.DESCRIPTOR);
                    _data.writeTypedObject(timeZoneSuggestion, 0);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITimeZoneDetectorService {
        @Override
        public TimeZoneCapabilitiesAndConfig getCapabilitiesAndConfig() throws RemoteException {
            return null;
        }

        @Override
        public void addListener(ITimeZoneDetectorListener listener) throws RemoteException {
        }

        @Override
        public void removeListener(ITimeZoneDetectorListener listener) throws RemoteException {
        }

        @Override
        public boolean updateConfiguration(TimeZoneConfiguration configuration) throws RemoteException {
            return false;
        }

        @Override
        public boolean suggestManualTimeZone(ManualTimeZoneSuggestion timeZoneSuggestion) throws RemoteException {
            return false;
        }

        @Override
        public void suggestTelephonyTimeZone(TelephonyTimeZoneSuggestion timeZoneSuggestion) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

