/*
 * Decompiled with CFR 0.152.
 */
package android.app.time;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.TimestampedValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@SystemApi
public class ExternalTimeSuggestion
implements Parcelable {
    public static final Parcelable.Creator<ExternalTimeSuggestion> CREATOR = new Parcelable.Creator<ExternalTimeSuggestion>(){

        @Override
        public ExternalTimeSuggestion createFromParcel(Parcel in) {
            return ExternalTimeSuggestion.createFromParcel(in);
        }

        public ExternalTimeSuggestion[] newArray(int size) {
            return new ExternalTimeSuggestion[size];
        }
    };
    private final TimestampedValue<Long> mUnixEpochTime;
    private ArrayList<String> mDebugInfo;

    public ExternalTimeSuggestion(long elapsedRealtimeMillis, long suggestionMillis) {
        this.mUnixEpochTime = new TimestampedValue<Long>(elapsedRealtimeMillis, suggestionMillis);
    }

    private static ExternalTimeSuggestion createFromParcel(Parcel in) {
        TimestampedValue utcTime = in.readParcelable(null, TimestampedValue.class);
        ExternalTimeSuggestion suggestion = new ExternalTimeSuggestion(utcTime.getReferenceTimeMillis(), (Long)utcTime.getValue());
        ArrayList<String> debugInfo = in.readArrayList(null, String.class);
        suggestion.mDebugInfo = debugInfo;
        return suggestion;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.mUnixEpochTime, 0);
        dest.writeList(this.mDebugInfo);
    }

    public TimestampedValue<Long> getUnixEpochTime() {
        return this.mUnixEpochTime;
    }

    public List<String> getDebugInfo() {
        return this.mDebugInfo == null ? Collections.emptyList() : Collections.unmodifiableList(this.mDebugInfo);
    }

    public void addDebugInfo(String ... debugInfos) {
        if (this.mDebugInfo == null) {
            this.mDebugInfo = new ArrayList();
        }
        this.mDebugInfo.addAll(Arrays.asList(debugInfos));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalTimeSuggestion that = (ExternalTimeSuggestion)o;
        return Objects.equals(this.mUnixEpochTime, that.mUnixEpochTime);
    }

    public int hashCode() {
        return Objects.hash(this.mUnixEpochTime);
    }

    public String toString() {
        return "ExternalTimeSuggestion{mUnixEpochTime=" + this.mUnixEpochTime + ", mDebugInfo=" + this.mDebugInfo + '}';
    }
}

