/*
 * Decompiled with CFR 0.152.
 */
package android.app.smartspace.uitemplatedata;

import android.annotation.SystemApi;
import android.app.smartspace.SmartspaceUtils;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.util.Objects;

@SystemApi
public class Text
implements Parcelable {
    private final CharSequence mText;
    private final TextUtils.TruncateAt mTruncateAtType;
    private final int mMaxLines;
    public static final Parcelable.Creator<Text> CREATOR = new Parcelable.Creator<Text>(){

        @Override
        public Text createFromParcel(Parcel in) {
            return new Text(in);
        }

        public Text[] newArray(int size) {
            return new Text[size];
        }
    };

    Text(Parcel in) {
        this.mText = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
        this.mTruncateAtType = TextUtils.TruncateAt.valueOf(in.readString());
        this.mMaxLines = in.readInt();
    }

    private Text(CharSequence text, TextUtils.TruncateAt truncateAtType, int maxLines) {
        this.mText = text;
        this.mTruncateAtType = truncateAtType;
        this.mMaxLines = maxLines;
    }

    public CharSequence getText() {
        return this.mText;
    }

    public TextUtils.TruncateAt getTruncateAtType() {
        return this.mTruncateAtType;
    }

    public int getMaxLines() {
        return this.mMaxLines;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Text)) {
            return false;
        }
        Text that = (Text)o;
        return this.mTruncateAtType == that.mTruncateAtType && SmartspaceUtils.isEqual(this.mText, that.mText) && this.mMaxLines == that.mMaxLines;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mText, this.mTruncateAtType, this.mMaxLines});
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        TextUtils.writeToParcel(this.mText, out, flags);
        out.writeString(this.mTruncateAtType.name());
        out.writeInt(this.mMaxLines);
    }

    public String toString() {
        return "Text{mText=" + this.mText + ", mTruncateAtType=" + (Object)((Object)this.mTruncateAtType) + ", mMaxLines=" + this.mMaxLines + '}';
    }

    @SystemApi
    public static class Builder {
        private final CharSequence mText;
        private TextUtils.TruncateAt mTruncateAtType;
        private int mMaxLines;

        public Builder(CharSequence text) {
            this.mText = Objects.requireNonNull(text);
            this.mTruncateAtType = TextUtils.TruncateAt.END;
            this.mMaxLines = 1;
        }

        public Builder setTruncateAtType(TextUtils.TruncateAt truncateAtType) {
            this.mTruncateAtType = Objects.requireNonNull(truncateAtType);
            return this;
        }

        public Builder setMaxLines(int maxLines) {
            this.mMaxLines = maxLines;
            return this;
        }

        public Text build() {
            return new Text(this.mText, this.mTruncateAtType, this.mMaxLines);
        }
    }
}

